/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ingres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class IngresSynonymReader
implements SynonymReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("SELECT synonym_owner, synonym_name FROM iisynonyms ");
        if (string2 != null) {
            stringBuilder.append(" WHERE synonym_owner = ?");
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonyms", stringBuilder, new Object[0]);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(stringBuilder.toString());
            if (string2 != null) {
                preparedStatement.setString(1, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                if (string5 == null) continue;
                TableIdentifier tableIdentifier = new TableIdentifier(string4.trim(), string5.trim());
                tableIdentifier.setNeverAdjustCase(true);
                tableIdentifier.setType("SYNONYM");
                arrayList.add(tableIdentifier);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "synonyms", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT synonym_name, table_owner, table_name \nFROM iisynonyms \nWHERE synonym_name = ? \n   AND synonym_owner = ? ";
        PreparedStatement preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string4, new Object[0]);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string5 = null;
        String string6 = null;
        TableIdentifier tableIdentifier = null;
        try {
            if (resultSet.next()) {
                string6 = resultSet.getString(2);
                string5 = resultSet.getString(3);
                if (string5 != null) {
                    tableIdentifier = new TableIdentifier(null, string6, string5);
                }
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym table", string4, new Object[0]);
            throw sQLException;
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        return tableIdentifier;
    }
}

