/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mariadb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class MariaDBSequenceReader
implements SequenceReader {
    private WbConnection dbConnection;

    public MariaDBSequenceReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        return new ArrayList<SequenceDefinition>();
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        return sequenceDefinition.getSource();
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        SequenceDefinition sequenceDefinition = this.createSequenceDefinition(string, string2, string3, dataStore, 0);
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        String string4 = StringUtil.coalesce(StringUtil.trimToNull(string), StringUtil.trimToNull(string2));
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        String string5 = "select * \nfrom " + dbMetadata.quoteObjectname(string4) + "." + dbMetadata.quoteObjectname(string3);
        LogMgr.logMetadataSql(new CallerInfo(){}, "SEQUENCE DEFINITION", string5, new Object[0]);
        ResultSet resultSet = null;
        Statement statement = null;
        DataStore dataStore = null;
        try {
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string5);
            dataStore = new DataStore(resultSet, this.dbConnection, true);
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "SEQUENCE DEFINITION", string5, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }

    private SequenceDefinition createSequenceDefinition(String string, String string2, String string3, DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        sequenceDefinition = new SequenceDefinition(string, string2, string3);
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "start_value"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "maximum_value"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "minimum_value"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "increment"));
        sequenceDefinition.setSequenceProperty("cycle", dataStore.getValue(n, "cycle_option"));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "cache_size"));
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    protected CharSequence buildSource(SequenceDefinition sequenceDefinition) {
        Boolean bl;
        Number number;
        Number number2;
        Number number3;
        Number number4;
        if (sequenceDefinition == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append(sequenceDefinition.getSequenceName());
        Number number5 = (Number)sequenceDefinition.getSequenceProperty("start_value");
        if (number5 != null && number5.longValue() > 1L) {
            stringBuilder.append(string);
            stringBuilder.append("       START ");
            stringBuilder.append(number5);
        }
        if ((number4 = (Number)sequenceDefinition.getSequenceProperty("increment")) != null && number4.longValue() > 1L) {
            stringBuilder.append(string);
            stringBuilder.append("       INCREMENT BY ");
            stringBuilder.append(number4);
        }
        if ((number3 = (Number)sequenceDefinition.getSequenceProperty("min_value")) != null && number3.longValue() != 1L && number3.longValue() != -9223372036854775807L) {
            stringBuilder.append(string);
            stringBuilder.append("       MINVALUE ");
            stringBuilder.append(number3);
        }
        if ((number2 = (Number)sequenceDefinition.getSequenceProperty("max_value")) != null && number2.longValue() != -1L && number2.longValue() != 0x7FFFFFFFFFFFFFFEL) {
            stringBuilder.append(string);
            stringBuilder.append("       MAXVALUE ");
            stringBuilder.append(number2);
        }
        if ((number = (Number)sequenceDefinition.getSequenceProperty("cache")) != null && number.longValue() != 1000L) {
            stringBuilder.append(string);
            stringBuilder.append("       CACHE ");
            stringBuilder.append(number);
        }
        if ((bl = (Boolean)sequenceDefinition.getSequenceProperty("cycle")) != null && bl.booleanValue()) {
            stringBuilder.append(string);
            stringBuilder.append("       CYCLE");
        }
        stringBuilder.append(';');
        stringBuilder.append(string);
        return stringBuilder;
    }
}

