/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ClasspathUtil;
import workbench.util.PlatformHelper;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class SqlServerClassLoader
extends URLClassLoader {
    private final WbFile jardir;

    public SqlServerClassLoader(WbFile wbFile, URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        this.jardir = wbFile;
    }

    @Override
    protected String findLibrary(String string) {
        String string2 = super.findLibrary(string);
        if (string2 != null || string == null) {
            return string2;
        }
        String string3 = PlatformHelper.isWindows() ? ".dll" : ".so";
        File file = this.searchLibrary(string);
        WbFile wbFile = new WbFile(file, string + string3);
        if (wbFile != null) {
            return wbFile.getFullPath();
        }
        return null;
    }

    private File searchLibrary(String string) {
        Object object;
        String string2;
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logInfo(callerInfo, "Native library \"" + string + "\" requested.");
        ClasspathUtil classpathUtil = new ClasspathUtil();
        String string3 = ".dll";
        String string4 = null;
        if (PlatformHelper.isWindows()) {
            string = string.toLowerCase();
            string4 = string + string3;
        } else {
            string3 = ".so";
            string4 = string + string3;
        }
        File file = new File(classpathUtil.getJarDir(), string4);
        if (file.exists()) {
            LogMgr.logInfo(callerInfo, "Found library \"" + string4 + "\" in: " + classpathUtil.getJarDir());
            return classpathUtil.getJarDir();
        }
        file = new File(classpathUtil.getExtDir(), string4);
        if (file.exists()) {
            LogMgr.logInfo(callerInfo, "Found library \"" + string4 + "\" in: " + classpathUtil.getExtDir());
            return classpathUtil.getExtDir();
        }
        if (this.jardir != null) {
            Object object2;
            boolean bl = System.getProperty("os.arch").equals("amd64");
            string2 = bl ? "x64" : "x86";
            object = new WbFile(this.jardir, "auth\\" + string2);
            if (!object.exists()) {
                object = new WbFile(this.jardir, "..\\auth\\" + string2);
            }
            if (((File)(object2 = new WbFile((File)object, string4))).exists()) {
                LogMgr.logInfo(callerInfo, "Found library \"" + string4 + "\" in: " + object);
                return object;
            }
        }
        String string5 = System.getProperty("java.library.path");
        LogMgr.logDebug(callerInfo, "Searching for \"" + string4 + "\" on library.path: " + string5);
        string2 = StringUtil.quoteRegexMeta(File.pathSeparator);
        object = string5.split(string2);
        for (String string6 : object) {
            File file2 = new File(string6);
            if (!this.authDLLExists(file2, string, string3)) continue;
            LogMgr.logInfo(callerInfo, "Found library " + string + " in: \"" + file2 + "\"");
            return file2;
        }
        return null;
    }

    private boolean authDLLExists(File file2, String string, String string2) {
        if (file2 == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        FilenameFilter filenameFilter = (file, string3) -> string3 != null && string3.toLowerCase().contains(string) && string3.toLowerCase().endsWith(string2);
        String[] stringArray = file2.list(filenameFilter);
        return stringArray != null && stringArray.length != 0;
    }
}

