/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SqlServerColumnEnhancer
implements ColumnDefinitionEnhancer {
    private Map<String, String> defaultCollations = new HashMap<String, String>();

    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        if (SqlServerUtil.isSqlServer2000(wbConnection)) {
            this.updateColumnInformation(tableDefinition, wbConnection);
        }
        if (wbConnection.getDbSettings().getBoolProperty("remarks.column.retrieve", true)) {
            this.updateColumnRemarks(tableDefinition, wbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateColumnInformation(TableDefinition tableDefinition, WbConnection wbConnection) {
        String string;
        String string2;
        if (SqlServerUtil.isSqlServer2005(wbConnection)) {
            string2 = "select c.name as column_name, \n       cc.definition, \n       cc.is_persisted, \n       t.name as data_type, \n       t.is_user_defined, \n       c.collation_name \nfrom sys.columns c \n  left join sys.types t on c.user_type_id = t.user_type_id \n  left join sys.computed_columns cc on cc.column_id = c.column_id and cc.object_id = c.object_id \nwhere c.object_id = object_id(?)";
            string = tableDefinition.getTable().getTableExpression(wbConnection);
        } else {
            string2 = "select c.name, t.[text], 0 as is_persisted, null as data_type, 0 as is_user_defined, c.collation \nfrom sysobjects o with (nolock) \n  join syscolumns c with (nolock) on o.id = c.id \n  left join syscomments t with (nolock) on t.number = c.colid and t.id = c.id \nwhere o.xtype = 'U' \n  and o.name = ?";
            string = tableDefinition.getTable().getRawTableName();
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "column information", string2, string);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = this.getDatabaseCollation(tableDefinition.getTable().getRawCatalog(), wbConnection);
        String string4 = wbConnection.getDbSettings().getProperty("adjust.datatypes", "geometry,geography");
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(StringUtil.stringToList(string4, ",", true, true));
        List<ColumnIdentifier> list = tableDefinition.getColumns();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = StringUtil.trim(resultSet.getString(2));
                boolean bl = resultSet.getBoolean(3);
                String string7 = resultSet.getString(4);
                boolean bl2 = resultSet.getBoolean(5);
                String string8 = resultSet.getString(6);
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string5);
                if (columnIdentifier == null) continue;
                if (StringUtil.isNonEmpty(string6)) {
                    if (!string6.startsWith("(")) {
                        string6 = string6 + "(" + string6 + ")";
                    }
                    string6 = "AS " + string6;
                    if (bl) {
                        string6 = string6 + " PERSISTED";
                    }
                    columnIdentifier.setComputedColumnExpression(string6);
                    columnIdentifier.setIsGenerated(true);
                }
                if (this.isNonDefault(string8, string3)) {
                    String string9 = columnIdentifier.getDbmsType() + " COLLATE " + string8;
                    columnIdentifier.setDbmsType(string9);
                    columnIdentifier.setCollation(string8);
                }
                if (bl2) {
                    columnIdentifier.setDefaultClause(null);
                    columnIdentifier.setDefaultValue(null);
                    columnIdentifier.setDbmsType(string7);
                }
                if (set.contains(string7)) {
                    columnIdentifier.setDbmsType(string7);
                    columnIdentifier.setDataType(1111);
                }
                columnIdentifier.setIsIdentity(columnIdentifier.getDbmsType().toLowerCase().contains("identity"));
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column information", string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseCollation(String string, WbConnection wbConnection) {
        ResultSet resultSet;
        Statement statement;
        String string2;
        block5: {
            string2 = this.defaultCollations.get(string);
            if (string2 != null) {
                return string2;
            }
            statement = null;
            resultSet = null;
            String string3 = "select cast(databasepropertyex('" + string + "', 'Collation') as varchar(128))";
            try {
                LogMgr.logMetadataSql(new CallerInfo(){}, "database collation", string3, new Object[0]);
                statement = wbConnection.createStatement();
                resultSet = statement.executeQuery(string3);
                if (!resultSet.next()) break block5;
                string2 = resultSet.getString(1);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "database collation", string3, new Object[0]);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        this.defaultCollations.put(string, string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateColumnRemarks(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SqlUtil.removeObjectQuotes(tableDefinition.getTable().getTableName());
        String string2 = SqlUtil.removeObjectQuotes(tableDefinition.getTable().getSchema());
        String string3 = wbConnection.getDbSettings().getProperty("remarks.propertyname", "MS_DESCRIPTION");
        String string4 = "SELECT objname, cast(value as varchar(8000)) as value \nFROM ";
        string4 = SqlServerUtil.isSqlServer2005(wbConnection) ? string4 + "fn_listextendedproperty ('" + string3 + "','schema', ?, 'table', ?, 'column', null)" : string4 + "::fn_listextendedproperty ('" + string3 + "','user', ?, 'table', ?, 'column', null)";
        LogMgr.logMetadataSql(new CallerInfo(){}, "column remarks", string4, string2, string);
        List<ColumnIdentifier> list = tableDefinition.getColumns();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ColumnIdentifier columnIdentifier;
                String string5 = StringUtil.trim(resultSet.getString(1));
                String string6 = resultSet.getString(2);
                if (string5 == null || string6 == null || (columnIdentifier = ColumnIdentifier.findColumnInList(list, string5)) == null) continue;
                columnIdentifier.setComment(string6);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column remarks", string4, string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    private boolean isNonDefault(String string, String string2) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        return !string.equals(string2);
    }
}

