/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataConverter;
import workbench.util.NumberStringCache;

public class SqlServerDataConverter
implements DataConverter {
    private boolean convertVarbinary = Settings.getInstance().getBoolProperty("workbench.db.microsoft_sql_server.converter.varbinary", false);

    public static SqlServerDataConverter getInstance() {
        return LazyInstanceHolder.instance;
    }

    private SqlServerDataConverter() {
    }

    @Override
    public Class getConvertedClass(int n, String string) {
        if (this.convertsType(n, string)) {
            return String.class;
        }
        return null;
    }

    @Override
    public boolean convertsType(int n, String string) {
        if (n == -2) {
            return string.equals("timestamp");
        }
        if (n == -3) {
            return this.convertVarbinary && !string.equalsIgnoreCase("varbinary(max)");
        }
        return false;
    }

    @Override
    public Object convertValue(int n, String string, Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (!this.convertsType(n, string)) {
            return object;
        }
        try {
            byte[] byArray = (byte[])object;
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2 + 2);
            stringBuilder.append("0x");
            for (int n2 : byArray) {
                int n3 = n2 < 0 ? 256 + n2 : n2;
                stringBuilder.append(NumberStringCache.getHexString(n3));
            }
            object2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error converting value " + object, throwable);
            object2 = object;
        }
        return object2;
    }

    private static class LazyInstanceHolder {
        protected static final SqlServerDataConverter instance = new SqlServerDataConverter();

        private LazyInstanceHolder() {
        }
    }
}

