/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.time.OffsetDateTime;
import workbench.db.DefaultDataTypeResolver;
import workbench.resource.Settings;

public class SqlServerDataTypeResolver
extends DefaultDataTypeResolver {
    private static final int MS_OFFSET_TYPE = -155;
    private static final int MAX_DEFAULT_LENGTH = 8000;
    private static final int MAX_NVARCHAR_LENGTH = 4000;

    @Override
    public String getColumnClassName(int n, String string) {
        if (Settings.getInstance().getFixSqlServerTimestampDisplay() && n == -2 && "timestamp".equals(string)) {
            return "java.lang.String";
        }
        if (n == 2014 && string.startsWith("datetimeoffset")) {
            return OffsetDateTime.class.getName();
        }
        return null;
    }

    @Override
    public String getSqlTypeDisplay(String string, int n, int n2, int n3) {
        if ("hierarchyid".equals(string)) {
            return string;
        }
        if (n == 2005 && "nvarchar".equals(string) && n2 > 4000) {
            return "nvarchar(max)";
        }
        if (n == 2004 && "varbinary".equals(string)) {
            return "varbinary(max)";
        }
        if (n == -9 && n2 > 4000 || n == 2011) {
            return "nvarchar(max)";
        }
        if (n == 12 && n2 > 8000 || n == 2005) {
            return "varchar(max)";
        }
        if (n == 2004) {
            return "varbinary(max)";
        }
        if (n == -3) {
            if (n2 > 8000) {
                return "varbinary(max)";
            }
            return "varbinary(" + Integer.toString(n2) + ")";
        }
        if (n == -2) {
            if (n2 > 8000) {
                return "binary(max)";
            }
            return "binary(" + Integer.toString(n2) + ")";
        }
        if (n == 92 && n3 > 0) {
            return "time(" + n3 + ")";
        }
        return super.getSqlTypeDisplay(string, n, n2, n3);
    }

    @Override
    public int fixColumnType(int n, String string) {
        if (n == 12) {
            if ("date".equalsIgnoreCase(string)) {
                return 91;
            }
            if ("time".equalsIgnoreCase(string)) {
                return 92;
            }
        }
        if (n == -155 && string.startsWith("datetimeoffset")) {
            return 2014;
        }
        return n;
    }
}

