/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import workbench.db.DefaultFKHandler;
import workbench.db.FKHandler;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;

public class SqlServerFKHandler
extends DefaultFKHandler {
    private Map<TableIdentifier, Map<String, FKHandler.FkStatusInfo>> fkStatusInfo = new ConcurrentHashMap<TableIdentifier, Map<String, FKHandler.FkStatusInfo>>();

    public SqlServerFKHandler(WbConnection wbConnection) {
        super(wbConnection);
        this.containsStatusCol = false;
    }

    @Override
    public boolean supportsStatus() {
        return true;
    }

    @Override
    public FKHandler.FkStatusInfo getFkEnabledFlag(TableIdentifier tableIdentifier, String string) {
        if (CollectionUtil.isEmpty(this.fkStatusInfo)) {
            return null;
        }
        Map<String, FKHandler.FkStatusInfo> map = this.fkStatusInfo.get(tableIdentifier);
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        return map.get(string);
    }

    @Override
    protected DataStore getRawKeyList(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        this.readFkStatusForTable(tableIdentifier);
        return super.getRawKeyList(tableIdentifier, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFkStatusForTable(TableIdentifier tableIdentifier) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select name,        case when is_disabled = 1 then 'false' else 'true' end as enabled, \n       case when is_not_trusted = 1 then 'false' else 'true' end as validated \nfrom sys.foreign_keys with (nolock) \nwhere parent_object_id = object_id(?)";
        HashMap<String, FKHandler.FkStatusInfo> hashMap = new HashMap<String, FKHandler.FkStatusInfo>();
        try {
            preparedStatement = this.getConnection().getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getFullyQualifiedName(this.getConnection()));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                hashMap.put(string2, new FKHandler.FkStatusInfo("true".equals(string3), "true".equals(string4)));
            }
            this.fkStatusInfo.put(tableIdentifier, hashMap);
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not read FK status", exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

