/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class SqlServerIndexReader
extends JdbcIndexReader {
    private boolean checkOptions;
    private boolean checkFilteredIndex;

    public SqlServerIndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
        this.checkOptions = SqlServerUtil.isSqlServer2005(dbMetadata.getWbConnection());
        this.checkFilteredIndex = SqlServerUtil.isSqlServer2008(dbMetadata.getWbConnection());
    }

    @Override
    public String getSQLKeywordForType(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("NORMAL")) {
            return "NONCLUSTERED";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIndexOptions(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        int n;
        if (!this.checkOptions) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select ix.ignore_dup_key, ix.is_padded, ic.is_included_column, ix.fill_factor";
        string = this.checkFilteredIndex ? string + ", ix.filter_definition" : string + ", null as filter_definition";
        String string2 = string + ", col.name as column_name \nfrom sys.index_columns ic with (nolock) \n  join sys.columns col with (nolock) on col.object_id = ic.object_id and col.column_id = ic.column_id \n  join sys.indexes ix with (nolock) on ix.index_id = ic.index_id and ix.object_id = col.object_id \n  join sys.all_objects ao with (nolock) on ao.object_id = ix.object_id \n  join sys.schemas sh with (nolock) on sh.schema_id = ao.schema_id \nwhere ix.name = ? \n  and ao.name = ? \n  and sh.name = ? \norder by ic.index_column_id";
        LogMgr.logMetadataSql(new CallerInfo(){}, "index information", string2, indexDefinition.getName(), tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        String string3 = null;
        try {
            preparedStatement = this.metaData.getSqlConnection().prepareStatement(string2);
            preparedStatement.setString(1, indexDefinition.getName());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            preparedStatement.setString(3, tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            boolean bl3 = true;
            while (resultSet.next()) {
                if (bl3) {
                    bl = resultSet.getBoolean("ignore_dup_key");
                    bl2 = resultSet.getBoolean("is_padded");
                    n2 = resultSet.getInt("fill_factor");
                    string3 = resultSet.getString("filter_definition");
                    bl3 = false;
                }
                if ((n = resultSet.getBoolean("is_included_column")) == 0) continue;
                arrayList.add(resultSet.getString("column_name"));
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "index information", string2, indexDefinition.getName(), tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        StringBuilder stringBuilder = new StringBuilder(arrayList.size() * 20);
        if (arrayList.size() > 0) {
            stringBuilder.append("\n   INCLUDE (");
            for (n = 0; n < arrayList.size(); ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)arrayList.get(n));
            }
            stringBuilder.append(')');
            indexDefinition.getSourceOptions().addConfigSetting("include_columns", StringUtil.listToString(arrayList, ','));
        }
        if (StringUtil.isNonBlank(string3)) {
            stringBuilder.append("\n   WHERE ");
            stringBuilder.append(string3.trim());
            indexDefinition.setFilterExpression(string3.trim());
        }
        if (bl2 || bl || n2 > 0) {
            stringBuilder.append("\n   WITH (");
            n = 0;
            if (bl) {
                stringBuilder.append("IGNORE_DUP_KEY = ON");
                ++n;
                indexDefinition.getSourceOptions().addConfigSetting("ignore_dup_key", "true");
            }
            if (n2 > 0) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("FILLFACTOR = ");
                stringBuilder.append(n2);
                ++n;
                indexDefinition.getSourceOptions().addConfigSetting("fillfactor", Integer.toString(n2));
            }
            if (bl2) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("PAD_INDEX = ON");
                indexDefinition.getSourceOptions().addConfigSetting("pad_index", "true");
                ++n;
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean supportsIndexList() {
        return SqlServerUtil.isSqlServer2005(this.metaData.getWbConnection());
    }

    @Override
    public List<IndexDefinition> getIndexes(String string, String string2, String string3, String string4) {
        if (SqlServerUtil.isSqlServer2005(this.metaData.getWbConnection())) {
            return super.getIndexes(string, string2, string3, string4);
        }
        return Collections.emptyList();
    }
}

