/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.mssql.PartitionFunction;
import workbench.db.mssql.PartitionScheme;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class SqlServerPartitionReader {
    private final WbConnection dbConnection;
    private final String retrieveFunctionSQL = "select pf.function_id, \n       pf.name as function_name, \n       pf.type_desc,\n       pf.boundary_value_on_right,\n       typ.name as parameter_type,\n       r.parameter_id,\n       r.boundary_id, \n       case cast(SQL_VARIANT_PROPERTY(r.value, 'BaseType') as varchar(50))\n          when 'date' then '''' + convert(varchar(20), r.value, 23) + ''''\n          when 'timestamp' then '''' + convert(varchar(20), r.value, 121) + ''''\n          when 'varchar' then '''' + cast(r.value as varchar(max)) + ''''\n          else cast(r.value as varchar(max))\n       end as boundary_value\nfrom sys.partition_functions pf \n  join sys.partition_parameters par on par.function_id = pf.function_id\n  join sys.types typ on typ.system_type_id = par.system_type_id\n  LEFT JOIN sys.partition_range_values AS r ON pf.function_id = r.function_id\nwhere pf.is_system = 0 \n";
    private final String retrieveSchemesSQL = "select ps.name AS partition_scheme, \n       fg.name AS file_group, \n       f.name as function_name \nfrom sys.partitions p \n    join sys.indexes i  ON i.object_id = p.object_id AND i.index_id = p.index_id \n    join sys.partition_schemes ps on ps.data_space_id = i.data_space_id \n    join sys.partition_functions f on f.function_id = ps.function_id \n    join sys.allocation_units au  ON au.container_id = p.hobt_id \n    join sys.filegroups fg  ON fg.data_space_id = au.data_space_id \n";
    private final String orderSchemes = "order by p.partition_number";
    private final String orderFunctions = "order by pf.function_id, r.boundary_id";
    private final boolean supportsPartitioning;

    public SqlServerPartitionReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.supportsPartitioning = SqlServerUtil.supportsPartitioning(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PartitionFunction> getFunctions() {
        ArrayList<PartitionFunction> arrayList;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            if (!this.supportsPartitioning) {
                return Collections.emptyList();
            }
            String string = "select pf.function_id, \n       pf.name as function_name, \n       pf.type_desc,\n       pf.boundary_value_on_right,\n       typ.name as parameter_type,\n       r.parameter_id,\n       r.boundary_id, \n       case cast(SQL_VARIANT_PROPERTY(r.value, 'BaseType') as varchar(50))\n          when 'date' then '''' + convert(varchar(20), r.value, 23) + ''''\n          when 'timestamp' then '''' + convert(varchar(20), r.value, 121) + ''''\n          when 'varchar' then '''' + cast(r.value as varchar(max)) + ''''\n          else cast(r.value as varchar(max))\n       end as boundary_value\nfrom sys.partition_functions pf \n  join sys.partition_parameters par on par.function_id = pf.function_id\n  join sys.types typ on typ.system_type_id = par.system_type_id\n  LEFT JOIN sys.partition_range_values AS r ON pf.function_id = r.function_id\nwhere pf.is_system = 0 \norder by pf.function_id, r.boundary_id";
            preparedStatement = null;
            resultSet = null;
            arrayList = new ArrayList<PartitionFunction>();
            CallerInfo callerInfo = new CallerInfo(){};
            int n = -1;
            PartitionFunction partitionFunction = null;
            String string2 = this.dbConnection.getCurrentCatalog();
            LogMgr.logMetadataSql(callerInfo, "partition functions", string, new Object[0]);
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n2 = resultSet.getInt("function_id");
                    String string3 = resultSet.getString("function_name");
                    if (partitionFunction == null || partitionFunction.getFunctionId() != n2) {
                        arrayList.add(partitionFunction);
                        partitionFunction = new PartitionFunction(string3);
                        partitionFunction.setFunctionId(n2);
                        partitionFunction.setCatalog(string2);
                        n = -1;
                    }
                    int n3 = resultSet.getInt("parameter_id");
                    String string4 = resultSet.getString("parameter_type");
                    if (n3 != n) {
                        partitionFunction.addParameter(string4);
                        n = n3;
                    }
                    String string5 = resultSet.getString("boundary_value");
                    partitionFunction.addValue(string5);
                }
                if (partitionFunction == null) break block8;
                arrayList.add(partitionFunction);
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logMetadataError(callerInfo, throwable, "partition functions", string, new Object[0]);
                }
                catch (Throwable throwable2) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable2;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionScheme getSchemeForTable(TableIdentifier tableIdentifier) {
        if (!this.supportsPartitioning || tableIdentifier == null) {
            return null;
        }
        String string = "select ps.name AS partition_scheme, \n       fg.name AS file_group, \n       f.name as function_name \nfrom sys.partitions p \n    join sys.indexes i  ON i.object_id = p.object_id AND i.index_id = p.index_id \n    join sys.partition_schemes ps on ps.data_space_id = i.data_space_id \n    join sys.partition_functions f on f.function_id = ps.function_id \n    join sys.allocation_units au  ON au.container_id = p.hobt_id \n    join sys.filegroups fg  ON fg.data_space_id = au.data_space_id \n\nwhere  p.object_id = object_id(?) \norder by p.partition_number";
        String string2 = tableIdentifier.getTableExpression(this.dbConnection);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PartitionScheme partitionScheme = null;
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logMetadataSql(callerInfo, "table partition scheme", string, string2);
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (partitionScheme == null) {
                    String string3 = resultSet.getString("partition_scheme");
                    String string4 = resultSet.getString("function_name");
                    partitionScheme = new PartitionScheme(string3, string4);
                    partitionScheme.setCatalog(this.dbConnection.getCurrentCatalog());
                }
                partitionScheme.addFileGroup(resultSet.getString("file_group"));
            }
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(callerInfo, throwable, "table partition scheme", string, string2);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return partitionScheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionFunction getFunctionForTable(TableIdentifier tableIdentifier) {
        if (!this.supportsPartitioning || tableIdentifier == null) {
            return null;
        }
        String string = "select pf.function_id, \n       pf.name as function_name, \n       pf.type_desc,\n       pf.boundary_value_on_right,\n       typ.name as parameter_type,\n       r.parameter_id,\n       r.boundary_id, \n       case cast(SQL_VARIANT_PROPERTY(r.value, 'BaseType') as varchar(50))\n          when 'date' then '''' + convert(varchar(20), r.value, 23) + ''''\n          when 'timestamp' then '''' + convert(varchar(20), r.value, 121) + ''''\n          when 'varchar' then '''' + cast(r.value as varchar(max)) + ''''\n          else cast(r.value as varchar(max))\n       end as boundary_value\nfrom sys.partition_functions pf \n  join sys.partition_parameters par on par.function_id = pf.function_id\n  join sys.types typ on typ.system_type_id = par.system_type_id\n  LEFT JOIN sys.partition_range_values AS r ON pf.function_id = r.function_id\nwhere pf.is_system = 0 \n  and pf.function_id IN (SELECT s.function_id\n                         FROM sys.tables AS t  \n                           JOIN sys.indexes AS i ON t.object_id = i.object_id  \n                           JOIN sys.partition_schemes AS s ON i.data_space_id = s.data_space_id  \n                          WHERE t.object_id = object_id(?)) \norder by pf.function_id, r.boundary_id";
        String string2 = tableIdentifier.getTableExpression(this.dbConnection);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PartitionFunction partitionFunction = null;
        CallerInfo callerInfo = new CallerInfo(){};
        int n = -1;
        LogMgr.logMetadataSql(callerInfo, "table partition function", string, string2);
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("function_name");
                if (partitionFunction == null) {
                    partitionFunction = new PartitionFunction(string3);
                    String string4 = resultSet.getString("type_desc");
                    boolean bl = resultSet.getBoolean("boundary_value_on_right");
                    if (bl) {
                        partitionFunction.setTypeDef(string4 + " RIGHT");
                    } else {
                        partitionFunction.setTypeDef(string4 + " LEFT");
                    }
                    int n2 = resultSet.getInt("function_id");
                    partitionFunction.setFunctionId(n2);
                    partitionFunction.setCatalog(this.dbConnection.getCurrentCatalog());
                }
                int n3 = resultSet.getInt("parameter_id");
                String string5 = resultSet.getString("parameter_type");
                if (n3 != n) {
                    partitionFunction.addParameter(string5);
                    n = n3;
                }
                String string6 = resultSet.getString("boundary_value");
                partitionFunction.addValue(string6);
            }
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(callerInfo, throwable, "table partition function", string, string2);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return partitionFunction;
    }
}

