/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerRule;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SqlServerRuleReader
implements ObjectListExtender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SqlServerRule> getRuleList(WbConnection wbConnection, String string, String string2, String string3) {
        ArrayList<SqlServerRule> arrayList = new ArrayList<SqlServerRule>();
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        try {
            statement = wbConnection.createStatementForQuery();
            string4 = this.getSql(wbConnection, string, string2);
            LogMgr.logMetadataSql(new CallerInfo(){}, "rules", string4, string4, string, string2);
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                SqlServerRule sqlServerRule = new SqlServerRule(string5, string6, string7);
                arrayList.add(sqlServerRule);
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "rules", string4, string, string2);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        return arrayList;
    }

    @Override
    public SqlServerRule getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<SqlServerRule> list = this.getRuleList(wbConnection, dbObject.getSchema(), dbObject.getObjectName(), null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        SqlServerRule sqlServerRule = list.get(0);
        if (sqlServerRule.getComment() == null && dbObject.getComment() != null) {
            sqlServerRule.setComment(dbObject.getComment());
        }
        return sqlServerRule;
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("RULE", stringArray)) {
            return false;
        }
        List<SqlServerRule> list = this.getRuleList(wbConnection, string2, string3, null);
        if (list.isEmpty()) {
            return false;
        }
        for (SqlServerRule sqlServerRule : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, (Object)sqlServerRule.getCatalog());
            dataStore.setValue(n, 3, (Object)sqlServerRule.getSchema());
            dataStore.setValue(n, 0, (Object)sqlServerRule.getObjectName());
            dataStore.setValue(n, 4, (Object)sqlServerRule.getComment());
            dataStore.setValue(n, 1, (Object)sqlServerRule.getObjectType());
            dataStore.getRow(n).setUserObject(sqlServerRule);
        }
        return true;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("RULE", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        SqlServerRule sqlServerRule = this.getObjectDefinition(wbConnection, dbObject);
        if (sqlServerRule == null) {
            return null;
        }
        String[] stringArray = new String[]{"RULE", "REMARKS"};
        int[] nArray = new int[]{12, 12};
        int[] nArray2 = new int[]{20, 20};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)sqlServerRule.getObjectName());
        dataStore.setValue(0, 1, (Object)sqlServerRule.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("RULE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        Statement statement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(50);
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery("sp_helptext '" + dbObject.getFullyQualifiedName(wbConnection) + "'");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                stringBuilder.append(string);
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve rule source: ", sQLException);
            String string = null;
            return string;
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";\n");
            return stringBuilder.toString();
        }
        return null;
    }

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(150);
        if (SqlServerUtil.isSqlServer2005(wbConnection)) {
            String string3 = "select db_name() as rule_catalog,  \n       sc.name as rule_schema, \n       ao.name as rule_name \nfrom sys.all_objects ao with (nolock) \n  join sys.schemas sc with (nolock) on ao.schema_id = sc.schema_id \nwhere ao.type = 'R'";
            stringBuilder.append(string3);
            if (StringUtil.isNonBlank(string2)) {
                stringBuilder.append("\n AND ");
                SqlUtil.appendExpression(stringBuilder, "ao.name", string2, wbConnection);
            }
            if (StringUtil.isNonBlank(string)) {
                stringBuilder.append("\n AND ");
                SqlUtil.appendExpression(stringBuilder, "sc.name", string, wbConnection);
            }
            stringBuilder.append("\n ORDER BY 1, 2 ");
        } else {
            String string4 = "select db_name() as rule_catalog, \n       convert(sysname, user_name(uid)) as rule_schema, \n       name as rule_name \nfrom sysobjects with (nolock) \nwhere type = 'R' ";
            stringBuilder.append(string4);
            if (StringUtil.isNonBlank(string2)) {
                stringBuilder.append("\n AND ");
                SqlUtil.appendExpression(stringBuilder, "name", string2, wbConnection);
            }
            if (StringUtil.isNonBlank(string)) {
                stringBuilder.append("\n AND ");
                SqlUtil.appendExpression(stringBuilder, "convert(sysname, user_name(uid))", string, wbConnection);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

