/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.DefaultTriggerReader;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.StringUtil;

public class SqlServerTriggerReader
extends DefaultTriggerReader {
    public SqlServerTriggerReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getTriggers(String string, String string2, String string3) throws SQLException {
        String string4 = this.dbConnection.getCurrentCatalog();
        boolean bl = StringUtil.stringsAreNotEqual(string4, string) && StringUtil.isNonBlank(string);
        DataStore dataStore = null;
        try {
            if (bl) {
                SqlServerUtil.changeDatabase(this.dbConnection, string);
            }
            dataStore = super.getTriggers(string, string2, string3);
            if (SqlServerUtil.isSqlServer2005(this.dbConnection) && StringUtil.isEmptyString(string3)) {
                this.readDDLTriggers(dataStore);
            }
        }
        finally {
            if (bl) {
                SqlServerUtil.changeDatabase(this.dbConnection, string4);
            }
        }
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDDLTriggers(DataStore dataStore) {
        Object object;
        String string = "select tr.name as trigger_name, \n       'ON DATABASE' as trigger_type, \n       te.type_desc as trigger_event,        db_name() as db_name \nfrom sys.triggers tr with (nolock) \n  join sys.trigger_events te with (nolock) on te.object_id = tr.object_id \nwhere tr.is_ms_shipped = 0 \n  and tr.parent_class_desc = 'DATABASE' \nunion all \nselect tr.name, \n       'ON SERVER' as trigger_type, \n       te.type_desc as trigger_event,        null as db_name \nfrom sys.server_triggers tr with (nolock)  \n  join sys.server_trigger_events te with (nolock) on te.object_id = tr.object_id \nwhere is_ms_shipped = 0  and tr.parent_class_desc = 'SERVER'";
        LogMgr.logMetadataSql(new CallerInfo(){}, "DDL triggers", string, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                ++n;
                object = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                int n2 = dataStore.addRow();
                dataStore.setValue(n2, 0, object);
                dataStore.setValue(n2, 1, (Object)string2);
                dataStore.setValue(n2, 2, (Object)string3);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "DDL triggers", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (n > 0) {
            object = new SortDefinition();
            ((SortDefinition)object).addSortColumn(0, true);
            dataStore.sort((SortDefinition)object);
        }
        dataStore.resetStatus();
    }
}

