/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class SqlServerUtil {
    private static final String IS_ENTERPRISE_PROP = "isEnterprise";

    public static boolean isMicrosoftDriver(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        String string = wbConnection.getUrl();
        if (string == null) {
            return false;
        }
        return string.startsWith("jdbc:sqlserver:");
    }

    public static boolean isSqlServer2019(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "15.0");
    }

    public static boolean isSqlServer2017(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "14.0");
    }

    public static boolean isSqlServer2016(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "13.0");
    }

    public static boolean isSqlServer2014(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "12.0");
    }

    public static boolean isSqlServer2012(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "11.0");
    }

    public static boolean isSqlServer2008R2(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "10.5");
    }

    public static boolean isSqlServer2008(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
    }

    public static boolean isSqlServer2005(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "9.0");
    }

    public static boolean supportsPartitioning(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (!SqlServerUtil.isSqlServer2016(wbConnection)) {
            return false;
        }
        return SqlServerUtil.isEnterprise(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnterprise(WbConnection wbConnection) {
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        block6: {
            if (wbConnection == null) {
                return false;
            }
            String string = wbConnection.getSessionProperty(IS_ENTERPRISE_PROP);
            if (string != null) {
                return StringUtil.stringToBool(string);
            }
            String string2 = "select cast(serverproperty('Edition') as varchar(100))";
            statement = null;
            resultSet = null;
            bl = false;
            try {
                String string3;
                statement = wbConnection.createStatement();
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next() || !StringUtil.isNonBlank(string3 = resultSet.getString(1))) break block6;
                bl = string3.toLowerCase().contains("enterprise") || string3.toLowerCase().contains("developer");
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not retrieve edition using " + string2, throwable);
                }
                catch (Throwable throwable2) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable2;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        wbConnection.setSessionProperty(IS_ENTERPRISE_PROP, Boolean.toString(bl));
        return bl;
    }

    public static boolean isSqlServer2000(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "8.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLockTimeout(WbConnection wbConnection, int n) {
        Statement statement = null;
        String string = "SET LOCK_TIMEOUT " + Integer.toString(n <= 0 ? -1 : n);
        try {
            statement = wbConnection.createStatement();
            LogMgr.logInfo(new CallerInfo(){}, "Setting lock timeout: " + n + "ms");
            statement.execute(string);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not set lock timeout using: " + string, throwable);
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
    }

    public static void changeDatabase(WbConnection wbConnection, String string) {
        try {
            wbConnection.getSqlConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not change database", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(WbConnection wbConnection) {
        String string;
        ResultSet resultSet;
        Statement statement;
        block7: {
            if (wbConnection.isBusy()) {
                return null;
            }
            statement = null;
            resultSet = null;
            string = null;
            try {
                String string2;
                List<String> list;
                statement = wbConnection.createStatement();
                resultSet = statement.executeQuery("select @@version");
                if (!resultSet.next() || !CollectionUtil.isNonEmpty(list = StringUtil.getLines(string2 = resultSet.getString(1)))) break block7;
                string = StringUtil.trimToNull(list.get(0));
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve database version using @@version", throwable);
                    try {
                        string = wbConnection.getMetadata().getJdbcMetaData().getDatabaseProductVersion();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable3) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable3;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return string;
    }
}

