/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import java.io.FileWriter;
import java.io.PrintWriter;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.FormatFileWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CharacterRange;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class MySQLLoadDataWriter
implements FormatFileWriter {
    private boolean useFullFilepath;

    @Override
    public void setUseFullFilepath(boolean bl) {
        this.useFullFilepath = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFormatFile(DataExporter dataExporter, RowDataConverter rowDataConverter) {
        PrintWriter printWriter;
        block7: {
            WbFile wbFile = new WbFile(dataExporter.getFullOutputFilename());
            String string = wbFile.getParent();
            String string2 = dataExporter.getTableNameToUse();
            WbFile wbFile2 = new WbFile(string, "load_" + string2 + ".sql");
            printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(wbFile2));
                printWriter.print("load data infile '");
                printWriter.print(this.useFullFilepath ? wbFile.getFullPath() : wbFile.getName());
                printWriter.print("'\n");
                printWriter.print("  into table ");
                printWriter.println(string2);
                String string3 = dataExporter.getEncoding();
                if (string3 != null) {
                    printWriter.print("  character set " + string3 + "\n");
                }
                String string4 = StringUtil.escapeText(dataExporter.getTextDelimiter(), CharacterRange.RANGE_CONTROL);
                printWriter.print("  columns\n");
                printWriter.print("    terminated by '" + string4 + "'\n");
                String string5 = dataExporter.getTextQuoteChar();
                if (string5 != null) {
                    printWriter.print("    ");
                    if (!dataExporter.getQuoteAlways()) {
                        printWriter.print("optionally ");
                    }
                    printWriter.print("enclosed by '" + string5 + "'\n");
                }
                if (!dataExporter.getExportHeaders()) break block7;
                printWriter.print("  ignore 1 lines\n");
            }
            catch (Exception exception) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not write format file", exception);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietely(printWriter);
                    throw throwable;
                }
                FileUtil.closeQuietely(printWriter);
            }
        }
        FileUtil.closeQuietely(printWriter);
    }
}

