/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class MySQLTableSourceBuilder
extends TableSourceBuilder {
    public MySQLTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        StringBuilder stringBuilder;
        block9: {
            if (tableIdentifier == null) {
                return;
            }
            if (tableIdentifier.getSourceOptions().isInitialized()) {
                return;
            }
            stringBuilder = null;
            preparedStatement = null;
            resultSet = null;
            String string = "select engine, \n       table_comment, \n       table_collation \nfrom information_schema.tables \nwhere table_schema = ? \n   and table_name = ? ";
            String string2 = this.getDefaultCollation();
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, tableIdentifier.getCatalog());
                preparedStatement.setString(2, tableIdentifier.getRawTableName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                stringBuilder = new StringBuilder(100);
                String string3 = resultSet.getString("engine");
                this.appendOption(stringBuilder, "ENGINE", string3);
                tableIdentifier.getSourceOptions().addConfigSetting("engine", string3);
                String string4 = resultSet.getString("table_comment");
                if (StringUtil.isNonBlank(string4)) {
                    string4 = string4.replaceAll("'", "''");
                    string4 = "'" + string4 + "'";
                    this.appendOption(stringBuilder, "COMMENT", string4);
                }
                String string5 = resultSet.getString("table_collation");
                boolean bl = Settings.getInstance().getBoolProperty("workbench.db.mysql.tablesource.showcollation.always", false);
                if (bl || !StringUtil.equalStringIgnoreCase(string2, string5)) {
                    this.appendOption(stringBuilder, "COLLATE", string5);
                }
                tableIdentifier.getSourceOptions().addConfigSetting("collation", string5);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logDebug(new CallerInfo(){}, "Could not read table status", sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (stringBuilder != null) {
            tableIdentifier.getSourceOptions().setTableOption(stringBuilder.toString());
        }
        tableIdentifier.getSourceOptions().setInitialized();
    }

    private void appendOption(StringBuilder stringBuilder, String string, String string2) {
        if (StringUtil.isNonEmpty(string2)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultCollation() {
        String string;
        ResultSet resultSet;
        Statement statement;
        block4: {
            statement = null;
            resultSet = null;
            string = null;
            try {
                statement = this.dbConnection.createStatement();
                resultSet = statement.executeQuery("show variables like 'collation_database'");
                if (!resultSet.next()) break block4;
                string = resultSet.getString("value");
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logDebug(new CallerInfo(){}, "Could not read collation", sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return string;
    }

    @Override
    protected void appendTableComments(StringBuilder stringBuilder, TableIdentifier tableIdentifier, List<ColumnIdentifier> list, String string) {
    }
}

