/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.objectcache;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbObjectFinder;
import workbench.db.DependencyNode;
import workbench.db.IndexDefinition;
import workbench.db.PkDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.db.objectcache.ObjectCache;
import workbench.db.objectcache.ObjectCachePersistence;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.WbThread;

public class DbObjectCache {
    private final ObjectCache objectCache;
    private final WbConnection dbConnection;
    private final DbObjectFinder finder;
    private WbThread retrievalThread;

    DbObjectCache(ObjectCache objectCache, WbConnection wbConnection) {
        assert (objectCache != null);
        assert (wbConnection != null);
        this.dbConnection = wbConnection;
        this.objectCache = objectCache;
        this.finder = new DbObjectFinder(wbConnection);
    }

    public List<DependencyNode> getReferencedTables(TableIdentifier tableIdentifier) {
        return this.objectCache.getReferencedTables(this.dbConnection, tableIdentifier);
    }

    public List<DependencyNode> getReferencingTables(TableIdentifier tableIdentifier) {
        return this.objectCache.getReferencingTables(this.dbConnection, tableIdentifier);
    }

    public void addReferencedTables(TableIdentifier tableIdentifier, List<DependencyNode> list) {
        this.objectCache.addReferencedTables(tableIdentifier, list);
    }

    public void addReferencingTables(TableIdentifier tableIdentifier, List<DependencyNode> list) {
        this.objectCache.addReferencingTables(tableIdentifier, list);
    }

    public void addTable(TableDefinition tableDefinition) {
        this.objectCache.addTable(tableDefinition, this.dbConnection);
    }

    public void addTableList(DataStore dataStore, String string) {
        this.objectCache.addTableList(this.dbConnection, dataStore, string);
    }

    public void addProcedureList(DataStore dataStore, String string) {
        this.objectCache.addProcedureList(dataStore, string);
    }

    public void clear() {
        this.objectCache.clear();
    }

    public void removeAll() {
        this.clear();
        if (this.dbConnection != null && this.dbConnection.getProfile() != null) {
            ConnectionProfile connectionProfile = this.dbConnection.getProfile();
            ObjectCachePersistence objectCachePersistence = new ObjectCachePersistence();
            objectCachePersistence.deleteCacheFile(connectionProfile.getActiveUrl(), connectionProfile.getLoginUser());
        }
    }

    public synchronized void addSynonym(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2) {
        this.objectCache.addSynonym(tableIdentifier, tableIdentifier2);
    }

    public TableIdentifier getSynonymTable(TableIdentifier tableIdentifier) {
        return this.objectCache.getSynonymTable(this.dbConnection, tableIdentifier);
    }

    public List<ColumnIdentifier> getColumns(TableIdentifier tableIdentifier) {
        return this.objectCache.getColumns(this.dbConnection, tableIdentifier);
    }

    public List<ProcedureDefinition> getProcedures(String string) {
        return this.objectCache.getProcedures(this.dbConnection, string);
    }

    public Set<TableIdentifier> getTables(Namespace namespace) {
        return this.objectCache.getTables(this.dbConnection, namespace, null);
    }

    public Set<TableIdentifier> getTables(Namespace namespace, Collection<String> collection) {
        return this.objectCache.getTables(this.dbConnection, namespace, collection);
    }

    public void removeEntry(Object object) {
        if (object instanceof TableIdentifier) {
            this.removeTable((TableIdentifier)object);
        } else if (object instanceof ProcedureDefinition) {
            this.objectCache.removeProcedure(this.dbConnection, (ProcedureDefinition)object);
        }
    }

    public void removeTable(TableIdentifier tableIdentifier) {
        this.objectCache.removeTable(this.dbConnection, tableIdentifier);
    }

    public boolean supportsSearchPath() {
        return this.dbConnection != null && this.dbConnection.getMetadata().isPostgres();
    }

    public List<Namespace> getSearchPath(Namespace namespace) {
        return this.objectCache.getSearchPath(this.dbConnection, namespace);
    }

    public TableIdentifier getTable(TableIdentifier tableIdentifier) {
        return this.objectCache.findEntry(this.dbConnection, tableIdentifier);
    }

    public List<IndexDefinition> getUniqueIndexes(TableIdentifier tableIdentifier) {
        return this.objectCache.getUniqueIndexes(this.dbConnection, tableIdentifier);
    }

    public PkDefinition getPrimaryKey(TableIdentifier tableIdentifier) {
        return this.objectCache.getPrimaryKey(this.dbConnection, tableIdentifier);
    }

    public TableIdentifier getOrRetrieveTable(TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2 = this.objectCache.findEntry(this.dbConnection, tableIdentifier);
        if (tableIdentifier2 == null && (tableIdentifier2 = this.finder.searchSelectableObjectOnPath(tableIdentifier)) != null) {
            this.objectCache.addTable(tableIdentifier2, this.dbConnection);
        }
        return tableIdentifier2;
    }

    public void flushCachedDatabases() {
        this.objectCache.flushCachedDatabase();
    }

    public List<String> getAvailableDatabases() {
        return this.objectCache.getAvailableDatabases(this.dbConnection);
    }

    public void retrieveColumnsInBackground(List<TableIdentifier> list) {
        if (this.retrievalThread != null) {
            return;
        }
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.retrievalThread = new WbThread(() -> this._retrieveColumnsInBackground(list), "ObjectCache Background Retrieval");
        this.retrievalThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retrieveColumnsInBackground(List<TableIdentifier> list) {
        WbConnection wbConnection = null;
        try {
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving columns for " + list.size() + " tables");
            wbConnection = ConnectionMgr.getInstance().getConnection(this.dbConnection.getProfile(), "ObjectCache-Retrieval");
            for (TableIdentifier tableIdentifier : list) {
                this.objectCache.getColumns(wbConnection, tableIdentifier);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve table columns", throwable);
        }
        finally {
            if (wbConnection != null) {
                wbConnection.disconnect();
            }
        }
        this.retrievalThread = null;
    }
}

