/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.objectcache;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import workbench.resource.Settings;
import workbench.util.CaseInsensitiveComparator;

public class SourceCache {
    private Map<String, CharSequence> cachedSources = Collections.synchronizedMap(new TreeMap(CaseInsensitiveComparator.INSTANCE));
    private String dbid;

    public SourceCache(String string) {
        this.dbid = string;
    }

    public CharSequence getSource(String string, String string2) {
        if (this.shouldCache(string)) {
            return this.cachedSources.get(this.getRealKey(string, string2));
        }
        return null;
    }

    public boolean addSource(String string, String string2, CharSequence charSequence) {
        if (this.shouldCache(string)) {
            this.cachedSources.put(this.getRealKey(string, string2), charSequence);
            return true;
        }
        return false;
    }

    private String getRealKey(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return "$" + string.toLowerCase() + "$/" + string2;
    }

    public boolean shouldCache(String string) {
        if (string == null) {
            return false;
        }
        return Settings.getInstance().getBoolProperty("workbench.db." + this.dbid + ".source.cache." + string.toLowerCase(), false);
    }

    public void clear() {
        this.cachedSources.clear();
    }
}

