/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OraclePartitionDefinition;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public abstract class AbstractOraclePartition {
    private String type;
    private List<String> columns;
    private List<OraclePartitionDefinition> partitions;
    private String subType;
    private int defaultSubpartitionCount;
    private List<String> subColumns;
    protected boolean useCompression;
    protected boolean supportsIntervals;
    protected boolean isIndex;
    protected String locality;
    protected String intervalDefinition;
    protected String tableSpace;
    protected String objectOwner;
    protected String defaultUserTablespace;
    protected String currentUser;
    protected String refPartitionConstraint;
    protected boolean retrievePartitionsForLocalIndex;
    protected boolean supportsRefPartitions;

    public AbstractOraclePartition(WbConnection wbConnection) throws SQLException {
        this(wbConnection, true);
    }

    protected AbstractOraclePartition(WbConnection wbConnection, boolean bl) {
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(wbConnection, "11.1");
        this.useCompression = bl && bl2;
        this.supportsIntervals = bl2;
        this.currentUser = wbConnection.getCurrentUser();
        this.supportsRefPartitions = bl2;
    }

    public void retrieve(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        boolean bl;
        if (dbObject == null) {
            return;
        }
        if (OracleUtils.checkDefaultTablespace()) {
            this.defaultUserTablespace = OracleUtils.getDefaultTablespace(wbConnection);
        }
        if (bl = this.retrieveDefinition(dbObject, wbConnection)) {
            this.retrieveColumns(dbObject, wbConnection);
            this.retrievePartitions(dbObject, wbConnection);
        }
    }

    protected abstract String getRetrievePartitionDefinitionSql();

    protected abstract String getRetrieveColumnsSql();

    protected abstract String getRetrieveSubColumnsSql();

    protected abstract String getRetrieveSubPartitionsSql();

    protected abstract String getRetrievePartitionsSql();

    public List<OraclePartitionDefinition> getPartitions() {
        if (!this.isPartitioned()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.partitions);
    }

    public boolean hasSubPartitions() {
        return !StringUtil.equalStringIgnoreCase(this.subType, "NONE");
    }

    public boolean isPartitioned() {
        return this.columns != null && !this.columns.isEmpty();
    }

    public List<String> getColumns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.columns);
    }

    public boolean isRefPartition() {
        return "REFERENCE".equalsIgnoreCase(this.type);
    }

    public String getSubPartitionType() {
        return this.subType;
    }

    public String getPartitionType() {
        return this.type;
    }

    public String getSourceForTableDefinition() {
        return this.getSource(true, "", true);
    }

    public String getSourceForTableDefinition(boolean bl) {
        return this.getSource(true, "", bl);
    }

    public String getSourceForTableDefinition(String string) {
        return this.getSource(true, string, true);
    }

    public String getSourceForTableDefinition(String string, boolean bl) {
        return this.getSource(true, string, bl);
    }

    public String getSourceForIndexDefinition(String string) {
        return this.getSource(false, string, true);
    }

    public String getSourceForIndexDefinition() {
        return this.getSource(false, "", true);
    }

    private String getSource(boolean bl, String string, boolean bl2) {
        if (!this.isPartitioned()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.partitions.size() * 15);
        if (this.locality != null) {
            stringBuilder.append(string);
            stringBuilder.append(this.locality);
        }
        if (this.locality == null) {
            stringBuilder.append(string);
            stringBuilder.append("PARTITION BY ");
            stringBuilder.append(this.type);
            stringBuilder.append(' ');
            if (this.refPartitionConstraint != null) {
                stringBuilder.append('(');
                stringBuilder.append(SqlUtil.quoteObjectname(this.refPartitionConstraint));
                stringBuilder.append(')');
            } else if (this.columns != null) {
                stringBuilder.append('(');
                stringBuilder.append(StringUtil.listToString(this.columns, ','));
                stringBuilder.append(')');
            }
            if (StringUtil.isNonBlank(this.intervalDefinition)) {
                stringBuilder.append(" INTERVAL (");
                stringBuilder.append(this.intervalDefinition);
                stringBuilder.append(") ");
            }
            if (!"NONE".equals(this.subType)) {
                stringBuilder.append('\n');
                stringBuilder.append(string);
                stringBuilder.append("SUBPARTITION BY ");
                stringBuilder.append(this.subType);
                stringBuilder.append(" (");
                stringBuilder.append(StringUtil.listToString(this.subColumns, ','));
                stringBuilder.append(')');
                if (this.defaultSubpartitionCount > 1) {
                    stringBuilder.append('\n');
                    stringBuilder.append(string);
                    stringBuilder.append("SUBPARTITIONS ");
                    stringBuilder.append(this.defaultSubpartitionCount);
                }
            }
        }
        if (this.partitions.size() > 0) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
            stringBuilder.append("(\n");
            int n = bl ? OraclePartitionDefinition.getMaxPartitionNameLength(this.partitions) : 0;
            for (int i = 0; i < this.partitions.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                    stringBuilder.append(string);
                    stringBuilder.append('\n');
                }
                stringBuilder.append(this.partitions.get(i).getSource(bl, n, string));
            }
            stringBuilder.append("\n");
            stringBuilder.append(string);
            stringBuilder.append(')');
        }
        if (bl2 && OracleUtils.shouldAppendTablespace(this.tableSpace, this.defaultUserTablespace, this.objectOwner, this.currentUser)) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
            stringBuilder.append("TABLESPACE ");
            stringBuilder.append(this.tableSpace);
        }
        return stringBuilder.toString();
    }

    protected boolean retrieveDefinition(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        String string = this.getRetrievePartitionDefinitionSql();
        long l = System.currentTimeMillis();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, "partition definition", string, dbObject.getSchema(), dbObject.getObjectName());
            preparedStatement.setString(1, SqlUtil.removeObjectQuotes(dbObject.getSchema()));
            preparedStatement.setString(2, SqlUtil.removeObjectQuotes(dbObject.getObjectName()));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.type = resultSet.getString("PARTITIONING_TYPE");
                this.subType = resultSet.getString("SUBPARTITIONING_TYPE");
                if (this.isIndex) {
                    this.locality = resultSet.getString("LOCALITY");
                }
                this.defaultSubpartitionCount = resultSet.getInt("DEF_SUBPARTITION_COUNT");
                this.intervalDefinition = this.supportsIntervals ? resultSet.getString("INTERVAL") : null;
                n = resultSet.getInt("SUBPARTITIONING_KEY_COUNT");
                int n2 = resultSet.getInt("PARTITIONING_KEY_COUNT");
                this.columns = new ArrayList<String>(n2);
                int n3 = resultSet.getInt("PARTITION_COUNT");
                this.partitions = new ArrayList<OraclePartitionDefinition>(n3);
                this.tableSpace = resultSet.getString("DEF_TABLESPACE_NAME");
                this.refPartitionConstraint = resultSet.getString("REF_PTN_CONSTRAINT_NAME");
                this.objectOwner = dbObject.getSchema();
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "partition definition", string, dbObject.getSchema(), dbObject.getObjectName());
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (this.isRefPartition() && dbObject instanceof TableIdentifier) {
            ((TableIdentifier)dbObject).setUseInlineFK(true);
        }
        if (n > 0) {
            this.retrieveSubColumns(dbObject, wbConnection);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving partition definition for " + dbObject.getFullyQualifiedName(wbConnection) + " took: " + l2 + "ms");
        return this.type != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveColumns(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.getRetrieveColumnsSql();
        long l = System.currentTimeMillis();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, string, dbObject.getSchema(), dbObject.getObjectName());
            preparedStatement.setString(1, SqlUtil.removeObjectQuotes(dbObject.getSchema()));
            preparedStatement.setString(2, SqlUtil.removeObjectQuotes(dbObject.getObjectName()));
            resultSet = preparedStatement.executeQuery();
            this.columns = new ArrayList<String>();
            while (resultSet.next()) {
                this.columns.add(resultSet.getString("COLUMN_NAME"));
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, string, dbObject.getSchema(), dbObject.getObjectName());
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving partition columns for " + dbObject.getObjectName() + " took: " + l2 + "ms");
    }

    private void retrieveSubColumns(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.getRetrieveSubColumnsSql();
        long l = System.currentTimeMillis();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, "sub-partition columns", string, dbObject.getSchema(), dbObject.getObjectName());
            preparedStatement.setString(1, SqlUtil.removeObjectQuotes(dbObject.getSchema()));
            preparedStatement.setString(2, SqlUtil.removeObjectQuotes(dbObject.getObjectName()));
            resultSet = preparedStatement.executeQuery();
            this.subColumns = new ArrayList<String>();
            while (resultSet.next()) {
                this.subColumns.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "sub-partition columns", string, dbObject.getSchema(), dbObject.getObjectName());
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving sub partition columns for " + dbObject.getObjectName() + " took: " + l2 + "ms");
    }

    private OraclePartitionDefinition findPartition(String string) {
        if (this.partitions == null || this.partitions.isEmpty()) {
            return null;
        }
        for (OraclePartitionDefinition oraclePartitionDefinition : this.partitions) {
            if (!oraclePartitionDefinition.getName().equals(string)) continue;
            return oraclePartitionDefinition;
        }
        return null;
    }

    private void retrieveSubPartitions(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.getRetrieveSubPartitionsSql();
        long l = System.currentTimeMillis();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, "sub-partitions", string, dbObject.getSchema(), dbObject.getObjectName());
            preparedStatement.setString(1, SqlUtil.removeObjectQuotes(dbObject.getSchema()));
            preparedStatement.setString(2, SqlUtil.removeObjectQuotes(dbObject.getObjectName()));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("PARTITION_NAME");
                String string3 = resultSet.getString("SUBPARTITION_NAME");
                String string4 = resultSet.getString("HIGH_VALUE");
                int n = resultSet.getInt("SUBPARTITION_POSITION");
                String string5 = null;
                if (this.useCompression) {
                    string5 = resultSet.getString("COMPRESSION");
                }
                OraclePartitionDefinition oraclePartitionDefinition = new OraclePartitionDefinition(string3, this.subType, n);
                oraclePartitionDefinition.setPartitionValue(string4);
                oraclePartitionDefinition.setCompressOption(string5);
                oraclePartitionDefinition.setIsSubpartition(true);
                OraclePartitionDefinition oraclePartitionDefinition2 = this.findPartition(string2);
                if (oraclePartitionDefinition2 == null) continue;
                oraclePartitionDefinition2.addSubPartition(oraclePartitionDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "sub-partitions", string, dbObject.getSchema(), dbObject.getObjectName());
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving sub partitions " + dbObject.getObjectName() + " took: " + l2 + "ms");
    }

    protected boolean shouldRetrievePartitions() {
        return true;
    }

    protected List<OraclePartitionDefinition> loadPartitions(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.getRetrievePartitionsSql();
        ArrayList<OraclePartitionDefinition> arrayList = new ArrayList<OraclePartitionDefinition>();
        long l = System.currentTimeMillis();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            LogMgr.logMetadataSql(new CallerInfo(){}, "partitions", string, dbObject.getSchema(), dbObject.getObjectName());
            preparedStatement.setString(1, SqlUtil.removeObjectQuotes(dbObject.getSchema()));
            preparedStatement.setString(2, SqlUtil.removeObjectQuotes(dbObject.getObjectName()));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString("PARTITION_NAME");
                String string3 = resultSet.getString("HIGH_VALUE");
                int n = resultSet.getInt("PARTITION_POSITION");
                String string4 = null;
                if (this.useCompression) {
                    string4 = resultSet.getString("COMPRESSION");
                }
                OraclePartitionDefinition oraclePartitionDefinition = new OraclePartitionDefinition(string2, this.type, n);
                oraclePartitionDefinition.setSubPartitionType(this.subType);
                oraclePartitionDefinition.setPartitionValue(string3);
                oraclePartitionDefinition.setCompressOption(string4);
                arrayList.add(oraclePartitionDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "partitions", string, dbObject.getSchema(), dbObject.getObjectName());
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving partitions " + dbObject.getObjectName() + " took: " + l2 + "ms");
        return arrayList;
    }

    private void retrievePartitions(DbObject dbObject, WbConnection wbConnection) throws SQLException {
        if (!this.shouldRetrievePartitions()) {
            return;
        }
        this.partitions = this.loadPartitions(dbObject, wbConnection);
        if (this.defaultSubpartitionCount <= 1 && this.subColumns != null) {
            this.retrieveSubPartitions(dbObject, wbConnection);
        }
    }
}

