/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.lang.reflect.Method;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataConverter;
import workbench.util.NumberStringCache;

public class OracleDataConverter
implements DataConverter {
    private Method stringValueMethod;

    public static OracleDataConverter getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    private OracleDataConverter() {
    }

    @Override
    public Class getConvertedClass(int n, String string) {
        if (this.convertsType(n, string)) {
            return String.class;
        }
        return null;
    }

    @Override
    public boolean convertsType(int n, String string) {
        return n == -3 && string.startsWith("RAW") || n == -8;
    }

    @Override
    public Object convertValue(int n, String string, Object object) {
        if (object == null) {
            return null;
        }
        if (!this.convertsType(n, string)) {
            return object;
        }
        if (n == -8) {
            return this.convertRowId(object);
        }
        return this.convertRaw(object);
    }

    private Object convertRaw(Object object) {
        Object object2;
        try {
            byte[] byArray = (byte[])object;
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (int n : byArray) {
                int n2 = n < 0 ? 256 + n : n;
                stringBuilder.append(NumberStringCache.getHexString(n2).toUpperCase());
            }
            object2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error converting value " + object, throwable);
            object2 = object;
        }
        return object2;
    }

    private Object convertRowId(Object object) {
        Method method = this.stringValueMethod(object);
        if (method == null) {
            return object.toString();
        }
        try {
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (Throwable throwable) {
            return object.toString();
        }
    }

    private synchronized Method stringValueMethod(Object object) {
        if (this.stringValueMethod == null) {
            try {
                this.stringValueMethod = object.getClass().getMethod("stringValue", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.stringValueMethod;
    }

    private static class LazyInstanceHolder {
        protected static final OracleDataConverter INSTANCE = new OracleDataConverter();

        private LazyInstanceHolder() {
        }
    }
}

