/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.ResultSet;
import java.sql.Statement;
import workbench.db.DataTypeResolver;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlUtil;

public class OracleDataTypeResolver
implements DataTypeResolver {
    private final WbConnection connection;
    private CharSemantics defaultCharSemantics = null;
    private boolean alwaysShowCharSemantics = false;

    OracleDataTypeResolver(CharSemantics charSemantics, boolean bl) {
        this.connection = null;
        this.defaultCharSemantics = charSemantics;
        this.alwaysShowCharSemantics = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleDataTypeResolver(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.alwaysShowCharSemantics = Settings.getInstance().getBoolProperty("workbench.db.oracle.charsemantics.displayalways", true);
        if (!this.alwaysShowCharSemantics) {
            ResultSet resultSet;
            Statement statement;
            block8: {
                String string = "-- SQL Workbench \nSELECT value \nFROM v$nls_parameters \nWHERE parameter = 'NLS_LENGTH_SEMANTICS'";
                LogMgr.logMetadataSql(new CallerInfo(){}, "nls length semantics", string, new Object[0]);
                statement = null;
                resultSet = null;
                try {
                    statement = this.connection.createStatement();
                    resultSet = statement.executeQuery(string);
                    if (!resultSet.next()) break block8;
                    String string2 = resultSet.getString(1);
                    if ("BYTE".equalsIgnoreCase(string2)) {
                        this.defaultCharSemantics = CharSemantics.Byte;
                    } else if ("CHAR".equalsIgnoreCase(string2)) {
                        this.defaultCharSemantics = CharSemantics.Char;
                    }
                    LogMgr.logInfo(new CallerInfo(){}, "Default length semantics is: " + string2);
                }
                catch (Exception exception) {
                    try {
                        this.defaultCharSemantics = CharSemantics.Byte;
                        LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve NLS_LENGTH_SEMANTICS from v$nls_parameters. Assuming byte semantics. Using SQL:\n" + string, exception);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeAll(resultSet, statement);
                        throw throwable;
                    }
                    JdbcUtils.closeAll(resultSet, statement);
                }
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
    }

    @Override
    public int fixColumnType(int n, String string) {
        if (n == 91 && OracleUtils.getMapDateToTimestamp(this.connection)) {
            return 93;
        }
        if (n == -101 || n == -102) {
            return 2014;
        }
        if (n == 1111 && string != null && string.startsWith("TIMESTAMP(")) {
            return 93;
        }
        return n;
    }

    @Override
    public String getSqlTypeDisplay(String string, int n, int n2, int n3) {
        return this.getSqlTypeDisplay(string, n, n2, n3, this.defaultCharSemantics);
    }

    public String getSqlTypeDisplay(String string, int n, int n2, int n3, CharSemantics charSemantics) {
        String string2;
        if (n == 12) {
            string2 = this.getVarcharType(string, n2, charSemantics);
        } else {
            if ("NUMBER".equalsIgnoreCase(string)) {
                if (n3 == -127 || n2 == 0 || n2 == Integer.MAX_VALUE && n3 == 0) {
                    return "NUMBER";
                }
                if (n3 == 0) {
                    return "NUMBER(" + n2 + ")";
                }
                return "NUMBER(" + (n2 == Integer.MAX_VALUE ? "*" : Integer.valueOf(n2)) + "," + n3 + ")";
            }
            if (n == -3 && "RAW".equals(string)) {
                return "RAW(" + n2 + ")";
            }
            string2 = SqlUtil.getSqlTypeDisplay(string, n, n2, n3);
        }
        return string2;
    }

    private String getVarcharType(String string, int n, CharSemantics charSemantics) {
        StringBuilder stringBuilder = new StringBuilder(25);
        stringBuilder.append(string);
        if (n <= 0) {
            return stringBuilder.toString();
        }
        stringBuilder.append('(');
        stringBuilder.append(n);
        if (string.startsWith("VARCHAR") && (this.alwaysShowCharSemantics || charSemantics != this.defaultCharSemantics)) {
            if (charSemantics == null) {
                charSemantics = this.defaultCharSemantics;
            }
            if (charSemantics == CharSemantics.Byte) {
                stringBuilder.append(" Byte");
            } else if (charSemantics == CharSemantics.Char) {
                stringBuilder.append(" Char");
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public CharSemantics getDefaultCharSemantics() {
        return this.defaultCharSemantics;
    }

    @Override
    public String getColumnClassName(int n, String string) {
        if ("TIMESTAMP WITH TIME ZONE".equals(string)) {
            return "java.time.ZonedDateTime";
        }
        if ("TIMESTAMP WITH LOCAL TIME ZONE".equals(string)) {
            return "java.time.LocalDateTime";
        }
        if (n == 93) {
            return "java.sql.Timestamp";
        }
        return null;
    }

    public static enum CharSemantics {
        Byte,
        Char;

    }
}

