/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.DbSwitcher;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;

public class OracleDatabaseSwitcher
implements DbSwitcher {
    @Override
    public boolean supportsSwitching(WbConnection wbConnection) {
        if (!OracleUtils.isCommonUser(wbConnection)) {
            return false;
        }
        if (wbConnection.isBusy()) {
            return false;
        }
        return OracleUtils.hasMultipleContainers(wbConnection);
    }

    @Override
    public boolean needsReconnect() {
        return false;
    }

    @Override
    public boolean switchDatabase(WbConnection wbConnection, String string) throws SQLException {
        Statement statement = null;
        String string2 = "alter session set container = " + string;
        try {
            String string3 = this.getCurrentDatabase(wbConnection);
            statement = wbConnection.createStatement();
            statement.execute(string2);
            String string4 = this.getCurrentDatabase(wbConnection);
            wbConnection.containerChanged(string3, string4);
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logWarning(new CallerInfo(){}, "Could not change PDB to " + string + " using:\n" + string2, sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(statement);
                throw throwable;
            }
        }
        JdbcUtils.close((AutoCloseable)statement);
        return true;
    }

    @Override
    public String getUrlForDatabase(String string, String string2) {
        return null;
    }

    @Override
    public List<String> getAvailableDatabases(WbConnection wbConnection) {
        try {
            Set<String> set = CollectionUtil.caseInsensitiveSet();
            DataStore dataStore = OracleUtils.getPDBs(wbConnection);
            if (dataStore != null) {
                for (int i = 0; i < dataStore.getRowCount(); ++i) {
                    set.add(dataStore.getValueAsString(i, "name"));
                }
                if (dataStore.getRowCount() == 0) {
                    set.add(OracleUtils.getCurrentContainer(wbConnection));
                }
            }
            set.add("CDB$ROOT");
            ArrayList<String> arrayList = new ArrayList<String>(set);
            Collections.sort(arrayList);
            return arrayList;
        }
        catch (SQLException sQLException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve PDBs", sQLException);
            return null;
        }
    }

    @Override
    public String getCurrentDatabase(WbConnection wbConnection) {
        return OracleUtils.getCurrentContainer(wbConnection);
    }
}

