/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.DefaultFKHandler;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.storage.filter.AndExpression;
import workbench.storage.filter.StringEqualsComparator;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.StringUtil;

public class OracleFKHandler
extends DefaultFKHandler {
    final String baseSql;
    private static final Map<String, DataStore> CACHE = new TreeMap<String, DataStore>(CaseInsensitiveComparator.INSTANCE);
    private static boolean cacheInitialized = false;
    private PreparedStatement retrievalStatement;
    private final String currentUser;

    public OracleFKHandler(WbConnection wbConnection) {
        super(wbConnection);
        this.currentUser = wbConnection.getCurrentUser();
        this.containsStatusCol = true;
        this.baseSql = "-- SQLWorkbench \nSELECT " + OracleUtils.getCacheHint() + " NULL AS pktable_cat, \n       p.owner AS pktable_schem, \n       p.table_name AS pktable_name, \n       pc.column_name AS pkcolumn_name, \n       NULL AS fktable_cat, \n       f.owner AS fktable_schem, \n       f.table_name AS fktable_name, \n       fc.column_name AS fkcolumn_name, \n       fc.position AS key_seq, \n       3 AS update_rule, \n       decode (f.delete_rule, \n              'CASCADE', 0, \n              'SET NULL', 2, \n              1 \n       ) AS delete_rule, \n       f.constraint_name AS fk_name, \n       p.constraint_name AS pk_name, \n       decode(f.deferrable, \n             'DEFERRABLE', decode(f.deferred, 'IMMEDIATE', " + 6 + ", " + 5 + ") , \n             'NOT DEFERRABLE'," + 7 + " \n       ) deferrability, \n       case when f.status = 'ENABLED' then 'YES' else 'NO' end as enabled, \n       case when f.validated = 'VALIDATED' then 'YES' else 'NO' end as validated \n FROM all_constraints p\n  JOIN all_cons_columns pc ON pc.owner = p.owner AND pc.constraint_name = p.constraint_name AND pc.table_name = p.table_name \n  JOIN all_constraints f ON p.owner = f.r_owner AND p.constraint_name = f.r_constraint_name \n  JOIN all_cons_columns fc ON fc.owner = f.owner AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name AND fc.position = pc.position \nWHERE p.constraint_type in ('P', 'U') \n  AND f.constraint_type = 'R' \n";
    }

    @Override
    protected DataStore getRawKeyList(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        try {
            DataStore dataStore = this.getFromCache(tableIdentifier, bl);
            if (dataStore != null) {
                return dataStore;
            }
            if (bl) {
                return this.getExportedKeyList(tableIdentifier);
            }
            return this.getImportedKeyList(tableIdentifier);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve foreign keys", exception);
            return super.getRawKeyList(tableIdentifier, bl);
        }
    }

    private String getQuery(TableIdentifier tableIdentifier) {
        String string;
        if (OracleUtils.optimizeCatalogQueries() && (StringUtil.isEmptyString(string = tableIdentifier.getRawSchema()) || string.equalsIgnoreCase(this.currentUser))) {
            return this.baseSql.replace(" all_c", " user_c");
        }
        return this.baseSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore getExportedKeyList(TableIdentifier tableIdentifier) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(this.baseSql.length() + 50);
        stringBuilder.append(this.getQuery(tableIdentifier));
        stringBuilder.append("AND p.table_name = ? \n");
        stringBuilder.append("AND p.owner = ? \n");
        LogMgr.logMetadataSql(new CallerInfo(){}, "exported foreign keys", stringBuilder, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        DataStore dataStore = null;
        try {
            this.retrievalStatement = this.getConnection().getSqlConnection().prepareStatement(stringBuilder.toString());
            this.retrievalStatement.setString(1, tableIdentifier.getRawTableName());
            this.retrievalStatement.setString(2, tableIdentifier.getRawSchema());
            ResultSet resultSet = this.retrievalStatement.executeQuery();
            dataStore = this.processResult(resultSet);
        }
        finally {
            JdbcUtils.closeStatement(this.retrievalStatement);
            this.retrievalStatement = null;
        }
        this.sortResult(dataStore);
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore getFromCache(TableIdentifier tableIdentifier, boolean bl) {
        Map<String, DataStore> map = CACHE;
        synchronized (map) {
            DataStore dataStore;
            if (!cacheInitialized) {
                return null;
            }
            DataStore dataStore2 = CACHE.get(tableIdentifier.getRawSchema());
            if (dataStore2 == null) {
                dataStore2 = this.readUserFK(tableIdentifier.getRawSchema());
                if (dataStore2 == null) {
                    return null;
                }
                CACHE.put(tableIdentifier.getRawSchema(), dataStore2);
            }
            try {
                DataStore dataStore3 = dataStore2.createCopy(false);
                AndExpression andExpression = new AndExpression();
                if (bl) {
                    andExpression.addColumnExpression("pktable_schem", new StringEqualsComparator(), tableIdentifier.getRawSchema());
                    andExpression.addColumnExpression("pktable_name", new StringEqualsComparator(), tableIdentifier.getRawTableName());
                } else {
                    andExpression.addColumnExpression("fktable_schem", new StringEqualsComparator(), tableIdentifier.getRawSchema());
                    andExpression.addColumnExpression("fktable_name", new StringEqualsComparator(), tableIdentifier.getRawTableName());
                }
                dataStore2.applyFilter(andExpression);
                dataStore3.copyFrom(dataStore2);
                this.sortResult(dataStore3);
                dataStore = dataStore3;
                dataStore2.clearFilter();
            }
            catch (Throwable throwable) {
                dataStore2.clearFilter();
                throw throwable;
            }
            return dataStore;
        }
    }

    private void sortResult(DataStore dataStore) {
        if (dataStore == null) {
            return;
        }
        SortDefinition sortDefinition = new SortDefinition(new int[]{1, 2}, new boolean[]{true, true});
        dataStore.sort(sortDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore getImportedKeyList(TableIdentifier tableIdentifier) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(this.baseSql.length() + 50);
        stringBuilder.append(this.getQuery(tableIdentifier));
        stringBuilder.append("AND f.table_name = ? \n");
        stringBuilder.append("AND f.owner = ? \n");
        LogMgr.logMetadataSql(new CallerInfo(){}, "imported foreign keys", stringBuilder, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        DataStore dataStore = null;
        try {
            this.retrievalStatement = this.getConnection().getSqlConnection().prepareStatement(stringBuilder.toString());
            this.retrievalStatement.setString(1, tableIdentifier.getRawTableName());
            this.retrievalStatement.setString(2, tableIdentifier.getRawSchema());
            ResultSet resultSet = this.retrievalStatement.executeQuery();
            dataStore = this.processResult(resultSet);
        }
        finally {
            JdbcUtils.closeStatement(this.retrievalStatement);
            this.retrievalStatement = null;
        }
        this.sortResult(dataStore);
        return dataStore;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.retrievalStatement != null) {
            try {
                this.retrievalStatement.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSharedCache() {
        Map<String, DataStore> map = CACHE;
        synchronized (map) {
            CACHE.clear();
            cacheInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSharedCache() {
        if (Settings.getInstance().getBoolProperty("workbench.db.oracle.fk.useglobalcache", false)) {
            Map<String, DataStore> map = CACHE;
            synchronized (map) {
                DataStore dataStore = this.readUserFK(this.currentUser);
                CACHE.put(this.currentUser, dataStore);
                cacheInitialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore readUserFK(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.baseSql.length() + 50);
        boolean bl = false;
        if (string.equalsIgnoreCase(this.currentUser)) {
            stringBuilder.append(this.baseSql.replace(" all_c", " user_c"));
        } else {
            stringBuilder.append(this.baseSql);
            stringBuilder.append("AND p.owner = ? \n");
            stringBuilder.append("UNION ALL \n");
            stringBuilder.append(this.baseSql);
            stringBuilder.append("AND f.owner = ? \n");
            bl = true;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "foreign keys", stringBuilder, new Object[0]);
        DataStore dataStore = null;
        try {
            long l = System.currentTimeMillis();
            this.retrievalStatement = this.getConnection().getSqlConnection().prepareStatement(stringBuilder.toString());
            if (bl) {
                this.retrievalStatement.setString(1, string);
                this.retrievalStatement.setString(2, string);
            }
            ResultSet resultSet = this.retrievalStatement.executeQuery();
            dataStore = this.processResult(resultSet);
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving foreign keys for " + string + " took: " + l2 + "ms");
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "foreign keys", stringBuilder, new Object[0]);
            DataStore dataStore2 = null;
            return dataStore2;
        }
        finally {
            JdbcUtils.closeStatement(this.retrievalStatement);
            this.retrievalStatement = null;
        }
        this.sortResult(dataStore);
        return dataStore;
    }
}

