/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.util.StringUtil;

public class OracleIdentityOptionParser {
    private final Map<String, String> defaultOptions = new HashMap<String, String>();

    public OracleIdentityOptionParser() {
        this.defaultOptions.put("START WITH", "1");
        this.defaultOptions.put("INCREMENT BY", "1");
        this.defaultOptions.put("MAX_VALUE", "9999999999999999999999999999");
        this.defaultOptions.put("MIN_VALUE", "1");
        this.defaultOptions.put("CYCLE_FLAG", "N");
        this.defaultOptions.put("CACHE_SIZE", "20");
        this.defaultOptions.put("ORDER_FLAG", "N");
        this.defaultOptions.put("KEEP_FLAG", "N");
    }

    public String getIdentitySequenceOptions(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        Map<String, String> map = this.parseOptions(string);
        String string2 = "";
        string2 = this.appendOption(string2, "START WITH", "START WITH", map);
        string2 = this.appendOption(string2, "MINVALUE", "MIN_VALUE", map);
        string2 = this.appendOption(string2, "MAXVALUE", "MAX_VALUE", map);
        string2 = this.appendOption(string2, "INCREMENT BY", "INCREMENT BY", map);
        string2 = this.appendFlag(string2, "CYCLE_FLAG", "NOCYCLE", "CYCLE", map);
        string2 = this.appendOption(string2, "CACHE", "CACHE_SIZE", map);
        string2 = this.appendFlag(string2, "ORDER_FLAG", "NOORDER", "ORDER", map);
        string2 = this.appendFlag(string2, "KEEP_FLAG", "NOKEEP", "KEEP", map);
        return StringUtil.trimToNull(string2);
    }

    protected Map<String, String> parseOptions(String string) {
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : list) {
            String[] stringArray = string2.split(":");
            if (stringArray.length != 2) continue;
            hashMap.put(stringArray[0].trim(), stringArray[1].trim());
        }
        return hashMap;
    }

    private String appendOption(String string, String string2, String string3, Map<String, String> map) {
        String string4 = map.get(string3);
        if (string4 == null) {
            return string;
        }
        String string5 = this.defaultOptions.get(string3);
        if (string4.equals(string5)) {
            return string;
        }
        if (!string.isEmpty()) {
            string = string + " ";
        }
        string = string + string2;
        if (string4 != null) {
            string = string + " " + string4;
        }
        return string;
    }

    private String appendFlag(String string, String string2, String string3, String string4, Map<String, String> map) {
        String string5 = map.get(string2);
        if (string5 == null) {
            return string;
        }
        String string6 = this.defaultOptions.get(string2);
        if (string5.equals(string6)) {
            return string;
        }
        if (!string.isEmpty()) {
            string = string + " ";
        }
        string = "N".equals(string5) ? string + string3 : string + string4;
        return string;
    }
}

