/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.SQLException;
import workbench.db.IndexDefinition;
import workbench.db.WbConnection;
import workbench.db.oracle.AbstractOraclePartition;
import workbench.resource.Settings;

public class OracleIndexPartition
extends AbstractOraclePartition {
    private boolean showLocalIndexPartitions;

    public OracleIndexPartition(WbConnection wbConnection) throws SQLException {
        this(wbConnection, false);
        this.supportsRefPartitions = false;
    }

    protected OracleIndexPartition(WbConnection wbConnection, boolean bl) throws SQLException {
        super(wbConnection, bl);
        this.isIndex = true;
        this.supportsIntervals = false;
        this.showLocalIndexPartitions = Settings.getInstance().getBoolProperty("workbench.db.oracle.partition.index.local.retrieve", false);
    }

    public boolean hasPartitions(IndexDefinition indexDefinition, WbConnection wbConnection) {
        if (this.getPartitionType() != null) {
            return true;
        }
        try {
            this.retrieveDefinition(indexDefinition, wbConnection);
            boolean bl = this.getPartitionType() != null;
            indexDefinition.setPartitioned(bl);
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public String getLocality() {
        return this.locality;
    }

    @Override
    protected String getRetrieveColumnsSql() {
        return "-- SQL Workbench \nselect column_name, \n       column_position \nfrom all_part_key_columns \nwhere object_type = 'INDEX' \n  and owner = ? \n  and name = ? \norder by column_position \n";
    }

    @Override
    protected String getRetrievePartitionDefinitionSql() {
        return "-- SQL Workbench \nselect owner,  \n       table_name, \n       partitioning_type,  \n       partition_count, \n       locality, \n        partitioning_key_count, \n       subpartitioning_type, \n       subpartitioning_key_count, \n       def_subpartition_count, \n       def_tablespace_name, \n       null as ref_ptn_constraint_name \nfrom all_part_indexes \nwhere owner = ? \n  and index_name = ? ";
    }

    @Override
    protected String getRetrievePartitionsSql() {
        if (this.useCompression) {
            return "-- SQL Workbench \nSELECT partition_name,  \n       high_value,  \n       partition_position, \n       subpartition_count, \n       compression \nFROM all_ind_partitions \nWHERE index_owner = ?  \n  AND index_name = ? \nORDER BY partition_position";
        }
        return "-- SQL Workbench \nSELECT partition_name,  \n       high_value,  \n       partition_position, \n       subpartition_count \nFROM all_ind_partitions \nWHERE index_owner = ?  \n  AND index_name = ? \nORDER BY partition_position";
    }

    @Override
    protected String getRetrieveSubColumnsSql() {
        return "-- SQL Workbench \nselect name, \n       object_type, \n       column_name, \n       column_position \nfrom all_subpart_key_columns \nwhere object_type = 'INDEX' \n   and owner = ? \n  and name = ? \norder by column_position";
    }

    @Override
    protected String getRetrieveSubPartitionsSql() {
        if (this.useCompression) {
            return "-- SQL Workbench \nselect partition_name,  \n       subpartition_name,  \n       high_value, \n       subpartition_position, \n       compression \nfrom all_ind_subpartitions \nwhere index_owner = ?  \n  and index_name = ?  \norder by subpartition_position";
        }
        return "-- SQL Workbench \nselect partition_name,  \n       subpartition_name,  \n       high_value, \n       subpartition_position \nfrom all_ind_subpartitions \nwhere index_owner = ?  \n  and index_name = ?  \norder by subpartition_position";
    }

    @Override
    protected boolean shouldRetrievePartitions() {
        return !"LOCAL".equalsIgnoreCase(this.locality) || this.showLocalIndexPartitions;
    }
}

