/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ProcedureDefinition;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class OraclePackageParser {
    private String packageDeclaration;
    private String packageBody;
    private String packageName;

    public OraclePackageParser(String string) {
        try {
            this.parse(string);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not parse SQL", exception);
        }
    }

    public String getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public String getPackageBody() {
        return this.packageBody;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static CharSequence getProcedureSource(CharSequence charSequence, ProcedureDefinition procedureDefinition, List<String> list) {
        CodeArea codeArea = OraclePackageParser.findProcedureArea(charSequence, procedureDefinition, list);
        if (codeArea.startPos > -1 && codeArea.endPos > -1) {
            int n = StringUtil.getLineStart(charSequence, codeArea.startPos);
            return charSequence.subSequence(n > 0 ? n : codeArea.startPos, codeArea.endPos);
        }
        return null;
    }

    private void parse(String string) throws IOException {
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(ParserType.Oracle, (CharSequence)string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        while (sQLToken != null) {
            block6: {
                String string2;
                block7: {
                    block5: {
                        string2 = sQLToken.getContents();
                        if (!OraclePackageParser.isCreate(string2)) break block5;
                        n5 = sQLToken.getCharBegin();
                        break block6;
                    }
                    if (!string2.equals("PACKAGE")) break block7;
                    n = n5;
                    sQLToken = sQLLexer.getNextToken(false, false);
                    if (sQLToken == null) continue;
                    if (!sQLToken.isIdentifier()) break block6;
                    this.packageName = sQLToken.getContents();
                    sQLToken = this.findEnd(sQLLexer, this.packageName);
                    if (sQLToken == null) break block6;
                    n2 = sQLToken.getCharEnd();
                    break block6;
                }
                if (string2.equals("PACKAGE BODY")) {
                    n3 = n5;
                    sQLToken = sQLLexer.getNextToken(false, false);
                    if (sQLToken == null) continue;
                    String string3 = sQLToken.getContents();
                    if ((sQLToken = this.findEnd(sQLLexer, string3)) != null) {
                        n4 = sQLToken.getCharEnd();
                        break;
                    }
                }
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (n > -1 && n2 > n) {
            this.packageDeclaration = string.substring(n, n2);
        }
        if (n3 > -1 && n4 > n3) {
            this.packageBody = string.substring(n3, n4);
        }
    }

    private static boolean isCreate(String string) {
        return string.equals("CREATE") || string.equals("CREATE OR REPLACE");
    }

    private SQLToken findEnd(SQLLexer sQLLexer, String string) throws IOException {
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        boolean bl = false;
        while (sQLToken != null) {
            String string2 = sQLToken.getContents();
            if (string2.equalsIgnoreCase("END")) {
                bl = true;
            } else {
                if (bl && string.equalsIgnoreCase(string2)) {
                    SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
                    if (sQLToken2 != null) {
                        return sQLToken2;
                    }
                    return sQLToken;
                }
                bl = false;
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        return null;
    }

    public static int findProcedurePosition(CharSequence charSequence, ProcedureDefinition procedureDefinition, List<String> list) {
        CodeArea codeArea = OraclePackageParser.findProcedureArea(charSequence, procedureDefinition, list);
        return codeArea.startPos;
    }

    private static CodeArea findProcedureArea(CharSequence charSequence, ProcedureDefinition procedureDefinition, List<String> list) {
        List<String> list2;
        Object object;
        String string;
        int n = -1;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(charSequence);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        CodeArea codeArea = new CodeArea();
        boolean bl = false;
        String string2 = string = procedureDefinition.isFunction() ? "FUNCTION" : "PROCEDURE";
        while (sQLToken != null) {
            if (sQLToken.getContents().equals("PACKAGE") || sQLToken.getContents().equals("TYPE")) {
                bl = true;
            }
            if (sQLToken.getContents().equals("PACKAGE BODY") || sQLToken.getContents().equals("TYPE BODY")) break;
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (sQLToken == null && !bl) {
            return codeArea;
        }
        if (bl && sQLToken == null) {
            sQLLexer = SQLLexerFactory.createLexer(charSequence);
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        int n2 = -1;
        while (sQLToken != null) {
            object = sQLToken.getContents();
            if (n2 > -1 && ((String)object).equalsIgnoreCase(procedureDefinition.getProcedureName())) {
                n = n2;
                if (list == null) break;
                sQLToken = sQLLexer.getNextToken(false, false);
                if (sQLToken != null && sQLToken.getContents().equals("(")) {
                    list2 = OraclePackageParser.getParameters(sQLLexer);
                    if (OraclePackageParser.compareArguments(list2, list)) {
                        break;
                    }
                } else {
                    if (CollectionUtil.isEmpty(list)) break;
                    n2 = -1;
                    continue;
                }
            }
            n2 = ((String)object).equals(string) ? sQLToken.getCharBegin() : -1;
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        codeArea.startPos = n;
        object = sQLToken;
        list2 = null;
        while (sQLToken != null) {
            String string3 = sQLToken.getContents();
            if (string3.equals("PROCEDURE") || string3.equals("FUNCTION")) {
                codeArea.endPos = object == null ? sQLToken.getCharBegin() - 1 : ((SQLToken)object).getCharEnd();
                break;
            }
            if (string3.equals("END")) {
                list2 = sQLToken;
            }
            object = sQLToken;
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (codeArea.endPos == -1 && list2 != null) {
            codeArea.endPos = ((SQLToken)((Object)list2)).getCharBegin() - 1;
        }
        return codeArea;
    }

    private static List<String> getParameters(SQLLexer sQLLexer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        boolean bl = true;
        int n = 0;
        while (sQLToken != null) {
            if (sQLToken.getText().equals("(")) {
                ++n;
            }
            if (sQLToken.getText().equals(")")) {
                if (n == 0) break;
                --n;
            }
            if (bl) {
                arrayList.add(sQLToken.getText());
                bl = false;
            } else {
                bl = sQLToken.getText().equals(",");
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        return arrayList;
    }

    private static boolean compareArguments(List<String> list, List<String> list2) {
        if (CollectionUtil.isEmpty(list) && CollectionUtil.isEmpty(list2)) {
            return true;
        }
        if (CollectionUtil.isEmpty(list) && CollectionUtil.isNonEmpty(list2)) {
            return false;
        }
        if (CollectionUtil.isNonEmpty(list) && CollectionUtil.isEmpty(list2)) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (StringUtil.equalStringIgnoreCase(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class CodeArea {
        int startPos = -1;
        int endPos = -1;

        private CodeArea() {
        }
    }
}

