/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleObjectType;
import workbench.db.oracle.OraclePackageParser;
import workbench.db.oracle.OracleTypeReader;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleProcedureReader
extends JdbcProcedureReader {
    public static final int COLUMN_IDX_PROC_LIST_ORA_STATUS = 5;
    private OracleTypeReader typeReader = new OracleTypeReader();
    private final StringBuilder procHeader = new StringBuilder("CREATE OR REPLACE ");

    public OracleProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public StringBuilder getProcedureHeader(ProcedureDefinition procedureDefinition) {
        return this.procHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packageExists(String string, String string2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "package existence", "-- SQL Workbench \nSELECT count(*) \nFROM all_objects \nWHERE object_name = ? \n  AND owner = ? \n  AND object_type = 'PACKAGE'", string2, string);
        int n = 0;
        try {
            WbConnection wbConnection = this.connection;
            synchronized (wbConnection) {
                preparedStatement = this.connection.getSqlConnection().prepareStatement("-- SQL Workbench \nSELECT count(*) \nFROM all_objects \nWHERE object_name = ? \n  AND owner = ? \n  AND object_type = 'PACKAGE'");
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "package existence", "-- SQL Workbench \nSELECT count(*) \nFROM all_objects \nWHERE object_name = ? \n  AND owner = ? \n  AND object_type = 'PACKAGE'", string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getPackageSource(String string, String string2, String string3) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        StringBuilder stringBuilder;
        block16: {
            if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.procedure)) {
                try {
                    ProcedureDefinition procedureDefinition = ProcedureDefinition.createOracleDefinition(string2, null, string3, 0, null);
                    return this.retrieveUsingDbmsMetadata(procedureDefinition);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            stringBuilder = new StringBuilder(1000);
            preparedStatement = null;
            resultSet = null;
            DelimiterDefinition delimiterDefinition = this.connection.getAlternateDelimiter();
            if (delimiterDefinition == null) {
                delimiterDefinition = DelimiterDefinition.DEFAULT_ORA_DELIMITER;
            }
            LogMgr.logMetadataSql(new CallerInfo(){}, "package source", "-- SQL Workbench \nSELECT text \nFROM all_source \nWHERE name = ? \n  AND owner = ? \n  AND type = ? \nORDER BY line", string3, string2);
            try {
                int n = 0;
                WbConnection wbConnection = this.connection;
                synchronized (wbConnection) {
                    String string4;
                    preparedStatement = this.connection.getSqlConnection().prepareStatement("-- SQL Workbench \nSELECT text \nFROM all_source \nWHERE name = ? \n  AND owner = ? \n  AND type = ? \nORDER BY line");
                    preparedStatement.setString(1, string3);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setString(3, "PACKAGE");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        string4 = resultSet.getString(1);
                        if (string4 == null) continue;
                        if (++n == 1) {
                            stringBuilder.append("CREATE OR REPLACE ");
                        }
                        stringBuilder.append(StringUtil.makePlainLinefeed(string4));
                    }
                    if (n > 0) {
                        stringBuilder.append('\n');
                        stringBuilder.append(delimiterDefinition.getDelimiter());
                        stringBuilder.append('\n');
                        stringBuilder.append('\n');
                    }
                    n = 0;
                    preparedStatement.clearParameters();
                    preparedStatement.setString(1, string3);
                    preparedStatement.setString(2, string2);
                    preparedStatement.setString(3, "PACKAGE BODY");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        string4 = resultSet.getString(1);
                        if (string4 == null) continue;
                        if (++n == 1) {
                            stringBuilder.append("CREATE OR REPLACE ");
                        }
                        stringBuilder.append(StringUtil.makePlainLinefeed(string4));
                    }
                }
                stringBuilder.append('\n');
                if (n <= 0) break block16;
                stringBuilder.append(delimiterDefinition.getDelimiter());
                stringBuilder.append('\n');
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "package source", "-- SQL Workbench \nSELECT text \nFROM all_source \nWHERE name = ? \n  AND owner = ? \n  AND type = ? \nORDER BY line", string3, string2);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder;
    }

    @Override
    public DataStore buildProcedureListDataStore(DbMetadata dbMetadata, boolean bl) {
        if (this.useCustomSql()) {
            String[] stringArray = new String[]{"PROCEDURE_NAME", "TYPE", "PACKAGE", "SCHEMA", "REMARKS", "STATUS"};
            int[] nArray = new int[]{12, 12, 12, 12, 12, 12};
            int[] nArray2 = new int[]{30, 12, 10, 10, 20, 20};
            DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
            return dataStore;
        }
        DataStore dataStore = super.buildProcedureListDataStore(dbMetadata, bl);
        dataStore.getResultInfo().getColumn(2).setColumnName("PACKAGE");
        return dataStore;
    }

    public ProcedureDefinition resolveSynonym(String string, String string2, String string3) throws SQLException {
        TableIdentifier tableIdentifier = this.connection.getMetadata().getSynonymTable(new TableIdentifier(string3));
        if (tableIdentifier == null && string != null) {
            tableIdentifier = this.connection.getMetadata().getSynonymTable(new TableIdentifier(string));
        }
        if (tableIdentifier != null) {
            string2 = tableIdentifier.getSchema();
            if (string != null) {
                string = tableIdentifier.getTableName();
            }
            return ProcedureDefinition.createOracleDefinition(string2, string3, string, 0, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        String string;
        String string2 = procedureDefinition.getOracleOverloadIndex();
        DataStore dataStore = this.createProcColsDataStore();
        ResultSet resultSet = null;
        try {
            String string3 = this.connection.getSearchStringEscape();
            string = procedureDefinition.getCatalog();
            String string4 = procedureDefinition.getSchema();
            String string5 = procedureDefinition.getProcedureName();
            string4 = SqlUtil.escapeUnderscore(string4, string3);
            string5 = SqlUtil.escapeUnderscore(string5, string3);
            resultSet = this.connection.getSqlConnection().getMetaData().getProcedureColumns(string, string4, string5, "%");
            int n = JdbcUtils.getColumnIndex(resultSet, "OVERLOAD");
            while (resultSet.next()) {
                String string6;
                if (string2 != null && n > 0 && !StringUtil.equalString(string6 = resultSet.getString(n), string2) || !StringUtil.equalString(string, string6 = resultSet.getString("PROCEDURE_CAT"))) continue;
                this.processProcedureColumnResultRow(dataStore, resultSet);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResult(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResult(resultSet);
        for (int i = dataStore.getRowCount() - 1; i >= 0; --i) {
            string = dataStore.getValueAsString(i, 0);
            int n = dataStore.getValueAsInt(i, 3, 1111);
            if (!"SELF".equals(string) || n != 1111) continue;
            dataStore.deleteRow(i);
        }
        return dataStore;
    }

    private boolean useCustomSql() {
        if (this.connection == null) {
            return false;
        }
        return JdbcUtils.hasMinimumServerVersion(this.connection, "9.0") && Settings.getInstance().getBoolProperty("workbench.db.oracle.procedures.custom_sql", true);
    }

    private DataStore getProceduresFromJdbc(String string, String string2, String string3) throws SQLException {
        DataStore dataStore = super.getProcedures(string, string2, string3);
        int n = dataStore.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string4 = dataStore.getValueAsString(i, 0);
            String string5 = dataStore.getValueAsString(i, 3);
            String string6 = dataStore.getValueAsString(i, 2);
            String string7 = dataStore.getValueAsString(i, 4);
            int n2 = dataStore.getValueAsInt(i, 1, 1);
            ProcedureDefinition procedureDefinition = ProcedureDefinition.createOracleDefinition(string5, string4, string6, n2, string7);
            dataStore.getRow(i).setUserObject(procedureDefinition);
        }
        return dataStore;
    }

    private String getNameCondition(String string) {
        if (StringUtil.isEmptyString(string)) {
            return "";
        }
        if (string.contains("_") || string.contains("%")) {
            return "LIKE '" + string + "' ";
        }
        return "= '" + string + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        if (!this.useCustomSql()) {
            return this.getProceduresFromJdbc(string, string2, string3);
        }
        string2 = DbMetadata.cleanupWildcards(string2);
        string3 = DbMetadata.cleanupWildcards(string3);
        string2 = this.connection.getMetadata().adjustObjectnameCase(string2);
        string = this.connection.getMetadata().adjustObjectnameCase(string);
        string3 = this.connection.getMetadata().adjustObjectnameCase(string3);
        String string4 = "  select null as package_name,   \n         ao.owner as procedure_owner,   \n         ao.object_name as procedure_name,  \n         null as overload_index,  \n         null as remarks,  \n         decode(ao.object_type, 'PROCEDURE', 1, 'FUNCTION', 2, 0) as PROCEDURE_TYPE,  \n         ao.status  \n  from all_objects ao  \n    left join all_procedures ap on ao.object_name = ap.object_name and ao.owner = ap.owner   \n  where ao.object_type in ('PROCEDURE', 'FUNCTION') ";
        if (StringUtil.isNonBlank(string2)) {
            string4 = string4 + "\n    and ao.owner = '" + string2 + "' ";
        }
        if (StringUtil.isNonBlank(string3)) {
            string4 = string4 + "\n    and ao.object_name " + this.getNameCondition(string3);
        }
        String string5 = "  select package_name, procedure_owner, procedure_name, overload_index, remarks, procedure_type, status \n  from ( \n    select ap.object_name as package_name, \n           ap.owner as procedure_owner, \n           ap.procedure_name, \n           ap.overload as overload_index, \n           decode(ao.object_type, 'TYPE', 'OBJECT TYPE', ao.object_type) as remarks, \n           decode(aa.anz, 1, 2, 1 ) as procedure_type, \n           ao.status,  \n           row_number() over (partition by ap.owner, ap.object_name, ap.procedure_name, ap.overload order by ao.object_type desc) as rn \n    from all_procedures ap \n      join all_objects ao on ap.object_name = ao.object_name and ap.owner = ao.owner \n      left join (\n        select owner, package_name, object_name, count(*) as anz \n        from all_arguments \n        where in_out = 'OUT' \n          and argument_name is null \n        group by owner, package_name, object_name \n      ) aa on aa.owner = ap.owner \n          and aa.package_name = ap.object_name \n          and aa.object_name = ap.procedure_name \n    where ao.object_type IN ('PACKAGE BODY', 'PACKAGE', 'TYPE', 'OBJECT TYPE') \n      and ap.procedure_name is not null \n      and ap.object_name    is not null \n  )\n  where rn = 1";
        if (StringUtil.isNonBlank(string2)) {
            string5 = string5 + "\n    and procedure_owner = '" + string2 + "' ";
        }
        if (StringUtil.isNonBlank(string3)) {
            string5 = string5 + "\n    and procedure_name " + this.getNameCondition(string3);
        }
        if (StringUtil.isNonBlank(string)) {
            string5 = string5 + "\n    and package_name = '" + string + "' ";
        }
        String string6 = "-- SQL Workbench \nselect " + OracleUtils.getCacheHint() + "* \nfrom (\n";
        string6 = StringUtil.isBlank(string) ? string6 + string4 + "\n  UNION ALL \n" + string5 : string6 + string5;
        string6 = string6 + "\n)\nORDER BY 2,3,4";
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedures", string6, new Object[0]);
        long l = System.currentTimeMillis();
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = this.buildProcedureListDataStore(this.connection.getMetadata(), false);
        try {
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(string6);
            while (resultSet.next()) {
                String string7 = resultSet.getString("PACKAGE_NAME");
                String string8 = resultSet.getString("PROCEDURE_OWNER");
                String string9 = resultSet.getString("PROCEDURE_NAME");
                String string10 = resultSet.getString("REMARKS");
                String string11 = resultSet.getString("OVERLOAD_INDEX");
                int n = resultSet.getInt("PROCEDURE_TYPE");
                String string12 = resultSet.getString("STATUS");
                Integer n2 = resultSet.wasNull() || n == 0 ? Integer.valueOf(1) : Integer.valueOf(n);
                ProcedureDefinition procedureDefinition = ProcedureDefinition.createOracleDefinition(string8, string9, string7, n, string10);
                procedureDefinition.setOracleOverloadIndex(string11);
                int n3 = dataStore.addRow();
                dataStore.setValue(n3, 2, (Object)string7);
                dataStore.setValue(n3, 3, (Object)string8);
                dataStore.setValue(n3, 0, (Object)string9);
                dataStore.setValue(n3, 1, (Object)n2);
                dataStore.setValue(n3, 4, (Object)string10);
                dataStore.setValue(n3, 5, (Object)string12);
                dataStore.getRow(n3).setUserObject(procedureDefinition);
            }
            dataStore.resetStatus();
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedures", string6, new Object[0]);
                System.setProperty("workbench.db.oracle.procedures.custom_sql", "false");
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving procedures took: " + l2 + "ms");
        return dataStore;
    }

    private CharSequence retrieveUsingDbmsMetadata(ProcedureDefinition procedureDefinition) throws SQLException {
        if (procedureDefinition == null) {
            return null;
        }
        if (procedureDefinition.isPackageProcedure()) {
            return DbmsMetadata.getDDL(this.connection, "PACKAGE", procedureDefinition.getPackageName(), procedureDefinition.getSchema());
        }
        return DbmsMetadata.getDDL(this.connection, "PROCEDURE", procedureDefinition.getProcedureName(), procedureDefinition.getSchema());
    }

    @Override
    protected CharSequence retrieveProcedureSource(ProcedureDefinition procedureDefinition) throws NoConfigException {
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.procedure)) {
            try {
                return this.retrieveUsingDbmsMetadata(procedureDefinition);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return super.retrieveProcedureSource(procedureDefinition);
    }

    @Override
    public void readProcedureSource(ProcedureDefinition procedureDefinition, String string, String string2) throws NoConfigException {
        if (procedureDefinition.getPackageName() != null) {
            CharSequence charSequence = this.getPackageSource(null, procedureDefinition.getSchema(), procedureDefinition.getPackageName());
            if (StringUtil.isBlank(charSequence)) {
                OracleObjectType oracleObjectType = new OracleObjectType(procedureDefinition.getSchema(), procedureDefinition.getPackageName());
                charSequence = this.typeReader.getObjectSource(this.connection, oracleObjectType);
            }
            procedureDefinition.setSource(charSequence);
        } else if (procedureDefinition.isOracleObjectType()) {
            OracleObjectType oracleObjectType = new OracleObjectType(procedureDefinition.getSchema(), procedureDefinition.getPackageName());
            String string3 = this.typeReader.getObjectSource(this.connection, oracleObjectType);
            procedureDefinition.setSource(string3);
        } else {
            super.readProcedureSource(procedureDefinition, string, string2);
        }
    }

    @Override
    public ProcedureDefinition findProcedureByName(DbObject dbObject) throws SQLException {
        DataStore dataStore;
        Object object;
        if (dbObject == null) {
            return null;
        }
        String string = dbObject.getSchema();
        String string2 = dbObject.getCatalog();
        if (string != null && string2 != null) {
            object = this.getProcedures(string, string2, dbObject.getObjectName());
            if (((DataStore)object).getRowCount() == 0) {
                return null;
            }
            if (((DataStore)object).getRowCount() > 0) {
                return (ProcedureDefinition)((DataStore)object).getRow(0).getUserObject();
            }
        }
        object = this.connection.getMetadata().adjustObjectnameCase(this.connection.getCurrentUser());
        if (string != null) {
            dataStore = this.getProcedures(string, (String)object, dbObject.getObjectName());
            if (dataStore.getRowCount() > 0) {
                return (ProcedureDefinition)dataStore.getRow(0).getUserObject();
            }
            dataStore = this.getProcedures(null, string, dbObject.getObjectName());
            if (dataStore.getRowCount() > 0) {
                return (ProcedureDefinition)dataStore.getRow(0).getUserObject();
            }
        }
        if ((dataStore = this.getProcedures(null, (String)object, dbObject.getObjectName())).getRowCount() > 0) {
            return (ProcedureDefinition)dataStore.getRow(0).getUserObject();
        }
        dataStore = this.getProcedures(null, null, dbObject.getObjectName());
        if (dataStore.getRowCount() > 0) {
            return (ProcedureDefinition)dataStore.getRow(0).getUserObject();
        }
        return null;
    }

    @Override
    public boolean supportsPackages() {
        return true;
    }

    public List<String> getParameterNames(ProcedureDefinition procedureDefinition) {
        try {
            DataStore dataStore = this.getProcedureColumns(procedureDefinition);
            if (dataStore == null) {
                return Collections.emptyList();
            }
            int n = dataStore.getRowCount();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                String string = dataStore.getValueAsString(i, 0);
                if (string == null) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read procedure parameter names", sQLException);
            return Collections.emptyList();
        }
    }

    @Override
    public CharSequence getPackageProcedureSource(ProcedureDefinition procedureDefinition) {
        if (!this.supportsPackages()) {
            return null;
        }
        if (procedureDefinition == null) {
            return null;
        }
        if (!procedureDefinition.isPackageProcedure()) {
            return null;
        }
        CharSequence charSequence = null;
        try {
            if (procedureDefinition.getSource() == null) {
                this.readProcedureSource(procedureDefinition, null, null);
            }
            if (procedureDefinition.getSource() != null) {
                charSequence = OraclePackageParser.getProcedureSource(procedureDefinition.getSource(), procedureDefinition, this.getParameterNames(procedureDefinition));
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read procedure source", exception);
        }
        return charSequence;
    }
}

