/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.ColumnRemover;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleSequenceReader
implements SequenceReader {
    private WbConnection connection;
    private boolean is12c;
    private boolean hasIdentitySeqName;

    public OracleSequenceReader(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.is12c = JdbcUtils.hasMinimumServerVersion(this.connection, "12.1");
        this.hasIdentitySeqName = OracleUtils.is12_1_0_2(wbConnection);
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        SequenceDefinition sequenceDefinition = this.createDefinition(dataStore, 0);
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("-- SQL Workbench \nselect " + OracleUtils.getCacheHint() + "s.sequence_owner, \n       s.sequence_name, \n       s.min_value, \n       s.max_value, \n       s.increment_by, \n       case when cycle_flag = 'Y' then 'CYCLE' else 'NOCYCLE' end as cycle_flag, \n       case when order_flag = 'Y' then 'ORDER' else 'NOORDER' end as order_flag, \n       s.cache_size, \n       s.last_number, \n" + (this.hasIdentitySeqName ? "       ic.table_name, \n" : "       null as table_name, \n") + (this.hasIdentitySeqName ? "       ic.column_name \n" : "       null as column_name \n") + "from all_sequences s \n");
        if (this.hasIdentitySeqName) {
            stringBuilder.append("  left join all_tab_identity_cols ic on ic.owner = s.sequence_owner and ic.sequence_name = s.sequence_name \n");
        }
        stringBuilder.append("WHERE s.sequence_owner = '");
        if (this.is12c && this.connection.getDbSettings().hideOracleIdentitySequences() && StringUtil.isEmptyString(string3)) {
            stringBuilder.append("  AND s.sequence_name NOT LIKE 'ISEQ$$%'");
        }
        stringBuilder.append(StringUtil.trimQuotes(string2));
        stringBuilder.append("'\n ");
        if (StringUtil.isNonEmpty(string3)) {
            SqlUtil.appendAndCondition(stringBuilder, "s.sequence_name", string3, this.connection);
        }
        stringBuilder.append("\nORDER BY 1,2");
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, this.connection, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence definition", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (!this.hasIdentitySeqName) {
            ColumnRemover columnRemover = new ColumnRemover(dataStore);
            dataStore = columnRemover.removeColumnsByName("TABLE_NAME", "COLUMN_NAME");
        }
        return dataStore;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        return sequenceDefinition.getSource();
    }

    private SequenceDefinition createDefinition(DataStore dataStore, int n) {
        if (dataStore == null || n >= dataStore.getRowCount()) {
            return null;
        }
        String string = dataStore.getValueAsString(n, "SEQUENCE_NAME");
        String string2 = dataStore.getValueAsString(n, "SEQUENCE_OWNER");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "MIN_VALUE"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "MAX_VALUE"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "INCREMENT_BY"));
        sequenceDefinition.setSequenceProperty("cycle", Boolean.toString("CYCLE".equalsIgnoreCase(dataStore.getValueAsString(n, "CYCLE_FLAG"))));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "CACHE_SIZE"));
        sequenceDefinition.setSequenceProperty("ordered", Boolean.toString("ORDER".equalsIgnoreCase(dataStore.getValueAsString(n, "ORDER_FLAG"))));
        int n2 = dataStore.getColumnIndex("TABLE_NAME");
        if (n2 > -1) {
            String string3 = dataStore.getValueAsString(n, "TABLE_NAME");
            String string4 = dataStore.getValueAsString(n, "COLUMN_NAME");
            if (string3 != null && string4 != null) {
                TableIdentifier tableIdentifier = new TableIdentifier(string2, string3);
                sequenceDefinition.setRelatedTable(tableIdentifier, string4);
            }
        }
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        if (sequenceDefinition.getSource() != null) {
            return;
        }
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.sequence)) {
            try {
                String string = DbmsMetadata.getDDL(this.connection, "SEQUENCE", sequenceDefinition.getObjectName(), sequenceDefinition.getSchema());
                sequenceDefinition.setSource(string);
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        TableIdentifier tableIdentifier = sequenceDefinition.getRelatedTable();
        String string2 = sequenceDefinition.getRelatedColumn();
        if (tableIdentifier != null && string2 != null) {
            stringBuilder.append("-- identity sequence for " + tableIdentifier.getTableName() + "." + string2);
            stringBuilder.append(string);
        }
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        Number number = (Number)sequenceDefinition.getSequenceProperty("min_value");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("increment");
        String string3 = (String)sequenceDefinition.getSequenceProperty("cycle");
        String string4 = (String)sequenceDefinition.getSequenceProperty("ordered");
        Number number4 = (Number)sequenceDefinition.getSequenceProperty("cache");
        stringBuilder.append(string).append("       INCREMENT BY ");
        stringBuilder.append(number3);
        if (number != null && number.intValue() != 1) {
            stringBuilder.append(string).append("       MINVALUE ");
            stringBuilder.append(number);
        } else {
            stringBuilder.append(string).append("       NOMINVALUE");
        }
        if (number2 != null && !number2.toString().startsWith("999999999999999999999999999")) {
            stringBuilder.append(string).append("       MAXVALUE ");
            stringBuilder.append(number2);
        } else {
            stringBuilder.append(string).append("       NOMAXVALUE");
        }
        if (number4 != null && number4.longValue() > 0L) {
            stringBuilder.append(string).append("       CACHE ");
            stringBuilder.append(number4);
        } else {
            stringBuilder.append(string).append("       NOCACHE");
        }
        stringBuilder.append(string).append("       ");
        stringBuilder.append(Boolean.valueOf(string3) != false ? "CYCLE" : "NOCYCLE");
        stringBuilder.append(string).append("       ");
        stringBuilder.append(Boolean.valueOf(string4) != false ? "ORDER" : "NOORDER");
        stringBuilder.append(';');
        stringBuilder.append(string);
        sequenceDefinition.setSource(stringBuilder);
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

