/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.DataTypeResolver;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.JdbcTableDefinitionReader;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleDataTypeResolver;
import workbench.db.oracle.OracleIdentityOptionParser;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class OracleTableDefinitionReader
extends JdbcTableDefinitionReader {
    private final OracleDataTypeResolver oraTypes;
    private final boolean is12c;
    private final boolean isOracle8;
    private String currentUser;

    public OracleTableDefinitionReader(WbConnection wbConnection, OracleDataTypeResolver oracleDataTypeResolver) {
        super(wbConnection);
        this.currentUser = wbConnection.getCurrentUser();
        this.is12c = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "12.1");
        this.isOracle8 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.0");
        if (!JdbcUtils.hasMiniumDriverVersion(wbConnection.getSqlConnection(), "11.2") && Settings.getInstance().getBoolProperty("workbench.db.oracle.fixescapebug", true) && Settings.getInstance().getProperty("workbench.db.oracle.searchstringescape", null) == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Old Oracle JDBC driver detected. Turning off wildcard handling for objects retrieval to work around driver bug");
            System.setProperty("workbench.db.oracle.metadata.retrieval.wildcards", "false");
            System.setProperty("workbench.db.oracle.escape.searchstrings", "false");
        }
        this.oraTypes = oracleDataTypeResolver;
    }

    private boolean useOwnSql() {
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.oracle.fixnvarchartype", true);
        boolean bl2 = Settings.getInstance().getBoolProperty("workbench.db.oracle.fixcharsemantics", true);
        boolean bl3 = Settings.getInstance().getBoolProperty("workbench.db.oracle.tablecolumns.custom_sql", bl || bl2);
        return this.isOracle8 && bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnIdentifier> getTableColumns(TableIdentifier tableIdentifier, DataTypeResolver dataTypeResolver) throws SQLException {
        if (!this.useOwnSql()) {
            return super.getTableColumns(tableIdentifier, dataTypeResolver);
        }
        PkDefinition pkDefinition = tableIdentifier.getPrimaryKey();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        if (pkDefinition != null) {
            set.addAll(pkDefinition.getColumns());
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        String string = StringUtil.trimQuotes(tableIdentifier.getSchema());
        String string2 = StringUtil.trimQuotes(tableIdentifier.getTableName());
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        long l = System.currentTimeMillis();
        try {
            preparedStatement = this.prepareColumnsStatement(string, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet != null && resultSet.next()) {
                String string3;
                String string4 = resultSet.getString("COLUMN_NAME");
                int n = resultSet.getInt("DATA_TYPE");
                String string5 = resultSet.getString("TYPE_NAME");
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(dbMetadata.quoteObjectname(string4), this.oraTypes.fixColumnType(n, string5));
                int n2 = resultSet.getInt("COLUMN_SIZE");
                if (resultSet.wasNull()) {
                    n2 = Integer.MAX_VALUE;
                }
                int n3 = resultSet.getInt("DECIMAL_DIGITS");
                if (resultSet.wasNull()) {
                    n3 = -1;
                }
                String string6 = resultSet.getString("REMARKS");
                String string7 = resultSet.getString("COLUMN_DEF");
                if (string7 != null && dbSettings.trimDefaults()) {
                    string7 = string7.trim();
                }
                int n4 = resultSet.getInt("ORDINAL_POSITION");
                String string8 = resultSet.getString("IS_NULLABLE");
                String string9 = resultSet.getString("CHAR_USED");
                OracleDataTypeResolver.CharSemantics charSemantics = this.oraTypes.getDefaultCharSemantics();
                if (StringUtil.isEmptyString(string9)) {
                    charSemantics = this.oraTypes.getDefaultCharSemantics();
                } else if ("B".equals(string9.trim())) {
                    charSemantics = OracleDataTypeResolver.CharSemantics.Byte;
                } else if ("C".equals(string9.trim())) {
                    charSemantics = OracleDataTypeResolver.CharSemantics.Char;
                }
                String string10 = resultSet.getString("IDENTITY_COLUMN");
                boolean bl2 = "YES".equalsIgnoreCase(string10);
                bl = bl || bl2;
                String string11 = resultSet.getString("VIRTUAL_COLUMN");
                boolean bl3 = StringUtil.stringToBool(string11);
                String string12 = this.oraTypes.getSqlTypeDisplay(string5, n, n2, n3, charSemantics);
                columnIdentifier.setDbmsType(string12);
                columnIdentifier.setIsPkColumn(set.contains(string4));
                columnIdentifier.setIsNullable("YES".equalsIgnoreCase(string8));
                if (bl3 && n != 1111) {
                    string3 = "GENERATED ALWAYS AS (" + string7 + ")";
                    columnIdentifier.setComputedColumnExpression(string3);
                } else {
                    string3 = resultSet.getString("DEFAULT_ON_NULL");
                    if ("YES".equalsIgnoreCase(string3)) {
                        columnIdentifier.setDefaultClause("DEFAULT ON NULL");
                    }
                    columnIdentifier.setDefaultValue(string7);
                }
                columnIdentifier.setComment(string6);
                columnIdentifier.setColumnSize(n2);
                columnIdentifier.setDecimalDigits(n3);
                columnIdentifier.setPosition(n4);
                columnIdentifier.setIsAutoincrement(bl2);
                arrayList.add(columnIdentifier);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeAll(resultSet, preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (arrayList.size() > 0 && tableIdentifier.getType() == null) {
            tableIdentifier.setType("TABLE");
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving table columns for " + tableIdentifier.getTableExpression() + " took " + l2 + "ms");
        if (bl) {
            this.retrieveIdentityColumns(arrayList, string, string2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveIdentityColumns(List<ColumnIdentifier> list, String string, String string2) {
        boolean bl = OracleUtils.optimizeCatalogQueries() && this.currentUser.equalsIgnoreCase(string);
        String string3 = "-- SQL Workbench \nselect column_name,  generation_type,  identity_options\n";
        string3 = bl ? string3 + "from user_tab_identity_cols \nwhere table_name = ? " : string3 + "from all_tab_identity_cols \nwhere table_name = ? \n  and owner = ? ";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "identity columns", string3, string2, string);
        long l = System.currentTimeMillis();
        OracleIdentityOptionParser oracleIdentityOptionParser = new OracleIdentityOptionParser();
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string2);
            if (!bl) {
                preparedStatement.setString(2, string);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString("column_name");
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string4);
                if (columnIdentifier == null) continue;
                String string5 = resultSet.getString("GENERATION_TYPE");
                String string6 = "GENERATED " + string5 + " AS IDENTITY";
                String string7 = resultSet.getString("IDENTITY_OPTIONS");
                String string8 = oracleIdentityOptionParser.getIdentitySequenceOptions(string7);
                if (StringUtil.isNonBlank(string8)) {
                    string6 = string6 + " " + string8;
                }
                columnIdentifier.setComputedColumnExpression(string6);
                columnIdentifier.setDefaultValue(null);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "identity columns", string3, string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving identity column information for " + string + "." + string2 + " took " + l2 + "ms");
    }

    public static String getDecodeForDataType(String string, boolean bl) {
        return "     DECODE(" + string + ", \n            'CHAR', " + 1 + ", \n            'VARCHAR2', " + 12 + ", \n            'NVARCHAR2', " + -9 + ", \n            'NCHAR', " + -15 + ", \n            'NUMBER', " + 3 + ", \n            'LONG', " + -1 + ", \n            'DATE', " + (bl ? 93 : 91) + ", \n            'RAW', " + -3 + ", \n            'LONG RAW', " + -4 + ", \n            'BLOB', " + 2004 + ", \n            'CLOB', " + 2005 + ", \n            'NCLOB', " + 2011 + ", \n            'ROWID', " + -8 + ", \n            'BFILE', -13, \n            'FLOAT', " + 6 + ", \n            'TIMESTAMP(6)', " + 93 + ", \n            'TIMESTAMP(6) WITH TIME ZONE', -101, \n            'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n            'INTERVAL YEAR(2) TO MONTH', -103, \n            'INTERVAL DAY(2) TO SECOND(6)', -104, \n            'BINARY_FLOAT', 100, \n            'BINARY_DOUBLE', 101, " + 1111 + ")";
    }

    private PreparedStatement prepareColumnsStatement(String string, String string2) throws SQLException {
        Object object;
        int n;
        boolean bl = OracleUtils.optimizeCatalogQueries() && this.currentUser.equalsIgnoreCase(string);
        String string3 = "-- SQL Workbench \nSELECT " + OracleUtils.getCacheHint() + " t.column_name AS column_name,  \n" + OracleTableDefinitionReader.getDecodeForDataType("t.data_type", OracleUtils.getMapDateToTimestamp(this.dbConnection)) + " AS data_type, \n     t.data_type AS type_name,  \n     decode(t.data_type, 'VARCHAR', t.char_length, \n                         'VARCHAR2', t.char_length, \n                         'NVARCHAR', t.char_length, \n                         'NVARCHAR2', t.char_length, \n                         'CHAR', t.char_length, \n                         'NCHAR', t.char_length, \n                         'NUMBER', t.data_precision, \n                         'FLOAT', t.data_precision, \n                         'REAL', t.data_precision, \n            t.data_length) AS column_size,  \n     case \n        when t.data_type = 'NUMBER' and t.data_precision is null then coalesce(t.data_scale,-127) \n        else t.data_scale \n     end AS decimal_digits,  \n     DECODE(t.nullable, 'N', 0, 1) AS nullable, \n     " + (this.is12c ? "t.identity_column" : " 'NO' AS IDENTITY_COLUMN") + ", \n     " + (this.is12c ? "t.default_on_null" : " 'NO' AS DEFAULT_ON_NULL") + ", \n";
        String string4 = "     t.data_default AS column_def,  \n     t.char_used, \n     t.column_id AS ordinal_position,   \n     DECODE(t.nullable, 'N', 'NO', 'YES') AS is_nullable, \n";
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "11.0");
        string4 = bl2 ? string4 + "     case \n          when data_type <> 'XMLTYPE' and DATA_TYPE_OWNER is null THEN t.virtual_column \n          else 'NO' \n      end as virtual_column " : string4 + "     null as virtual_column ";
        string4 = bl2 ? string4 + (bl ? "\nFROM user_tab_cols t" : "\nFROM all_tab_cols t") : string4 + (bl ? "\nFROM user_tab_columns t" : "\nFROM all_tab_columns t");
        String string5 = "\nWHERE t.table_name = ? \n";
        if (!bl) {
            string5 = string5 + "  AND t.owner = ? \n";
        }
        if (bl2) {
            string5 = string5 + "  AND t.hidden_column = 'NO' ";
        }
        String string6 = bl ? "\n  LEFT JOIN user_col_comments c ON t.table_name = c.table_name AND t.column_name = c.column_name" : "\n  LEFT JOIN all_col_comments c ON t.owner = c.owner AND t.table_name = c.table_name AND t.column_name = c.column_name";
        String string7 = string3 + "     c.comments AS remarks, \n" + string4 + string6 + string5 + "\nORDER BY t.column_id";
        String string8 = string3 + "       null AS remarks, \n" + string4 + string5 + "\nORDER BY t.column_id";
        String string9 = OracleUtils.getRemarksReporting(this.dbConnection) ? string7 : string8;
        int n2 = n = string2 != null ? string2.indexOf(64) : -1;
        if (n > 0) {
            object = string2.substring(n);
            string2 = string2.substring(0, n);
            string9 = StringUtil.replace(string9, "all_tab_columns", "all_tab_columns" + (String)object);
            string9 = StringUtil.replace(string9, "all_col_comments", "all_col_comments" + (String)object);
            String string10 = this.getDbLinkTargetSchema(((String)object).substring(1), string);
            if (StringUtil.isEmptyString(string) && !StringUtil.isEmptyString(string10)) {
                string = string10;
            }
        }
        object = this.dbConnection.getSqlConnection().prepareStatement(string9);
        object.setString(1, string2);
        if (!bl) {
            object.setString(2, string);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "table columns", string9, string2, string);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDbLinkTargetSchema(String string, String string2) {
        String string3;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string4 = null;
        if (string.indexOf(46) > 0) {
            string3 = "SELECT /* SQLWorkbench */ username FROM all_db_links WHERE db_link = ? AND (owner = ? or owner = 'PUBLIC')";
        } else {
            string3 = "SELECT /* SQLWorkbench */ username FROM all_db_links WHERE db_link like ? AND (owner = ? or owner = 'PUBLIC')";
            string = string + ".%";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "DBLINK target schema", string3, new Object[0]);
        try {
            WbConnection wbConnection = this.dbConnection;
            synchronized (wbConnection) {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string3);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string4 = resultSet.getString(1);
                }
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "DBLINK target schema", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return string4;
    }
}

