/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DataTypeResolver;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleObjectType;
import workbench.db.oracle.OracleTableDefinitionReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleTypeReader
implements ObjectListExtender {
    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        int n;
        if (DbMetadata.typeIncluded("TYPE", stringArray) && (n = this.updateTypes(dataStore)) == 0) {
            List<OracleObjectType> list = this.getTypes(wbConnection, string2, string3);
            for (OracleObjectType oracleObjectType : list) {
                int n2 = dataStore.addRow();
                dataStore.setValue(n2, 3, (Object)oracleObjectType.getSchema());
                dataStore.setValue(n2, 2, null);
                dataStore.setValue(n2, 0, (Object)oracleObjectType.getObjectName());
                dataStore.setValue(n2, 1, (Object)oracleObjectType.getObjectType());
                dataStore.setValue(n2, 4, (Object)oracleObjectType.getComment());
                dataStore.getRow(n2).setUserObject(oracleObjectType);
            }
            return list.size() > 0;
        }
        return false;
    }

    private int updateTypes(DataStore dataStore) {
        int n = 0;
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 1);
            if (!"TYPE".equals(string)) continue;
            String string2 = dataStore.getValueAsString(i, 3);
            String string3 = dataStore.getValueAsString(i, 0);
            OracleObjectType oracleObjectType = new OracleObjectType(string2, string3);
            dataStore.getRow(i).setUserObject(oracleObjectType);
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OracleObjectType> getTypes(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("-- SQL Workbench \nSELECT owner,  \n       type_name, \n       methods, \n       attributes \nFROM all_types ");
        int n = -1;
        int n2 = -1;
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\nWHERE owner = ? ");
            n = 1;
        }
        if (StringUtil.isNonBlank(string2)) {
            if (n != -1) {
                stringBuilder.append("\n  AND ");
                n2 = 2;
            } else {
                stringBuilder.append("\nWHERE ");
                n2 = 1;
            }
            if (string2.indexOf(37) > 0) {
                stringBuilder.append(" type_name LIKE ? ");
                SqlUtil.appendEscapeClause(stringBuilder, wbConnection, string2);
                string2 = SqlUtil.escapeUnderscore(string2, wbConnection);
            } else {
                stringBuilder.append(" type_name = ? ");
            }
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "types", stringBuilder, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<OracleObjectType> arrayList = new ArrayList<OracleObjectType>();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(stringBuilder.toString());
            if (n > -1) {
                preparedStatement.setString(n, string);
            }
            if (n2 > -1) {
                preparedStatement.setString(n2, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                int n3 = resultSet.getInt(3);
                int n4 = resultSet.getInt(4);
                OracleObjectType oracleObjectType = new OracleObjectType(string3, string4);
                oracleObjectType.setNumberOfMethods(n3);
                oracleObjectType.setNumberOfAttributes(n4);
                arrayList.add(oracleObjectType);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "types", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "TYPE".equals(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        OracleObjectType oracleObjectType = this.getObjectDefinition(wbConnection, dbObject);
        if (oracleObjectType == null) {
            return null;
        }
        String[] stringArray = new String[]{"ATTRIBUTE", "DATA_TYPE"};
        int[] nArray = new int[]{12, 12};
        int[] nArray2 = new int[]{30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        List<ColumnIdentifier> list = oracleObjectType.getAttributes();
        if (CollectionUtil.isNonEmpty(list)) {
            for (ColumnIdentifier columnIdentifier : list) {
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)columnIdentifier.getColumnName());
                dataStore.setValue(n, 1, (Object)columnIdentifier.getDbmsType());
            }
        }
        return dataStore;
    }

    @Override
    public boolean hasColumns() {
        return true;
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return this.getAttributes(wbConnection, dbObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnIdentifier> getAttributes(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        String string = "-- SQL Workbench \nSELECT attr_name,  \n       attr_type_name, \n       length,  \n       precision,  \n       scale,  \n" + OracleTableDefinitionReader.getDecodeForDataType("attr_type_name", true) + " as jdbc_type \nFROM all_type_attrs  \n";
        string = string + " WHERE type_name = '" + dbObject.getObjectName() + "' \n";
        string = string + " AND owner = '" + dbObject.getSchema() + "' \n";
        string = string + " ORDER BY attr_no";
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "type attributes", string, new Object[0]);
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            DataTypeResolver dataTypeResolver = wbConnection.getMetadata().getDataTypeResolver();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                int n3 = resultSet.getInt(5);
                int n4 = resultSet.getInt(6);
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2, n4);
                if (SqlUtil.isCharacterTypeWithLength(n4)) {
                    columnIdentifier.setDbmsType(dataTypeResolver.getSqlTypeDisplay(string3, n4, n, 0));
                } else {
                    columnIdentifier.setDbmsType(dataTypeResolver.getSqlTypeDisplay(string3, n4, n2, n3));
                    columnIdentifier.setDecimalDigits(n3);
                }
                arrayList.add(columnIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "type attributes", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public OracleObjectType getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<OracleObjectType> list = this.getTypes(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        OracleObjectType oracleObjectType = list.get(0);
        if (oracleObjectType.getNumberOfAttributes() > 0) {
            List<ColumnIdentifier> list2 = this.getAttributes(wbConnection, oracleObjectType);
            oracleObjectType.setAttributes(list2);
        }
        return oracleObjectType;
    }

    private String retrieveSource(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        String string = null;
        try {
            string = DbmsMetadata.getDDL(wbConnection, "TYPE", dbObject.getObjectName(), dbObject.getSchema());
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving source", sQLException);
        }
        return string;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        OracleObjectType oracleObjectType = this.getObjectDefinition(wbConnection, dbObject);
        if (oracleObjectType == null) {
            return null;
        }
        String string = oracleObjectType.getSource();
        if (StringUtil.isBlank(string)) {
            string = this.retrieveSource(wbConnection, dbObject);
            oracleObjectType.setSource(string);
        }
        return string;
    }
}

