/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.StreamImporter;
import workbench.db.importer.TextImportOptions;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.storage.DataStoreWriter;
import workbench.util.FileUtil;

public class PgCopyManager
implements StreamImporter {
    private final Object lock = new Object();
    private WbConnection connection;
    private String sql;
    private Reader data;
    private Object copyManager;
    private Method copyIn;
    private boolean useDefaultClassloader;
    boolean is90;

    public PgCopyManager(WbConnection wbConnection) {
        this.connection = wbConnection;
        this.is90 = wbConnection == null ? true : JdbcUtils.hasMinimumServerVersion(wbConnection, "9.0");
        this.useDefaultClassloader = WbManager.isTest();
    }

    public boolean isSupported() {
        try {
            this.initialize();
            return true;
        }
        catch (Throwable throwable) {
            LogMgr.logDebug(new CallerInfo(){}, "Error", throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ClassNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            try {
                Class clazz = null;
                Class clazz2 = null;
                String string = "org.postgresql.core.BaseConnection";
                String string2 = "org.postgresql.copy.CopyManager";
                if (this.useDefaultClassloader) {
                    clazz = Class.forName(string);
                    clazz2 = Class.forName(string2);
                } else {
                    clazz = ConnectionMgr.getInstance().loadClassFromDriverLib(this.connection.getProfile(), string);
                    clazz2 = ConnectionMgr.getInstance().loadClassFromDriverLib(this.connection.getProfile(), string2);
                }
                Constructor constructor = clazz2.getConstructor(clazz);
                this.copyManager = constructor.newInstance(this.connection.getSqlConnection());
                this.copyIn = this.copyManager.getClass().getMethod("copyIn", String.class, Reader.class);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not create CopyManager", throwable);
                throw new ClassNotFoundException("CopyManager");
            }
        }
    }

    private void skipOneLine(Reader reader) {
        try {
            if (reader instanceof BufferedReader) {
                ((BufferedReader)reader).readLine();
            } else {
                BufferedReader bufferedReader = new BufferedReader(reader);
                bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read line", iOException);
        }
    }

    public void copyFromStdin(String string, Reader reader) {
        this.sql = string;
        this.data = reader;
    }

    @Override
    public void setup(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, Reader reader, TextImportOptions textImportOptions, String string) {
        this.sql = this.createCopyStatement(tableIdentifier, list, textImportOptions, string);
        if (textImportOptions.getContainsHeader() && this.sql.contains("format text")) {
            this.skipOneLine(reader);
        }
        this.data = reader;
    }

    @Override
    public long processStreamData() throws SQLException, IOException {
        if (this.data == null || this.sql == null) {
            throw new IllegalStateException("CopyImporter not initialized");
        }
        try {
            Object object;
            if (this.copyManager == null) {
                this.initialize();
            }
            LogMgr.logDebug(new CallerInfo(){}, "Sending file contents using: " + this.sql);
            if (this.copyIn != null && (object = this.copyIn.invoke(this.copyManager, this.sql, this.data)) instanceof Number) {
                long l = ((Number)object).longValue();
                return l;
            }
            try {
                throw new SQLException("CopyAPI not available");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException("CopyAPI not available", classNotFoundException);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException) {
                    throwable = exception.getCause();
                }
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new SQLException("Could not copy data", exception.getCause() == null ? exception : exception.getCause());
            }
        }
        finally {
            FileUtil.closeQuietely(this.data);
            this.data = null;
        }
    }

    public final String createCopyStatement(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, TextImportOptions textImportOptions, String string) {
        if (!this.is90) {
            return this.createCopyStatement84(tableIdentifier, list, textImportOptions, string);
        }
        return this.createCopyStatement90(tableIdentifier, list, textImportOptions, string);
    }

    private String createCopyStatement84(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, TextImportOptions textImportOptions, String string) {
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("COPY ");
        stringBuilder.append(tableIdentifier.getTableExpression(this.connection));
        stringBuilder.append(" (");
        for (n = 0; n < list.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(list.get(n).getColumnName());
        }
        int n2 = n = textImportOptions.getTextQuoteChar() == null && textImportOptions.getDecode() ? 1 : 0;
        if (n != 0) {
            stringBuilder.append(") FROM stdin");
            return stringBuilder.toString();
        }
        stringBuilder.append(") FROM stdin WITH ");
        String string3 = textImportOptions.getNullString();
        stringBuilder.append("csv");
        if (textImportOptions.getContainsHeader()) {
            stringBuilder.append(" header ");
        }
        if ((string2 = textImportOptions.getTextQuoteChar()) != null) {
            stringBuilder.append(" quote '");
            stringBuilder.append(string2);
            stringBuilder.append('\'');
        }
        stringBuilder.append(" delimiter ");
        String string4 = textImportOptions.getTextDelimiter();
        if (string4.equals("\t") || string4.equals("\\t")) {
            stringBuilder.append("E'\\t'");
        } else {
            stringBuilder.append('\'');
            stringBuilder.append(string4);
            stringBuilder.append('\'');
        }
        if (string3 == null) {
            string3 = "";
        }
        stringBuilder.append(" NULL '");
        stringBuilder.append(string3);
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private String createCopyStatement90(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, TextImportOptions textImportOptions, String string) {
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("COPY ");
        stringBuilder.append(tableIdentifier.getTableExpression(this.connection));
        stringBuilder.append(" (");
        for (n = 0; n < list.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(list.get(n).getColumnName());
        }
        stringBuilder.append(") FROM stdin WITH (format ");
        n = textImportOptions.getTextQuoteChar() == null && textImportOptions.getDecode() ? 1 : 0;
        String string3 = textImportOptions.getNullString();
        if (n != 0) {
            stringBuilder.append("text");
        } else {
            stringBuilder.append("csv");
            stringBuilder.append(", header ");
            stringBuilder.append(Boolean.toString(textImportOptions.getContainsHeader()));
            string2 = textImportOptions.getTextQuoteChar();
            if (string2 != null) {
                stringBuilder.append(", quote '");
                stringBuilder.append(string2);
                stringBuilder.append('\'');
            }
        }
        stringBuilder.append(", delimiter ");
        string2 = textImportOptions.getTextDelimiter();
        if (string2.equals("\t") || string2.equals("\\t")) {
            stringBuilder.append("E'\\t'");
        } else {
            stringBuilder.append('\'');
            stringBuilder.append(string2);
            stringBuilder.append('\'');
        }
        if (string3 == null) {
            string3 = "";
        }
        stringBuilder.append(", NULL '");
        stringBuilder.append(string3);
        stringBuilder.append('\'');
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public DataStore copyStdOutToDataStore(String string) throws SQLException {
        DataStoreWriter dataStoreWriter = new DataStoreWriter("output");
        this.runCopyToStdOut(string, dataStoreWriter);
        return dataStoreWriter.getResult();
    }

    public String copyStdOutToString(String string) throws SQLException {
        StringWriter stringWriter = new StringWriter(1000);
        this.runCopyToStdOut(string, stringWriter);
        return stringWriter.toString();
    }

    private void runCopyToStdOut(String string, Writer writer) throws SQLException {
        try {
            if (this.copyManager == null) {
                this.initialize();
            }
            Method method = this.copyManager.getClass().getMethod("copyOut", String.class, Writer.class);
            method.invoke(this.copyManager, string, writer);
            writer.flush();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = throwable.getCause();
            }
            if (throwable2 instanceof SQLException) {
                throw (SQLException)throwable2;
            }
            LogMgr.logError(new CallerInfo(){}, "Could not call copyOut()", throwable);
            throw new SQLException("Error running COPY command", throwable2);
        }
    }
}

