/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.Serializable;
import java.sql.SQLException;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;

public class PgExtension
implements DbObject,
Serializable {
    public static final String TYPE_NAME = "EXTENSION";
    private String name;
    private String remarks;
    private String version;
    private String schema;

    public PgExtension(String string, String string2) {
        this.name = string2;
        this.schema = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.name;
    }

    public String toString() {
        return this.getObjectName();
    }

    public void setSource(String string) {
    }

    public String getSource() {
        String string = "CREATE EXTENSION IF NOT EXISTS " + SqlUtil.quoteObjectname(this.name);
        if (!"pg_catalog".equals(this.schema)) {
            string = string + "\n  WITH SCHEMA " + SqlUtil.quoteObjectname(this.schema);
        }
        if (!"1.0".equals(this.version)) {
            string = string + "\n  VERSION " + this.version;
        }
        string = string + ";";
        return string;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.getSource();
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("DROP EXTENSION ");
        stringBuilder.append(SqlUtil.quoteObjectname(this.name));
        if (bl) {
            stringBuilder.append(" CASCADE");
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.remarks;
    }

    @Override
    public void setComment(String string) {
        this.remarks = string;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

