/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;
import workbench.util.PlatformHelper;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class PgPassReader {
    private String host;
    private String port;
    private String database;
    private String pwd;
    private String username;

    public PgPassReader(String string, String string2) {
        this.username = string2;
        this.parseUrl(string);
    }

    public static boolean passFileExists() {
        File file = PgPassReader.getPgPassFile();
        return file != null && file.exists();
    }

    public String getPort() {
        return StringUtil.isEmptyString(this.port) ? "5432" : this.port;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPasswordFromFile() {
        File file = PgPassReader.getPgPassFile();
        return this.getPasswordFromFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPasswordFromFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            while (string2 != null && (string = this.getPassword(string2)) == null) {
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not read pgpass file: " + file.getAbsolutePath(), iOException);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(bufferedReader);
                throw throwable;
            }
            FileUtil.closeQuietely(bufferedReader);
        }
        FileUtil.closeQuietely(bufferedReader);
        return string;
    }

    private String getPassword(String string) {
        boolean bl;
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 5) {
            return null;
        }
        boolean bl2 = stringArray[0].equals("*") || stringArray[0].equals(this.host);
        boolean bl3 = stringArray[1].equals("*") || stringArray[1].equals(this.getPort());
        boolean bl4 = stringArray[2].equals("*") || stringArray[2].equals(this.database);
        boolean bl5 = bl = stringArray[3].equals("*") || stringArray[3].equals(this.username);
        if (bl2 && bl3 && bl && bl4) {
            return stringArray[4];
        }
        return null;
    }

    public static File getPgPassFile() {
        String string = System.getenv("PGPASSFILE");
        WbFile wbFile = null;
        if (string == null) {
            if (PlatformHelper.isWindows()) {
                String string2 = System.getenv("APPDATA");
                wbFile = new WbFile(string2 + "/postgresql/pgpass.conf");
            } else {
                String string3 = System.getenv("HOME");
                wbFile = new WbFile(string3 + "/.pgpass");
            }
        } else {
            wbFile = new WbFile(string);
        }
        return wbFile;
    }

    public static boolean isPgUrl(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("jdbc:postgresql:") || string.startsWith("jdbc:pgsql:");
    }

    public static boolean isGreenplumUrl(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("jdbc:pivotal:greenplum");
    }

    private void parseUrl(String string) {
        if (PgPassReader.isPgUrl(string)) {
            this.parsePgUrl(string);
        } else if (PgPassReader.isGreenplumUrl(string)) {
            this.parseGreenplumUrl(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parsePgUrl(String string) {
        if (!PgPassReader.isPgUrl(string)) {
            return;
        }
        int n = string.indexOf(58, 5);
        if (!(string = string.substring(n + 1)).startsWith("//")) {
            this.host = "localhost";
            this.database = string;
            return;
        }
        string = string.substring(2);
        int n2 = 1;
        this.host = "";
        this.database = "";
        this.port = "";
        int n3 = 0;
        while (n3 < string.length()) {
            block13: {
                char c = string.charAt(n3);
                switch (c) {
                    case ':': {
                        if (n2 != 1) break;
                        n2 = 2;
                        break block13;
                    }
                    case '/': {
                        n2 = 3;
                        break block13;
                    }
                    case '&': 
                    case '?': {
                        n2 = 4;
                    }
                }
                switch (n2) {
                    case 1: {
                        this.host = this.host + c;
                        break;
                    }
                    case 2: {
                        this.port = this.port + c;
                        break;
                    }
                    case 3: {
                        this.database = this.database + c;
                        break;
                    }
                }
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseGreenplumUrl(String string) {
        int n = string.indexOf("greenplum") + "greenplum".length();
        if (!(string = string.substring(n + 1)).startsWith("//")) {
            this.host = "localhost";
            this.database = string;
            return;
        }
        string = string.substring(2);
        int n2 = 1;
        String string2 = "";
        this.host = "";
        this.database = "";
        this.port = "";
        int n3 = 0;
        while (n3 < string.length()) {
            block15: {
                char c = string.charAt(n3);
                switch (c) {
                    case ':': {
                        if (n2 != 1) break;
                        n2 = 2;
                        break block15;
                    }
                    case ';': {
                        n2 = 5;
                        string2 = "";
                        break block15;
                    }
                    case '=': {
                        if (n2 == 5 && string2.equals("DatabaseName")) {
                            n2 = 3;
                        }
                        break block15;
                    }
                    case '&': 
                    case '?': {
                        n2 = 4;
                    }
                }
                switch (n2) {
                    case 1: {
                        this.host = this.host + c;
                        break;
                    }
                    case 2: {
                        this.port = this.port + c;
                        break;
                    }
                    case 3: {
                        this.database = this.database + c;
                    }
                    case 5: {
                        string2 = string2 + c;
                        break;
                    }
                }
            }
            ++n3;
        }
    }
}

