/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PgSubscription
implements DbObject,
Serializable {
    public static final String TYPE_NAME = "SUBSCRIPTION";
    private String name;
    private String comment;
    private String connInfo;
    private boolean enabled;
    private boolean syncCommit;
    private String slotName;
    private List<String> publications = new ArrayList<String>();

    public PgSubscription(String string) {
        this.name = string;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.getSource();
    }

    public String getSource() {
        String string = "CREATE SUBSCRIPTION " + SqlUtil.quoteObjectname(this.name) + "\n  CONNECTION '" + this.connInfo + "'\n  PUBLICATION " + StringUtil.listToString(this.publications, ',', false);
        string = string + "\n  WITH (";
        string = StringUtil.isBlank(this.slotName) ? string + "slot_name = none" : string + "slot_name = '" + this.slotName + "'";
        if (!this.enabled) {
            string = string + ", enabled = false";
        }
        if (this.syncCommit) {
            string = string + ", synchronous_commit = on";
        }
        string = string + ");";
        return string;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return "DROP SUBSCRIPTION IF EXISTS " + SqlUtil.quoteObjectname(this.name);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setConnectionInfo(String string) {
        this.connInfo = string;
    }

    public void setSyncCommitEnabled(boolean bl) {
        this.syncCommit = bl;
    }

    public void setSlotName(String string) {
        this.slotName = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setPublications(List<String> list) {
        this.publications.clear();
        if (list != null) {
            this.publications.addAll(list);
        }
    }
}

