/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.lang.reflect.Method;
import java.sql.Connection;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class PgTypeInfo {
    private Object typeInfo;
    private Method getSqlType;
    private Method getScale;
    private Method getPrecision;
    private Method getDisplaySize;

    public PgTypeInfo(WbConnection wbConnection) {
        this.initMethods(wbConnection.getSqlConnection());
    }

    public int getSQLType(int n) {
        try {
            Object object = this.getSqlType.invoke(this.typeInfo, n);
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize method information", throwable);
        }
        return 1111;
    }

    public int getScale(int n, int n2) {
        try {
            Object object = this.getScale.invoke(this.typeInfo, n, n2);
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize method information", throwable);
        }
        return 1111;
    }

    public int getPrecision(int n, int n2) {
        try {
            Object object = this.getPrecision.invoke(this.typeInfo, n, n2);
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize method information", throwable);
        }
        return 1111;
    }

    public int getDisplaySize(int n, int n2) {
        try {
            Object object = this.getDisplaySize.invoke(this.typeInfo, n, n2);
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize method information", throwable);
        }
        return 1111;
    }

    private void initMethods(Connection connection) {
        try {
            Method method = connection.getClass().getMethod("getTypeInfo", null);
            this.typeInfo = method.invoke((Object)connection, (Object[])null);
            this.getSqlType = this.typeInfo.getClass().getMethod("getSQLType", Integer.TYPE);
            this.getScale = this.typeInfo.getClass().getMethod("getScale", Integer.TYPE, Integer.TYPE);
            this.getPrecision = this.typeInfo.getClass().getMethod("getPrecision", Integer.TYPE, Integer.TYPE);
            this.getDisplaySize = this.typeInfo.getClass().getMethod("getDisplaySize", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not initialize method information", throwable);
        }
    }
}

