/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.storage.ColumnData;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;
import workbench.util.SqlUtil;

public class Postgres95MergeGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("ansi");

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        String string = "INSERT INTO ";
        string = string + tableIdentifier.getTableExpression();
        string = string + "\n  (";
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + resultInfo.getColumnName(i);
        }
        string = string + ")\nVALUES\n";
        return string;
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.appendValues(stringBuilder, rowData, resultInfo, l);
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        String string = "\nON CONFLICT (";
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        int n = 0;
        for (ColumnIdentifier columnIdentifier : resultInfo.getColumnList()) {
            if (!columnIdentifier.isPkColumn()) continue;
            if (n > 0) {
                string = string + ", ";
            }
            string = string + SqlUtil.quoteObjectname(columnIdentifier.getColumnName());
            ++n;
        }
        string = string + ") DO UPDATE\n  SET ";
        n = 0;
        for (ColumnIdentifier columnIdentifier : resultInfo.getColumnList()) {
            if (columnIdentifier.isPkColumn()) continue;
            if (n > 0) {
                string = string + ",\n      ";
            }
            String string2 = SqlUtil.quoteObjectname(columnIdentifier.getColumnName());
            string = string + string2 + " = EXCLUDED." + string2;
            ++n;
        }
        return string;
    }

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount() * 20);
        stringBuilder.append(this.generateMergeStart(rowDataContainer));
        for (int i = 0; i < rowDataContainer.getRowCount(); ++i) {
            RowData rowData = rowDataContainer.getRow(i);
            this.appendValues(stringBuilder, rowData, rowDataContainer.getResultInfo(), i);
        }
        stringBuilder.append(this.generateMergeEnd(rowDataContainer));
        return stringBuilder.toString();
    }

    private void appendValues(StringBuilder stringBuilder, RowData rowData, ResultInfo resultInfo, long l) {
        if (l > 0L) {
            stringBuilder.append(",\n");
        }
        stringBuilder.append("  (");
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ColumnData columnData = new ColumnData(rowData.getValue(i), resultInfo.getColumn(i));
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
        }
        stringBuilder.append(')');
    }
}

