/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.postgres.PgCollation;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresCollationReader
implements ObjectListExtender {
    private String getSql(WbConnection wbConnection, String string, String string2) {
        String string3 = "null::text as provider";
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "10")) {
            string3 = "case c.collprovider when 'i' then 'icu' when 'c' then 'libc' end as provider";
        }
        StringBuilder stringBuilder = new StringBuilder("select s.nspname as schema_name, \n       c.collname, \n       c.collcollate, \n       c.collctype, \n       " + string3 + ", \n       obj_description(c.oid) as remarks \nfrom pg_catalog.pg_collation c\n  join pg_catalog.pg_namespace s on s.oid = c.collnamespace");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("\n WHERE ");
            SqlUtil.appendExpression(stringBuilder, "c.collname", string2, wbConnection);
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            if (!bl) {
                stringBuilder.append("\n WHERE ");
                bl = true;
            } else {
                stringBuilder.append("\n AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "s.nspname", string, wbConnection);
        }
        stringBuilder.append("\n ORDER BY s.nspname, c.collname ");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PgCollation> getCollations(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<PgCollation> arrayList = new ArrayList<PgCollation>();
        String string3 = this.getSql(wbConnection, string, string2);
        LogMgr.logMetadataSql(new CallerInfo(){}, "collations", string3, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("schema_name");
                String string5 = resultSet.getString("collname");
                String string6 = resultSet.getString("collcollate");
                String string7 = resultSet.getString("collctype");
                String string8 = resultSet.getString("remarks");
                String string9 = resultSet.getString("provider");
                PgCollation pgCollation = new PgCollation(string4, string5);
                pgCollation.setComment(string8);
                pgCollation.setProvider(string9);
                pgCollation.setLocale(string6, string7);
                arrayList.add(pgCollation);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "collations", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public PgCollation getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<PgCollation> list = this.getCollations(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("COLLATION", stringArray)) {
            return false;
        }
        List<PgCollation> list = this.getCollations(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (PgCollation pgCollation : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)pgCollation.getSchema());
            dataStore.setValue(n, 0, (Object)pgCollation.getObjectName());
            dataStore.setValue(n, 4, (Object)pgCollation.getComment());
            dataStore.setValue(n, 1, (Object)pgCollation.getObjectType());
            dataStore.getRow(n).setUserObject(pgCollation);
        }
        return true;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("COLLATION", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        PgCollation pgCollation = this.getObjectDefinition(wbConnection, dbObject);
        if (pgCollation == null) {
            return null;
        }
        String[] stringArray = new String[]{"SCHEMA", "COLLATION", "PROVIDER", "LC_COLLATE", "LC_CTYPE", "REMARKS"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12};
        int[] nArray2 = new int[]{20, 20, 5, 20, 20, 50};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)pgCollation.getSchema());
        dataStore.setValue(0, 1, (Object)pgCollation.getObjectName());
        dataStore.setValue(0, 2, (Object)pgCollation.getProvider());
        dataStore.setValue(0, 3, (Object)pgCollation.getCollate());
        dataStore.setValue(0, 4, (Object)pgCollation.getCType());
        dataStore.setValue(0, 5, (Object)pgCollation.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("COLLATION");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        PgCollation pgCollation = this.getObjectDefinition(wbConnection, dbObject);
        if (pgCollation == null) {
            return null;
        }
        try {
            String string = pgCollation.getSource(wbConnection).toString();
            return string;
        }
        catch (Exception exception) {
            return pgCollation.getSource();
        }
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

