/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.util.List;
import workbench.db.AbstractConstraintReader;
import workbench.db.ConstraintType;
import workbench.db.IndexDefinition;
import workbench.db.TableConstraint;
import workbench.util.CollectionUtil;

public class PostgresConstraintReader
extends AbstractConstraintReader {
    private final String TABLE_SQL = "select rel.conname,  \n       pg_catalog.pg_get_constraintdef(rel.oid) as src, \n       pg_catalog.obj_description(rel.oid) as remarks  \nfrom pg_catalog.pg_class t \n  join pg_catalog.pg_constraint rel on t.oid = rel.conrelid   \n  join pg_catalog.pg_namespace nsp on t.relnamespace = nsp.oid \nwhere rel.contype in ('c', 'x') \n and t.relname = ? \n and nsp.nspname = ? ";

    public PostgresConstraintReader(String string) {
        super(string);
    }

    @Override
    public String getColumnConstraintSql() {
        return null;
    }

    @Override
    public String getTableConstraintSql() {
        return "select rel.conname,  \n       pg_catalog.pg_get_constraintdef(rel.oid) as src, \n       pg_catalog.obj_description(rel.oid) as remarks  \nfrom pg_catalog.pg_class t \n  join pg_catalog.pg_constraint rel on t.oid = rel.conrelid   \n  join pg_catalog.pg_namespace nsp on t.relnamespace = nsp.oid \nwhere rel.contype in ('c', 'x') \n and t.relname = ? \n and nsp.nspname = ? ";
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 1;
    }

    @Override
    public int getIndexForSchemaParameter() {
        return 2;
    }

    @Override
    public void updateIndexList(List<TableConstraint> list, List<IndexDefinition> list2) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (CollectionUtil.isEmpty(list2)) {
            return;
        }
        for (TableConstraint tableConstraint : list) {
            IndexDefinition indexDefinition;
            if (tableConstraint.getConstraintType() != ConstraintType.Exclusion || (indexDefinition = IndexDefinition.findIndex(list2, tableConstraint.getConstraintName(), null)) == null) continue;
            indexDefinition.setAutoGenerated(true);
        }
    }
}

