/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.util.HashMap;
import java.util.Map;
import workbench.db.DataTypeResolver;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresDataTypeResolver
implements DataTypeResolver {
    private static final Map<String, String> TYPE_TO_DISPLAY = new HashMap<String, String>();
    private static final Map<String, String> DISPLAY_TO_TYPE = new HashMap<String, String>();
    private boolean fixTimestampTZ;

    public void setFixTimestampTZ(boolean bl) {
        this.fixTimestampTZ = bl;
    }

    @Override
    public String getSqlTypeDisplay(String string, int n, int n2, int n3) {
        if (n == 12 && "text".equals(string)) {
            return "text";
        }
        if (n == 12 && "character varying".equals(string)) {
            string = "varchar";
        }
        if (n == 5 && "int2".equals(string)) {
            return "smallint";
        }
        if (n == 4 && "int4".equals(string)) {
            return "integer";
        }
        if (n == -5 && "int8".equals(string)) {
            return "bigint";
        }
        if ((n == -7 || n == 16) && "bool".equals(string)) {
            return "boolean";
        }
        if (n == 1 && "bpchar".equals(string)) {
            return "char(" + n2 + ")";
        }
        if (n == 12 && n2 == Integer.MAX_VALUE) {
            return string;
        }
        if (n == 2 || n == 3) {
            if (n2 == 65535 || n2 == 131089) {
                n2 = 0;
            }
            if (n3 == 65531) {
                n3 = 0;
            }
        }
        if (n == 1111 && "varbit".equals(string)) {
            return "bit varying(" + n2 + ")";
        }
        if (n == -7 && "bit".equals(string)) {
            return "bit(" + n2 + ")";
        }
        if (n == 2003 && string.charAt(0) == '_') {
            return PostgresDataTypeResolver.mapInternaArrayToDisplay(string);
        }
        if ("varchar".equals(string) && n2 < 0) {
            return "varchar";
        }
        return SqlUtil.getSqlTypeDisplay(string, n, n2, n3);
    }

    @Override
    public String getColumnClassName(int n, String string) {
        if (this.fixTimestampTZ && n == 2014 && "timestamptz".equals(string)) {
            return "java.time.ZonedDateTime";
        }
        return null;
    }

    @Override
    public int fixColumnType(int n, String string) {
        if (n == -7 && "bool".equals(string)) {
            return 16;
        }
        if (this.fixTimestampTZ && n == 93 && ("timestamptz".equals(string) || "timestamp with time zone".equals(string))) {
            return 2014;
        }
        if (n == 92 && ("timetz".equals(string) || "time with time zone".equals(string))) {
            return 2013;
        }
        return n;
    }

    public static String mapArrayDisplayToInternal(String string) {
        String string2 = DISPLAY_TO_TYPE.get(string);
        if (string2 != null) {
            return string2;
        }
        return "_" + StringUtil.replace(string, "[]", "");
    }

    public static String mapInternaArrayToDisplay(String string) {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        String string2 = TYPE_TO_DISPLAY.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.charAt(0) == '_') {
            return string.substring(1) + "[]";
        }
        return string;
    }

    static {
        TYPE_TO_DISPLAY.put("_int2", "smallint[]");
        TYPE_TO_DISPLAY.put("_int4", "integer[]");
        TYPE_TO_DISPLAY.put("_int8", "bigint[]");
        TYPE_TO_DISPLAY.put("_varchar", "varchar[]");
        TYPE_TO_DISPLAY.put("_float4", "real[]");
        TYPE_TO_DISPLAY.put("_float8", "double precision[]");
        TYPE_TO_DISPLAY.put("_bpchar", "char[]");
        TYPE_TO_DISPLAY.put("_text", "text[]");
        TYPE_TO_DISPLAY.put("_bool", "boolean[]");
        TYPE_TO_DISPLAY.put("_numeric", "numeric[]");
        TYPE_TO_DISPLAY.put("_date", "date[]");
        TYPE_TO_DISPLAY.put("_time", "time[]");
        TYPE_TO_DISPLAY.put("_timestamp", "timestamp[]");
        TYPE_TO_DISPLAY.put("_timestamptz", "timestamptz[]");
        TYPE_TO_DISPLAY.put("_timetz", "timetz[]");
        for (Map.Entry<String, String> entry : TYPE_TO_DISPLAY.entrySet()) {
            DISPLAY_TO_TYPE.put(entry.getValue(), entry.getKey());
        }
        DISPLAY_TO_TYPE.put("timestamp without time zone[]", "_timestamp");
        DISPLAY_TO_TYPE.put("timestamp with time zone[]", "_timestamptz");
        DISPLAY_TO_TYPE.put("time without time zone[]", "_time");
        DISPLAY_TO_TYPE.put("time with time zone[]", "_timetz");
    }
}

