/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.InheritanceEntry;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class PostgresInheritanceReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InheritanceEntry> getChildren(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        ArrayList<InheritanceEntry> arrayList = new ArrayList<InheritanceEntry>();
        if (tableIdentifier == null) {
            return arrayList;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select bt.relname as table_name, bns.nspname as table_schema, 0 as level \nfrom pg_catalog.pg_class ct \n    join pg_catalog.pg_namespace cns on ct.relnamespace = cns.oid and cns.nspname = ? \n    join pg_catalog.pg_inherits i on i.inhparent = ct.oid and ct.relname = ? \n    join pg_catalog.pg_class bt on i.inhrelid = bt.oid \n    join pg_catalog.pg_namespace bns on bt.relnamespace = bns.oid ";
        if (wbConnection.getDbSettings().returnAccessibleTablesOnly()) {
            string = string + "\nwhere has_table_privilege(ct.oid, 'select') \n";
        }
        String string2 = "with recursive inh as ( \n\n  select i.inhrelid, 1 as level, array[inhrelid] as path \n  from pg_catalog.pg_inherits i  \n    join pg_catalog.pg_class cl on i.inhparent = cl.oid \n    join pg_catalog.pg_namespace nsp on cl.relnamespace = nsp.oid \n  where nsp.nspname = ? \n    and cl.relname = ? \n  union all \n\n  select i.inhrelid, inh.level + 1, inh.path||i.inhrelid \n  from inh \n    join pg_catalog.pg_inherits i on (inh.inhrelid = i.inhparent) \n) \nselect ct.relname as table_name, nsp.nspname as table_schema, inh.level \nfrom inh \n  join pg_catalog.pg_class ct on (inh.inhrelid = ct.oid) \n  join pg_catalog.pg_namespace nsp on (ct.relnamespace = nsp.oid) \n";
        if (wbConnection.getDbSettings().returnAccessibleTablesOnly()) {
            string2 = string2 + "where has_table_privilege(ct.oid, 'select') \n";
        }
        string2 = string2 + "order by path";
        boolean bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "8.4");
        String string3 = bl ? string2 : string;
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            LogMgr.logMetadataSql(new CallerInfo(){}, "child tables", string3, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                TableIdentifier tableIdentifier2 = new TableIdentifier(string5, string4);
                arrayList.add(new InheritanceEntry(tableIdentifier2, n));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            ArrayList<InheritanceEntry> arrayList2;
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "child tables", string3, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                arrayList2 = new ArrayList<InheritanceEntry>();
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return arrayList2;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableIdentifier> getParents(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select bt.relname as table_name, bns.nspname as table_schema \nfrom pg_catalog.pg_class ct \n  join pg_catalog.pg_namespace cns on ct.relnamespace = cns.oid and cns.nspname = ? \n  join pg_catalog.pg_inherits i on i.inhrelid = ct.oid and ct.relname = ? \n  join pg_catalog.pg_class bt on i.inhparent = bt.oid \n  join pg_catalog.pg_namespace bns on bt.relnamespace = bns.oid \nwhere bt.relkind <> 'p'";
        if (wbConnection.getDbSettings().returnAccessibleTablesOnly()) {
            string = string + "\n  and pg_catalog.has_table_privilege(ct.oid, 'select') \n";
        }
        Savepoint savepoint = null;
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            LogMgr.logMetadataSql(new CallerInfo(){}, "table inheritance", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                arrayList.add(new TableIdentifier(string3, string2));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            List<TableIdentifier> list;
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "table inheritance" + string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
                list = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return list;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }
}

