/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresPartition;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class PostgresPartitionReader {
    public static final String OPTION_KEY_STRATEGY = "partition_strategy";
    public static final String OPTION_KEY_EXPRESSION = "partition_expression";
    private final TableIdentifier table;
    private final WbConnection dbConnection;
    private String strategy;
    private String partitionExpression;
    private String partitionDefinition;
    private List<PostgresPartition> partitions;

    public PostgresPartitionReader(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        Objects.requireNonNull(tableIdentifier, "A table must be specified");
        this.table = tableIdentifier;
        this.dbConnection = wbConnection;
    }

    public List<PostgresPartition> getTablePartitions() {
        if (this.partitions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.partitions);
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public String getPartitionDefinition() {
        return this.partitionDefinition;
    }

    public String getCreatePartitions() {
        if (this.partitions == null) {
            return null;
        }
        String string = this.table.getTableExpression(this.dbConnection);
        StringBuilder stringBuilder = new StringBuilder(this.partitions.size() * 100);
        for (PostgresPartition postgresPartition : this.partitions) {
            stringBuilder.append(PostgresPartitionReader.generatePartitionDDL(postgresPartition, string, this.dbConnection));
            stringBuilder.append(";\n\n");
        }
        return stringBuilder.toString();
    }

    public static String generatePartitionDDL(PostgresPartition postgresPartition, String string, WbConnection wbConnection) {
        if (postgresPartition == null) {
            return null;
        }
        TableIdentifier tableIdentifier = postgresPartition.getParentTable();
        String string2 = tableIdentifier == null ? string : tableIdentifier.getTableExpression(wbConnection);
        TableIdentifier tableIdentifier2 = new TableIdentifier(postgresPartition.getSchema(), postgresPartition.getObjectName());
        String string3 = "CREATE TABLE " + tableIdentifier2.getTableExpression(wbConnection) + "\n  PARTITION OF " + string2 + "\n  " + postgresPartition.getDefinition();
        if (postgresPartition.getSubPartitionDefinition() != null) {
            string3 = string3 + "\n  PARTITION BY " + postgresPartition.getSubPartitionStrategy() + " " + postgresPartition.getSubPartitionDefinition();
        }
        return string3;
    }

    public List<PostgresPartition> loadTablePartitions() {
        if (this.partitions == null) {
            this.readPartitions();
        }
        return this.getTablePartitions();
    }

    public void readPartitionInformation() {
        this.readPartitioningDefinition();
        this.readPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartitions() {
        String string = "with recursive inh as ( \n\n  select i.inhrelid, null::text as parent  \n  from pg_catalog.pg_inherits i  \n    join pg_catalog.pg_class cl on i.inhparent = cl.oid \n  where cl.relnamespace = cast(? as regnamespace) \n    and cl.relname = ? \n  union all \n\n  select i.inhrelid, (i.inhparent::regclass)::text \n  from inh \n    join pg_catalog.pg_inherits i on (inh.inhrelid = i.inhparent) \n) \nselect c.relname as partition_name, \n       c.relnamespace::regnamespace::text as partition_schema,  \n       pg_catalog.obj_description(c.oid, 'pg_class') as remarks, \n       pg_catalog.pg_get_expr(c.relpartbound, c.oid, true) as partition_expression,        (select string_agg(case when x.attnum = 0 then '<expr>' else att.attname end, ', ' order by x.idx) \n        from unnest(p.partattrs) with ordinality as x(attnum, idx)\n          left join pg_catalog.pg_attribute att \n                 on att.attnum = x.attnum \n                and att.attrelid = p.partrelid) as sub_part_cols,\n       pg_catalog.pg_get_expr(p.partexprs, p.partrelid, true) as sub_part_expression,        parent, \n       case p.partstrat \n         when 'l' then 'LIST' \n         when 'r' then 'RANGE' \n         when 'h' then 'HASH' \n       end as sub_partition_strategy \nfrom inh \n  join pg_catalog.pg_class c on inh.inhrelid = c.oid \n  left join pg_catalog.pg_partitioned_table p on p.partrelid = c.oid \norder by c.relnamespace::regnamespace, c.relname";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        this.partitions = new ArrayList<PostgresPartition>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "partitions", string, this.table.getSchema(), this.table.getTableName());
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, this.table.getRawSchema());
            preparedStatement.setString(2, this.table.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                String string2 = resultSet.getString("partition_name");
                String string3 = resultSet.getString("partition_schema");
                String string4 = resultSet.getString(OPTION_KEY_EXPRESSION);
                String string5 = resultSet.getString("sub_part_expression");
                String string6 = resultSet.getString("sub_part_cols");
                String string7 = resultSet.getString("parent");
                String string8 = resultSet.getString("remarks");
                PostgresPartition postgresPartition = new PostgresPartition(this.table, string3, string2);
                postgresPartition.setDefinition(string4);
                postgresPartition.setComment(string8);
                postgresPartition.setPartitionStrategy(this.strategy);
                String string9 = resultSet.getString("sub_partition_strategy");
                if (string9 != null) {
                    object = PostgresPartitionReader.mergeSubPartitionExpression(string6, string5);
                    postgresPartition.setSubPartitionDefinition("(" + (String)object + ")");
                    postgresPartition.setSubPartitionStrategy(string9);
                }
                if (string7 != null) {
                    object = new TableIdentifier(string7);
                    postgresPartition.setParentTable((TableIdentifier)object);
                }
                this.partitions.add(postgresPartition);
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "partitions", string, this.table.getSchema(), this.table.getTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    private static String mergeSubPartitionExpression(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        List<String> list = StringUtil.stringToList(string2, ",", true, true, true, true);
        if (CollectionUtil.isEmpty(list)) {
            return string;
        }
        for (int i = 0; i < list.size(); ++i) {
            string = string.replaceFirst("<expr>", Matcher.quoteReplacement(list.get(i)));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartitioningDefinition() {
        if (this.table == null) {
            return;
        }
        String string = "select p.partstrat, \n       pg_catalog.pg_get_expr(p.partexprs, t.oid, true) as partition_expression, \n       (select string_agg(case when x.attnum = 0 then '<expr>' else att.attname end, ', ' order by x.idx) \n        from unnest(p.partattrs) with ordinality as x(attnum, idx)\n          left join pg_catalog.pg_attribute att \n                 on att.attnum = x.attnum \n                and att.attrelid = p.partrelid) as partition_columns\nfrom pg_catalog.pg_partitioned_table p\n  join pg_catalog.pg_class t on t.oid = p.partrelid\nwhere t.relnamespace = cast(? as regnamespace) \n  and t.relname = ? ";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "partitioning definition", string, this.table.getSchema(), this.table.getTableName());
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, this.table.getRawSchema());
            preparedStatement.setString(2, this.table.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2;
                String string3 = resultSet.getString(OPTION_KEY_EXPRESSION);
                String string4 = resultSet.getString("partition_columns");
                this.partitionExpression = PostgresPartitionReader.mergeSubPartitionExpression(string4, string3);
                switch (string2 = resultSet.getString("partstrat")) {
                    case "r": {
                        this.strategy = "RANGE";
                        break;
                    }
                    case "l": {
                        this.strategy = "LIST";
                        break;
                    }
                    case "h": {
                        this.strategy = "HASH";
                        break;
                    }
                }
                this.partitionDefinition = "PARTITION BY " + this.strategy + " (" + this.partitionExpression + ")";
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "partitioning definition", string, this.table.getSchema(), this.table.getTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PostgresPartition getPartitionDefinition(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        String string = "select base.relnamespace::regnamespace::text as base_table_schema, \n       base.relname as base_table, \n       pg_catalog.pg_get_expr(c.relpartbound, c.oid, true) as partition_expression, \n       pg_catalog.pg_get_expr(p.partexprs, p.partrelid, true) as sub_partition_expression, \n       (select string_agg(case when x.attnum = 0 then '<expr>' else att.attname end, ', ' order by x.idx) \n        from unnest(p.partattrs) with ordinality as x(attnum, idx)\n          left join pg_catalog.pg_attribute att \n                 on att.attnum = x.attnum \n                and att.attrelid = p.partrelid) as sub_part_cols,\n       case p.partstrat \n         when 'l' then 'LIST' \n         when 'r' then 'RANGE' \n         when 'h' then 'HASH' \n       end as sub_partition_strategy \nfrom pg_catalog.pg_inherits i \n  join pg_catalog.pg_class c on i.inhrelid = c.oid \n  join pg_partitioned_table p on p.partrelid = i.inhrelid\n  join pg_class base on base.oid = i.inhparent \nwhere c.relnamespace = cast(? as regnamespace) \n  and c.relname = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "partition information", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
        PostgresPartition postgresPartition = null;
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString("base_table");
                String string3 = resultSet.getString("base_table_schema");
                TableIdentifier tableIdentifier2 = new TableIdentifier(string3, string2);
                postgresPartition = new PostgresPartition(tableIdentifier, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
                postgresPartition.setParentTable(tableIdentifier2);
                postgresPartition.setDefinition(resultSet.getString(OPTION_KEY_EXPRESSION));
                postgresPartition.setSubPartitionStrategy(resultSet.getString("sub_partition_strategy"));
                String string4 = resultSet.getString("sub_partition_expression");
                String string5 = resultSet.getString("sub_part_cols");
                postgresPartition.setSubPartitionDefinition(PostgresPartitionReader.mergeSubPartitionExpression(string5, string4));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "partition information", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return postgresPartition;
    }
}

