/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresPolicyReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTablePolicies(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        boolean bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
        String string = bl ? "p.polpermissive" : "null as polpermissive";
        String string2 = "select polname, \n       pg_catalog.pg_get_expr(p.polqual, p.polrelid, true) as expression, \n       case p.polcmd \n         when 'r' then 'SELECT' \n         when 'a' then 'INSERT' \n         when 'w' then 'UPDATE' \n         when 'd' then 'DELETE' \n         else 'ALL' \n       end as command, \n       " + string + ", \n       (select string_agg(quote_ident(rolname), ',') from pg_catalog.pg_roles r where r.oid = any(p.polroles)) as roles, \n       pg_catalog.pg_get_expr(p.polwithcheck, p.polrelid, true) as with_check, \n       t.relrowsecurity, \n       t.relforcerowsecurity \nfrom pg_catalog.pg_policy p \n  join pg_catalog.pg_class t on t.oid = p.polrelid \nwhere p.polrelid = cast(? as regclass)\n order by p.polname";
        String string3 = tableIdentifier.getFullyQualifiedName(wbConnection);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logMetadataSql(callerInfo, "table policies", string2, string3);
        StringBuilder stringBuilder = new StringBuilder(100);
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string2);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString("polname");
                String string5 = resultSet.getString("expression");
                String string6 = resultSet.getString("command");
                boolean bl4 = resultSet.getBoolean("polpermissive");
                bl2 = resultSet.getBoolean("relrowsecurity");
                bl3 = resultSet.getBoolean("relforcerowsecurity");
                String string7 = resultSet.getString("with_check");
                String string8 = resultSet.getString("roles");
                String string9 = "CREATE POLICY " + SqlUtil.quoteObjectname(string4) + " ON " + string3 + "\n";
                if (bl) {
                    string9 = string9 + "  AS " + (bl4 ? "PERMISSIVE" : "RESTRICTIVE") + "\n";
                }
                string9 = string9 + "  FOR " + string6;
                if (StringUtil.isNonBlank(string8)) {
                    string9 = string9 + "\n  TO " + string8;
                }
                if (StringUtil.isNonBlank(string5)) {
                    string9 = string9 + "\n  USING (" + string5 + ")";
                }
                if (StringUtil.isNonBlank(string7)) {
                    string9 = string9 + "\n  WITH CHECK (" + string7 + ")";
                }
                string9 = string9 + ";\n";
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string9);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(callerInfo, exception, "table policies", string2, string3);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.close(resultSet, preparedStatement);
        }
        JdbcUtils.close(resultSet, preparedStatement);
        if (stringBuilder.length() > 0 && !bl2) {
            stringBuilder.append("\nALTER TABLE " + string3 + " DISABLE ROW LEVEL SECURITY;");
        }
        if (bl2) {
            stringBuilder.append("\nALTER TABLE " + string3 + " ENABLE ROW LEVEL SECURITY;");
        }
        if (bl3) {
            stringBuilder.append("\nALTER TABLE " + string3 + " FORCE ROW LEVEL SECURITY;\n");
        }
        return stringBuilder.toString();
    }
}

