/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.postgres.PGProcName;
import workbench.db.postgres.PGType;
import workbench.db.postgres.PGTypeLookup;
import workbench.db.postgres.PostgresUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresProcedureReader
extends JdbcProcedureReader {
    private Map<String, Integer> pgType2Java;
    private PGTypeLookup pgTypes;
    private boolean useJDBC = false;

    public PostgresProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
        try {
            this.useSavepoint = wbConnection.supportsSavepoints();
        }
        catch (Throwable throwable) {
            this.useSavepoint = false;
        }
        this.useJDBC = PostgresUtil.isRedshift(wbConnection);
    }

    @Override
    public void clearCache() {
        if (this.pgTypes != null) {
            this.pgTypes.clear();
            this.pgTypes = null;
        }
    }

    private Map<String, Integer> getJavaTypeMapping() {
        if (this.pgType2Java == null) {
            this.pgType2Java = new HashMap<String, Integer>();
            this.pgType2Java.put("int2", 5);
            this.pgType2Java.put("int4", 4);
            this.pgType2Java.put("integer", 4);
            this.pgType2Java.put("oid", -5);
            this.pgType2Java.put("int8", -5);
            this.pgType2Java.put("money", 8);
            this.pgType2Java.put("numeric", 2);
            this.pgType2Java.put("float4", 7);
            this.pgType2Java.put("float8", 8);
            this.pgType2Java.put("char", 1);
            this.pgType2Java.put("bpchar", 1);
            this.pgType2Java.put("varchar", 12);
            this.pgType2Java.put("text", 12);
            this.pgType2Java.put("name", 12);
            this.pgType2Java.put("bytea", -2);
            this.pgType2Java.put("bool", -7);
            this.pgType2Java.put("bit", -7);
            this.pgType2Java.put("date", 91);
            this.pgType2Java.put("time", 92);
            this.pgType2Java.put("timetz", 92);
            this.pgType2Java.put("timestamp", 93);
            this.pgType2Java.put("timestamptz", 93);
        }
        return Collections.unmodifiableMap(this.pgType2Java);
    }

    private Integer getJavaType(String string) {
        Integer n = this.getJavaTypeMapping().get(string);
        if (n == null) {
            return 1111;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGTypeLookup getTypeLookup() {
        block7: {
            if (this.pgTypes != null) break block7;
            HashMap<Long, PGType> hashMap = new HashMap(300);
            Statement statement = null;
            ResultSet resultSet = null;
            Savepoint savepoint = null;
            String string = JdbcUtils.hasMinimumServerVersion(this.connection, "10") ? "select t.oid, pg_catalog.format_type(t.oid, null), t.typtype, t.typnamespace::regnamespace::text as schema_name \nfrom pg_catalog.pg_type t" : "select t.oid, pg_catalog.format_type(t.oid, null), t.typtype, ns.nspname as schema_name \nfrom pg_catalog.pg_type t \n  join pg_catalog.pg_namespace ns on ns.oid = t.typnamespace";
            LogMgr.logMetadataSql(new CallerInfo(){}, "type lookup", string, new Object[0]);
            try {
                if (this.useSavepoint) {
                    savepoint = this.connection.setSavepoint();
                }
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    if (string2.equals("character varying")) {
                        string2 = "varchar";
                    }
                    string2 = this.getFQName(string3, string4, StringUtil.trimQuotes(string2));
                    PGType pGType = new PGType(string2, l);
                    hashMap.put(l, pGType);
                }
                this.connection.releaseSavepoint(savepoint);
            }
            catch (SQLException sQLException) {
                try {
                    this.connection.rollback(savepoint);
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "type lookup", string, new Object[0]);
                    hashMap = Collections.emptyMap();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
            JdbcUtils.closeAll(resultSet, statement);
            this.pgTypes = new PGTypeLookup(hashMap);
        }
        return this.pgTypes;
    }

    private String getFQName(String string, String string2, String string3) {
        if ("c".equals(string)) {
            if (string3.indexOf(46) > -1) {
                return string3;
            }
            if (!string3.startsWith(string2)) {
                return string2 + "." + string3;
            }
        }
        return string3;
    }

    private String getTypeNameFromOid(long l) {
        PGType pGType = this.getTypeLookup().getTypeFromOID(l);
        return pGType.getTypeName();
    }

    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        Object object;
        Object object2;
        if (this.useJDBC) {
            return super.getProcedures(string, string3, string3);
        }
        if ("*".equals(string2) || "%".equals(string2)) {
            string2 = null;
        }
        String string4 = null;
        if ("*".equals(string3) || "%".equals(string3)) {
            string4 = null;
        } else if (StringUtil.isNonBlank(string3)) {
            object2 = new PGProcName(string3, this.getTypeLookup());
            string4 = ((PGProcName)object2).getName();
        }
        object2 = null;
        Savepoint savepoint = null;
        ResultSet resultSet = null;
        boolean bl = this.connection.getDbSettings().showProcedureParameters();
        String string5 = JdbcUtils.hasMinimumServerVersion(this.connection, "8.1") ? "coalesce(array_to_string(proallargtypes, ';'), array_to_string(proargtypes, ';')) as arg_types, \n" : "array_to_string(proargtypes, ';') as arg_types, \n";
        String string6 = "SELECT n.nspname AS proc_schema, \n       p.proname AS proc_name, \n       d.description AS remarks, \n       " + string5 + "       array_to_string(p.proargnames, ';') as arg_names, \n       array_to_string(p.proargmodes, ';') as arg_modes, \n" + this.getProctypeColumnExpression() + "       p.oid::text as procid \n FROM pg_catalog.pg_proc p \n    JOIN pg_catalog.pg_namespace n on p.pronamespace = n.oid \n   LEFT JOIN pg_catalog.pg_description d ON p.oid = d.objoid \n   LEFT JOIN pg_catalog.pg_class c ON d.classoid=c.oid AND c.relname='pg_proc' \n   LEFT JOIN pg_catalog.pg_namespace pn ON c.relnamespace=pn.oid AND pn.nspname='pg_catalog'";
        boolean bl2 = true;
        if (StringUtil.isNonBlank(string2)) {
            string6 = string6 + "\n WHERE n.nspname LIKE '" + string2 + "' ";
            bl2 = false;
        }
        if (StringUtil.isNonBlank(string4)) {
            string6 = string6 + (bl2 ? "\n WHERE " : "\n  AND ");
            string6 = string6 + "p.proname LIKE '" + string4 + "' ";
            bl2 = false;
        }
        if (this.connection.getDbSettings().returnAccessibleProceduresOnly()) {
            string6 = string6 + (bl2 ? "\n WHERE " : "\n  AND ");
            string6 = string6 + "pg_catalog.has_function_privilege(p.oid,'execute')";
            bl2 = false;
        }
        string6 = string6 + "\nORDER BY proc_schema, proc_name ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "Retrieving procedures using:", string6, new Object[0]);
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            object2 = this.connection.createStatementForQuery();
            resultSet = object2.executeQuery(string6);
            DataStore dataStore = this.buildProcedureListDataStore(this.connection.getMetadata(), false);
            while (resultSet.next()) {
                object = resultSet.getString("proc_schema");
                String string7 = resultSet.getString("proc_name");
                String string8 = resultSet.getString("remarks");
                String string9 = resultSet.getString("arg_types");
                String string10 = resultSet.getString("arg_names");
                String string11 = resultSet.getString("arg_modes");
                String string12 = resultSet.getString("proc_type");
                String string13 = resultSet.getString("procid");
                int n = dataStore.addRow();
                int n2 = 2;
                if ("procedure".equals(string12)) {
                    n2 = 1;
                }
                ProcedureDefinition procedureDefinition = this.createDefinition((String)object, string7, string10, string9, string11, string13);
                procedureDefinition.setDbmsProcType(string12);
                procedureDefinition.setComment(string8);
                procedureDefinition.setInternalIdentifier(string13);
                dataStore.setValue(n, 2, null);
                dataStore.setValue(n, 3, object);
                dataStore.setValue(n, 0, (Object)(bl ? procedureDefinition.getDisplayName() : string7));
                dataStore.setValue(n, 1, (Object)n2);
                dataStore.setValue(n, 4, (Object)string8);
                dataStore.getRow(n).setUserObject(procedureDefinition);
            }
            this.connection.releaseSavepoint(savepoint);
            dataStore.resetStatus();
            object = dataStore;
        }
        catch (SQLException sQLException) {
            try {
                this.connection.rollback(savepoint);
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve procedures using:\n" + string6, sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, (Statement)object2);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, (Statement)object2);
        return object;
    }

    private String getProctypeColumnExpression() {
        if (JdbcUtils.hasMinimumServerVersion(this.connection, "11")) {
            return "   case p.prokind when 'p' then 'procedure' when 'a' then 'aggregate' else 'function' end as proc_type, \n";
        }
        return "       case when p.proisagg then 'aggregate' else 'function' end as proc_type, \n";
    }

    public ProcedureDefinition createDefinition(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string5 == null) {
            string5 = string4.replaceAll("[0-9]+", "i");
        }
        PGProcName pGProcName = new PGProcName(string2, string4, string5, this.getTypeLookup());
        ProcedureDefinition procedureDefinition = new ProcedureDefinition(null, string, string2, 2);
        List<String> list = StringUtil.stringToList(string3, ";", true, true);
        List<String> list2 = StringUtil.stringToList(string4, ";", true, true);
        List<String> list3 = StringUtil.stringToList(string5, ";", true, true);
        List<ColumnIdentifier> list4 = this.convertToColumns(list, list2, list3);
        procedureDefinition.setParameters(list4);
        procedureDefinition.setDisplayName(pGProcName.getFormattedName());
        procedureDefinition.setInternalIdentifier(string6);
        return procedureDefinition;
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        if (!this.useJDBC && Settings.getInstance().getBoolProperty("workbench.db.postgresql.fixproctypes", true) && JdbcUtils.hasMinimumServerVersion(this.connection, "8.4")) {
            PGProcName pGProcName = new PGProcName(procedureDefinition, this.getTypeLookup());
            return this.getColumns(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), pGProcName);
        }
        return super.getProcedureColumns(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), procedureDefinition.getProcedureName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProcedureSource(ProcedureDefinition procedureDefinition, String string, String string2) throws NoConfigException {
        String string3;
        boolean bl = Settings.getInstance().getBoolProperty("workbench.db.postgresql.procsource.useinternal", false);
        if (bl && JdbcUtils.hasMinimumServerVersion(this.connection, "8.4") && !"aggregate".equals(procedureDefinition.getDbmsProcType())) {
            this.readFunctionDef(procedureDefinition);
            return;
        }
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(this.connection, "9.6");
        boolean bl3 = JdbcUtils.hasMinimumServerVersion(this.connection, "9.2");
        boolean bl4 = JdbcUtils.hasMinimumServerVersion(this.connection, "8.4");
        boolean bl5 = bl3;
        PGProcName pGProcName = new PGProcName(procedureDefinition, this.getTypeLookup());
        String string4 = "SELECT p.prosrc, \n       l.lanname as lang_name, \n       n.nspname as schema_name, \n";
        string4 = JdbcUtils.hasMinimumServerVersion(this.connection, "8.4") ? string4 + "       pg_get_function_result(p.oid) as formatted_return_type, \n       pg_get_function_arguments(p.oid) as formatted_parameters, \n " : string4 + "       null::text as formatted_return_type, \n       null::text as formatted_parameters, \n";
        string4 = bl5 ? string4 + "       ext.extname, \n" : string4 + "       null::text as extname, \n";
        string4 = string4 + "       p.prorettype as return_type_oid, \n       coalesce(array_to_string(p.proallargtypes, ';'), array_to_string(p.proargtypes, ';')) as argtypes, \n       array_to_string(p.proargnames, ';') as argnames, \n       array_to_string(p.proargmodes, ';') as argmodes, \n       p.prosecdef, \n       p.proretset, \n       p.provolatile, \n       p.proisstrict, \n       " + (bl3 ? "p.proleakproof" : "false as proleakproof") + ", \n       " + (bl2 ? "p.proparallel" : "null as proparallel") + ", \n       " + (bl4 ? "array_to_string(p.proconfig, ',') as proconfig" : "null::text as proconfig") + ", \n" + this.getProctypeColumnExpression() + "       obj_description(p.oid, 'pg_proc') as remarks ";
        boolean bl6 = JdbcUtils.hasMinimumServerVersion(this.connection, "8.3");
        if (bl6) {
            string4 = string4 + ",\n       p.procost ,\n       p.prorows ";
        }
        string4 = string4 + "\nFROM pg_proc p \n   JOIN pg_language l ON p.prolang = l.oid \n   JOIN pg_namespace n ON p.pronamespace = n.oid \n";
        if (bl5) {
            string4 = string4 + "  LEFT JOIN pg_depend d ON d.objid = p.oid AND d.deptype = 'e' \n  LEFT JOIN pg_extension ext on ext.oid = d.refobjid \n";
        }
        string4 = string4 + "WHERE p.proname = '" + pGProcName.getName() + "' \n";
        if (StringUtil.isNonBlank(procedureDefinition.getSchema())) {
            string4 = string4 + "  AND n.nspname = '" + procedureDefinition.getSchema() + "' \n";
        }
        if (StringUtil.isNonBlank(string3 = pGProcName.getInputOIDs())) {
            string4 = string4 + " AND p.proargtypes = cast('" + string3 + "' as oidvector) \n ";
        } else if (procedureDefinition.getDisplayName().contains("(")) {
            string4 = string4 + " AND (p.proargtypes IS NULL OR array_length(p.proargtypes,1) = 0)";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedure source", string4, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder(500);
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        Statement statement = null;
        String string5 = procedureDefinition.getDbmsProcType();
        boolean bl7 = false;
        boolean bl8 = false;
        String string6 = null;
        String string7 = null;
        try {
            boolean bl9;
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            if (bl9 = (resultSet = (statement = this.connection.createStatementForQuery()).executeQuery(string4)).next()) {
                string5 = resultSet.getString("proc_type");
                string6 = resultSet.getString("remarks");
                string7 = resultSet.getString("schema_name");
            }
            bl7 = "aggregate".equals(string5);
            bl8 = "function".equals(string5);
            if (!bl7 && bl9) {
                CharSequence charSequence;
                stringBuilder.append("CREATE OR REPLACE " + string5.toUpperCase() + " ");
                stringBuilder.append(string2 == null ? string7 : string2);
                stringBuilder.append('.');
                stringBuilder.append(pGProcName.getName());
                String string8 = resultSet.getString(1);
                if (resultSet.wasNull() || string8 == null) {
                    string8 = "";
                }
                String string9 = resultSet.getString("lang_name");
                long l = resultSet.getLong("return_type_oid");
                String string10 = resultSet.getString("formatted_return_type");
                String string11 = resultSet.getString("argtypes");
                String string12 = resultSet.getString("argnames");
                String string13 = resultSet.getString("argmodes");
                String string14 = resultSet.getString("proconfig");
                String string15 = resultSet.getString("proparallel");
                boolean bl10 = resultSet.getBoolean("proretset");
                boolean bl11 = resultSet.getBoolean("proleakproof");
                boolean bl12 = resultSet.getBoolean("prosecdef");
                boolean bl13 = resultSet.getBoolean("proisstrict");
                String string16 = resultSet.getString("provolatile");
                String string17 = resultSet.getString("extname");
                Double d = null;
                Double d2 = null;
                if (bl6) {
                    d = resultSet.getDouble("procost");
                    d2 = resultSet.getDouble("prorows");
                }
                if ((charSequence = resultSet.getString("formatted_parameters")) == null) {
                    charSequence = this.buildParameterList(string12, string11, string13);
                }
                stringBuilder.append('(');
                stringBuilder.append(charSequence);
                stringBuilder.append(")");
                if (string5.equalsIgnoreCase("function")) {
                    stringBuilder.append("\n  RETURNS ");
                    if (string10 == null) {
                        if (bl10) {
                            stringBuilder.append("SETOF ");
                        }
                        stringBuilder.append(this.getTypeNameFromOid(l));
                    } else {
                        stringBuilder.append(string10);
                    }
                }
                stringBuilder.append("\n  LANGUAGE ");
                stringBuilder.append(string9);
                stringBuilder.append("\nAS\n$body$\n");
                string8 = string8.trim();
                stringBuilder.append(StringUtil.makePlainLinefeed(string8));
                if (!string8.endsWith(";")) {
                    stringBuilder.append(';');
                }
                stringBuilder.append("\n$body$\n");
                if (StringUtil.isNonBlank(string14)) {
                    stringBuilder.append("  SET ");
                    stringBuilder.append(string14);
                    stringBuilder.append('\n');
                }
                if (bl8) {
                    switch (string16) {
                        case "i": {
                            stringBuilder.append("  IMMUTABLE");
                            break;
                        }
                        case "s": {
                            stringBuilder.append("  STABLE");
                            break;
                        }
                        default: {
                            stringBuilder.append("  VOLATILE");
                        }
                    }
                    if (bl13) {
                        stringBuilder.append("\n  STRICT");
                    }
                    if (bl11) {
                        stringBuilder.append("\n  LEAKPROOF");
                    }
                    if (d != null) {
                        stringBuilder.append("\n  COST ");
                        stringBuilder.append(d.longValue());
                    }
                    if (d2 != null && bl10) {
                        stringBuilder.append("\n  ROWS ");
                        stringBuilder.append(d2.longValue());
                    }
                }
                if ((bl8 || bl7) && this.nonDefaultParallel(string15)) {
                    stringBuilder.append("\n  PARALLEL " + this.codeToParallelType(string15));
                }
                if (bl12) {
                    stringBuilder.append("\n SECURITY DEFINER");
                }
                stringBuilder.append(";\n");
                if (StringUtil.isNonBlank(string6)) {
                    stringBuilder.append("\nCOMMENT ON FUNCTION ");
                    stringBuilder.append(pGProcName.getSignature());
                    stringBuilder.append(" IS '");
                    stringBuilder.append(SqlUtil.escapeQuotes(procedureDefinition.getComment()));
                    stringBuilder.append("';\n\n");
                }
                if (StringUtil.isNonBlank(string17)) {
                    stringBuilder.append("\n-- Created through extension: " + string17 + "\n");
                }
            }
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                stringBuilder = new StringBuilder(ExceptionUtil.getDisplay(sQLException));
                this.connection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "procedure source", string4, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (bl7) {
            stringBuilder.append((CharSequence)this.getAggregateSource(pGProcName, procedureDefinition.getSchema()));
            if (StringUtil.isNonBlank(string6)) {
                stringBuilder.append("\n\nCOMMENT ON AGGREGATE ");
                stringBuilder.append(pGProcName.getSignature());
                stringBuilder.append(" IS '");
                stringBuilder.append(SqlUtil.escapeQuotes(procedureDefinition.getComment()));
                stringBuilder.append("';\n\n");
            }
        }
        procedureDefinition.setSource(stringBuilder);
    }

    private CharSequence buildParameterList(String string, String string2, String string3) {
        List<String> list = StringUtil.stringToList(string, ";", true, true);
        List<String> list2 = StringUtil.stringToList(string2, ";", true, true);
        List<String> list3 = StringUtil.stringToList(string3, ";", true, true);
        List<ColumnIdentifier> list4 = this.convertToColumns(list, list2, list3);
        StringBuilder stringBuilder = new StringBuilder(list4.size() * 10);
        stringBuilder.append('(');
        int n = 0;
        for (ColumnIdentifier columnIdentifier : list4) {
            String string4 = columnIdentifier.getArgumentMode();
            if ("RETURN".equals(string4)) continue;
            if (n > 0) {
                stringBuilder.append(", ");
            }
            String string5 = columnIdentifier.getColumnName();
            String string6 = columnIdentifier.getDbmsType();
            stringBuilder.append(string5);
            stringBuilder.append(' ');
            stringBuilder.append(string6);
            ++n;
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFunctionDef(ProcedureDefinition procedureDefinition) {
        Statement statement;
        ResultSet resultSet;
        StringBuilder stringBuilder;
        block8: {
            PGProcName pGProcName = new PGProcName(procedureDefinition, this.getTypeLookup());
            String string = procedureDefinition.getSchema() + "." + pGProcName.getSignature();
            String string2 = JdbcUtils.hasMinimumServerVersion(this.connection, "9.1") ? "SELECT pg_get_functiondef(p.oid) as source, ext.extname as extension_name \nfrom pg_proc p \n  left join pg_depend d ON d.objid = p.oid AND d.deptype = 'e' \n  left join pg_extension ext on ext.oid = d.refobjid \nwhere p.oid = '" + string + "'::regprocedure" : "select pg_get_functiondef('" + string + "'::regprocedure) as source, null::text as extension_name";
            LogMgr.logMetadataSql(new CallerInfo(){}, "function definition", string2, new Object[0]);
            stringBuilder = null;
            resultSet = null;
            Savepoint savepoint = null;
            statement = null;
            try {
                if (this.useSavepoint) {
                    savepoint = this.connection.setSavepoint();
                }
                if (!(resultSet = (statement = this.connection.createStatementForQuery()).executeQuery(string2)).next()) break block8;
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                if (StringUtil.isNonBlank(string3)) {
                    stringBuilder = new StringBuilder(string3.length() + 50);
                    stringBuilder.append(string3);
                    if (!string3.endsWith("\n")) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(";\n");
                    if (StringUtil.isNonBlank(procedureDefinition.getComment())) {
                        stringBuilder.append("\nCOMMENT ON FUNCTION ");
                        stringBuilder.append(pGProcName.getFormattedName());
                        stringBuilder.append(" IS '");
                        stringBuilder.append(SqlUtil.escapeQuotes(procedureDefinition.getComment()));
                        stringBuilder.append("'\n;\n");
                    }
                }
                if (!StringUtil.isNonBlank(string4)) break block8;
                stringBuilder.append("\n-- Created through extension: " + string4 + "\n");
            }
            catch (SQLException sQLException) {
                try {
                    stringBuilder = new StringBuilder(ExceptionUtil.getDisplay(sQLException));
                    this.connection.rollback(savepoint);
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "function definition", string2, new Object[0]);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        procedureDefinition.setSource(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder getAggregateSource(PGProcName pGProcName, String string) {
        String string2 = "SELECT a.aggtransfn, a.aggfinalfn, format_type(a.aggtranstype, null) as stype, a.agginitval, op.oprname ";
        String string3 = " FROM pg_proc p \n  JOIN pg_namespace n ON p.pronamespace = n.oid \n  JOIN pg_aggregate a ON a.aggfnoid = p.oid \n  LEFT JOIN pg_operator op ON op.oid = a.aggsortop ";
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.connection, "8.1");
        if (bl) {
            string2 = string2 + ", a.aggsortop ";
        }
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(this.connection, "9.6");
        string2 = string2 + ", " + (bl2 ? "p.proparallel" : "null as proparallel");
        String string4 = string2 + "\n" + string3;
        string4 = string4 + " WHERE p.proname = '" + pGProcName.getName() + "' ";
        if (StringUtil.isNonBlank(string)) {
            string4 = string4 + " and n.nspname = '" + string + "' ";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "aggregate source", string4, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        ResultSet resultSet = null;
        Statement statement = null;
        Savepoint savepoint = null;
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            if ((resultSet = (statement = this.connection.createStatementForQuery()).executeQuery(string4)).next()) {
                String string5;
                String string6;
                String string7;
                stringBuilder.append("CREATE AGGREGATE ");
                stringBuilder.append(pGProcName.getFormattedName());
                stringBuilder.append("\n(\n");
                String string8 = resultSet.getString("aggtransfn");
                stringBuilder.append("  sfunc = ");
                stringBuilder.append(string8);
                String string9 = resultSet.getString("stype");
                stringBuilder.append(",\n  stype = ");
                stringBuilder.append(string9);
                String string10 = resultSet.getString("oprname");
                if (StringUtil.isNonBlank(string10)) {
                    stringBuilder.append(",\n  sortop = ");
                    stringBuilder.append(this.connection.getMetadata().quoteObjectname(string10));
                }
                if (StringUtil.isNonBlank(string7 = resultSet.getString("aggfinalfn")) && !string7.equals("-")) {
                    stringBuilder.append(",\n  finalfunc = ");
                    stringBuilder.append(string7);
                }
                if (StringUtil.isNonBlank(string6 = resultSet.getString("agginitval"))) {
                    stringBuilder.append(",\n  initcond = '");
                    stringBuilder.append(string6);
                    stringBuilder.append('\'');
                }
                if (this.nonDefaultParallel(string5 = resultSet.getString("proparallel"))) {
                    stringBuilder.append(",\n  parallel = ");
                    stringBuilder.append(this.codeToParallelType(string5).toLowerCase());
                }
                stringBuilder.append("\n);\n");
            }
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                stringBuilder = null;
                this.connection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "aggregate source", string4, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return stringBuilder;
    }

    private boolean nonDefaultParallel(String string) {
        if (string == null) {
            return false;
        }
        return !string.equals("u");
    }

    private String codeToParallelType(String string) {
        switch (string) {
            case "s": {
                return "SAFE";
            }
            case "r": {
                return "RESTRICTED";
            }
            case "u": {
                return "UNSAFE";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore getColumns(String string, String string2, PGProcName pGProcName) throws SQLException {
        Object object;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Savepoint savepoint;
        DataStore dataStore;
        String string3;
        block10: {
            string3 = "SELECT format_type(p.prorettype, NULL) as formatted_type, \n       t.typname as pg_type, \n       coalesce(array_to_string(proallargtypes, ';'), array_to_string(proargtypes, ';')) as argtypes, \n       array_to_string(p.proargnames, ';') as argnames, \n       array_to_string(p.proargmodes, ';') as modes, \n       t.typtype \nFROM pg_catalog.pg_proc p \n   JOIN pg_catalog.pg_namespace n ON p.pronamespace = n.oid \n   JOIN pg_catalog.pg_type t ON p.prorettype = t.oid \nWHERE n.nspname = ? \n  AND p.proname = ? \n";
            dataStore = this.createProcColsDataStore();
            savepoint = null;
            preparedStatement = null;
            resultSet = null;
            String string4 = pGProcName.getInputOIDs();
            if (StringUtil.isNonBlank(string4)) {
                string3 = string3 + "  AND p.proargtypes = cast('" + string4 + "' as oidvector)";
            }
            LogMgr.logMetadataSql(new CallerInfo(){}, "procedure columns", string3, string2, pGProcName.getName());
            savepoint = this.connection.setSavepoint();
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, pGProcName.getName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl;
                String string5 = resultSet.getString("formatted_type");
                object = resultSet.getString("pg_type");
                String string6 = resultSet.getString("argtypes");
                String string7 = resultSet.getString("argnames");
                String string8 = resultSet.getString("modes");
                String string9 = resultSet.getString("typtype");
                boolean bl2 = bl = string9.equals("b") || string9.equals("d") || string9.equals("p") && string8 == null;
                if (bl) {
                    int n = dataStore.addRow();
                    dataStore.setValue(n, 0, (Object)"returnValue");
                    dataStore.setValue(n, 1, (Object)"RETURN");
                    dataStore.setValue(n, 3, (Object)this.getJavaType((String)object));
                    dataStore.setValue(n, 2, (Object)StringUtil.trimQuotes(string5));
                }
                List<String> list = StringUtil.stringToList(string7, ";", true, true);
                List<String> list2 = StringUtil.stringToList(string6, ";", true, true);
                if (string8 == null) {
                    string8 = string6.replaceAll("[0-9]+", "i");
                }
                List<String> list3 = StringUtil.stringToList(string8, ";", true, true);
                List<ColumnIdentifier> list4 = this.convertToColumns(list, list2, list3);
                for (ColumnIdentifier columnIdentifier : list4) {
                    int n = dataStore.addRow();
                    dataStore.setValue(n, 1, (Object)columnIdentifier.getArgumentMode());
                    dataStore.setValue(n, 3, (Object)columnIdentifier.getDataType());
                    dataStore.setValue(n, 2, (Object)columnIdentifier.getDbmsType());
                    dataStore.setValue(n, 0, (Object)columnIdentifier.getColumnName());
                }
                break block10;
            }
            LogMgr.logWarning(new CallerInfo(){}, "No columns returned for procedure: " + pGProcName.getName(), null);
            DataStore dataStore2 = super.getProcedureColumns(string, string2, pGProcName.getName(), null);
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return dataStore2;
        }
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.connection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedure columns", string3, string2, pGProcName.getName());
                object = super.getProcedureColumns(string, string2, pGProcName.getName(), null);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return object;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    private List<ColumnIdentifier> convertToColumns(List<String> list, List<String> list2, List<String> list3) {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            int n = StringUtil.getIntValue(list2.get(i), -1);
            String string = this.getTypeNameFromOid(n);
            String string2 = "$" + (i + 1);
            if (list != null && i < list.size()) {
                string2 = list.get(i);
            }
            String string3 = null;
            if (list3 != null && i < list3.size()) {
                string3 = PostgresProcedureReader.pgArgModeToJdbc(list3.get(i));
            }
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2);
            columnIdentifier.setDataType(this.getJavaType(string));
            columnIdentifier.setDbmsType(this.getTypeNameFromOid(n));
            columnIdentifier.setArgumentMode(string3);
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }

    static String pgArgModeToJdbc(String string) {
        if (string == null) {
            return null;
        }
        switch (string) {
            case "i": {
                return "IN";
            }
            case "o": {
                return "OUT";
            }
            case "b": {
                return "INOUT";
            }
            case "v": {
                return "IN";
            }
            case "t": {
                return "RETURN";
            }
        }
        return null;
    }
}

