/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.PgPublication;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresPublicationReader
implements ObjectListExtender {
    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("PUBLICATION");
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return "PUBLICATION".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PgPublication> getPublications(WbConnection wbConnection, String string) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<PgPublication> arrayList = new ArrayList<PgPublication>();
        String string2 = JdbcUtils.hasMinimumServerVersion(wbConnection, "11") ? "       pubtruncate, \n" : "       false as pubtruncate, \n";
        StringBuilder stringBuilder = new StringBuilder("select pubname, \n       puballtables, \n       pubinsert, \n       pubupdate, \n       pubdelete, \n" + string2 + "       pg_catalog.obj_description(oid) as remarks \nfrom pg_catalog.pg_publication ");
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\nwhere ");
            SqlUtil.appendExpression(stringBuilder, "pubname", string, wbConnection);
        }
        stringBuilder.append("\norder by pubname");
        LogMgr.logMetadataSql(new CallerInfo(){}, "publications", stringBuilder, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string3 = resultSet.getString("pubname");
                String string4 = resultSet.getString("remarks");
                PgPublication pgPublication = new PgPublication(string3);
                pgPublication.setReplicatesDeletes(resultSet.getBoolean("pubdelete"));
                pgPublication.setReplicatesInserts(resultSet.getBoolean("pubinsert"));
                pgPublication.setReplicatesUpdates(resultSet.getBoolean("pubupdate"));
                pgPublication.setReplicatesTruncate(resultSet.getBoolean("pubtruncate"));
                pgPublication.setComment(string4);
                arrayList.add(pgPublication);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "publications", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        PgPublication pgPublication = this.getObjectDefinition(wbConnection, dbObject);
        if (pgPublication == null) {
            return null;
        }
        return null;
    }

    @Override
    public PgPublication getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<PgPublication> list = this.getPublications(wbConnection, dbObject.getObjectName());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        PgPublication pgPublication = this.getObjectDefinition(wbConnection, dbObject);
        if (pgPublication == null) {
            return null;
        }
        try {
            return pgPublication.getSource(wbConnection).toString();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve publication source", exception);
            return null;
        }
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("PUBLICATION", stringArray)) {
            return false;
        }
        List<PgPublication> list = this.getPublications(wbConnection, string3);
        for (PgPublication pgPublication : list) {
            int n = dataStore.addRow();
            dataStore.getRow(n).setUserObject(pgPublication);
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, null);
            dataStore.setValue(n, 0, (Object)pgPublication.getObjectName());
            dataStore.setValue(n, 4, (Object)pgPublication.getComment());
            dataStore.setValue(n, 1, (Object)pgPublication.getObjectType());
        }
        return list.size() > 0;
    }

    public List<TableIdentifier> getTables(WbConnection wbConnection, DbObject dbObject) {
        PgPublication pgPublication = this.getObjectDefinition(wbConnection, dbObject);
        return pgPublication.retrieveTables(wbConnection);
    }
}

