/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class PostgresSequenceReader
implements SequenceReader {
    private WbConnection dbConnection;
    private static final String NAME_PLACEHOLDER = "%sequence_name%";
    private final String baseSql = "SELECT seq_info.*, \n       null::text as data_type, \n       pg_catalog.obj_description(seq.oid, 'pg_class') as remarks, \n       pg_catalog.quote_ident(tab.relname)||'.'||quote_ident(col.attname) as owned_by, \n       seq.relname as sequence_name, \n       sn.nspname as sequence_schema \nFROM pg_catalog.pg_class seq   \n  JOIN pg_catalog.pg_namespace sn ON sn.oid = seq.relnamespace \n  CROSS JOIN (SELECT min_value, max_value, last_value, increment_by, cache_value, is_cycled FROM %sequence_name%) seq_info \n  LEFT JOIN pg_catalog.pg_depend d ON d.objid = seq.oid AND deptype = 'a' \n  LEFT JOIN pg_catalog.pg_class tab ON d.objid = seq.oid AND d.refobjid = tab.oid   \n  LEFT JOIN pg_catalog.pg_attribute col ON (d.refobjid, d.refobjsubid) = (col.attrelid, col.attnum) \nWHERE seq.relkind = 'S'";
    private final String baseSqlV10 = "select s.min_value,\n       s.max_value,\n       s.last_value,\n       s.increment_by,\n       s.cache_size as cache_value,\n       s.cycle as is_cycled,\n       pg_catalog.format_type(s.data_type, NULL) as data_type,\n       pg_catalog.obj_description(to_regclass(format('%I.%I', s.schemaname, s.sequencename)), 'pg_class') as remarks,\n       pg_catalog.quote_ident(tab.relname)||'.'||quote_ident(col.attname) as owned_by,\n       s.sequencename as sequence_name, \n       s.schemaname as sequence_schema\nfrom pg_catalog.pg_sequences s\n  LEFT JOIN pg_catalog.pg_depend d ON d.objid = pg_catalog.to_regclass(format('%I.%I', s.schemaname, s.sequencename)) AND deptype in ('a', 'i') \n  LEFT JOIN pg_catalog.pg_class tab ON d.objid = pg_catalog.to_regclass(format('%I.%I', s.schemaname, s.sequencename)) AND d.refobjid = tab.oid   \n  LEFT JOIN pg_catalog.pg_attribute col ON (d.refobjid, d.refobjsubid) = (col.attrelid, col.attnum)";

    public PostgresSequenceReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        this.readSequenceSource(sequenceDefinition, true);
    }

    public void readSequenceSource(SequenceDefinition sequenceDefinition, boolean bl) {
        CharSequence charSequence = this.getSequenceSource(sequenceDefinition, bl);
        sequenceDefinition.setSource(charSequence);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return "";
        }
        return sequenceDefinition.getSource();
    }

    @Override
    public CharSequence getSequenceSource(SequenceDefinition sequenceDefinition, boolean bl) {
        if (sequenceDefinition == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        try {
            String string = sequenceDefinition.getSequenceName();
            Long l = (Long)sequenceDefinition.getSequenceProperty("max_value");
            Long l2 = (Long)sequenceDefinition.getSequenceProperty("min_value");
            Long l3 = (Long)sequenceDefinition.getSequenceProperty("increment");
            Long l4 = (Long)sequenceDefinition.getSequenceProperty("cache");
            Boolean bl2 = (Boolean)sequenceDefinition.getSequenceProperty("cycle");
            if (bl2 == null) {
                bl2 = Boolean.FALSE;
            }
            String string2 = (String)sequenceDefinition.getSequenceProperty("data_type");
            stringBuilder.append("CREATE SEQUENCE ");
            stringBuilder.append(string);
            if (StringUtil.isNonBlank(string2) && StringUtil.stringsAreNotEqual("bigint", string2)) {
                stringBuilder.append("\n       AS ");
                stringBuilder.append(string2);
            }
            stringBuilder.append("\n       INCREMENT BY ");
            stringBuilder.append(l3);
            stringBuilder.append("\n       MINVALUE ");
            stringBuilder.append(l2);
            long l5 = Long.MAX_VALUE;
            if (l != l5) {
                stringBuilder.append("\n       MAXVALUE ");
                stringBuilder.append(l.toString());
            }
            stringBuilder.append("\n       CACHE ");
            stringBuilder.append(l4);
            stringBuilder.append("\n       ");
            if (!bl2.booleanValue()) {
                stringBuilder.append("NO ");
            }
            stringBuilder.append("CYCLE");
            String string3 = sequenceDefinition.getRelatedColumn();
            TableIdentifier tableIdentifier = sequenceDefinition.getRelatedTable();
            if (tableIdentifier != null && StringUtil.isNonBlank(string3)) {
                String string4 = tableIdentifier.getTableName() + "." + string3;
                if (bl) {
                    stringBuilder.append("\n       OWNED BY ");
                    stringBuilder.append(string4);
                }
                sequenceDefinition.setPostCreationSQL("ALTER SEQUENCE " + sequenceDefinition.getObjectExpression(this.dbConnection) + " OWNED BY " + string4 + ";");
            }
            stringBuilder.append(";\n");
            if (StringUtil.isNonBlank(sequenceDefinition.getComment())) {
                stringBuilder.append('\n');
                stringBuilder.append("COMMENT ON SEQUENCE ").append(sequenceDefinition.getSequenceName()).append(" IS '").append(sequenceDefinition.getComment().replace("'", "''")).append("';");
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading sequence definition", exception);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        if (string3 == null) {
            string3 = "%";
        }
        try {
            savepoint = this.dbConnection.setSavepoint();
            DatabaseMetaData databaseMetaData = this.dbConnection.getSqlConnection().getMetaData();
            resultSet = databaseMetaData.getTables(null, string2, string3, new String[]{"SEQUENCE"});
            while (resultSet.next()) {
                String string4 = resultSet.getString("TABLE_NAME");
                String string5 = resultSet.getString("TABLE_SCHEM");
                arrayList.add(this.getSequenceDefinition(null, string5, string4));
            }
            this.dbConnection.releaseSavepoint(savepoint);
            JdbcUtils.closeResult(resultSet);
        }
        catch (SQLException sQLException) {
            this.dbConnection.rollback(savepoint);
            LogMgr.logError(new CallerInfo(){}, "Error retrieving sequences", sQLException);
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
        return arrayList;
    }

    private SequenceDefinition createDefinition(String string, String string2, DataStore dataStore) {
        Object object;
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(0, "increment_by"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(0, "max_value"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(0, "min_value"));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(0, "cache_value"));
        sequenceDefinition.setSequenceProperty("cycle", dataStore.getValue(0, "is_cycled"));
        sequenceDefinition.setSequenceProperty("last_value", dataStore.getValue(0, "last_value"));
        sequenceDefinition.setSequenceProperty("data_type", dataStore.getValue(0, "data_type"));
        String string3 = dataStore.getValueAsString(0, "owned_by");
        if (StringUtil.isNonEmpty(string3)) {
            object = StringUtil.stringToList(string3, ".", true, true, false, false);
            TableIdentifier tableIdentifier = new TableIdentifier(string2, (String)object.get(0));
            sequenceDefinition.setRelatedTable(tableIdentifier, (String)object.get(1));
        }
        object = dataStore.getValueAsString(0, "remarks");
        sequenceDefinition.setComment((String)object);
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(null, string2, string3);
        if (dataStore == null) {
            return null;
        }
        SequenceDefinition sequenceDefinition = this.createDefinition(string3, string2, dataStore);
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        String string4 = string2 == null ? string3 : string2 + "." + string3;
        DataStore dataStore = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "10.0");
        String string5 = bl ? "select s.min_value,\n       s.max_value,\n       s.last_value,\n       s.increment_by,\n       s.cache_size as cache_value,\n       s.cycle as is_cycled,\n       pg_catalog.format_type(s.data_type, NULL) as data_type,\n       pg_catalog.obj_description(to_regclass(format('%I.%I', s.schemaname, s.sequencename)), 'pg_class') as remarks,\n       pg_catalog.quote_ident(tab.relname)||'.'||quote_ident(col.attname) as owned_by,\n       s.sequencename as sequence_name, \n       s.schemaname as sequence_schema\nfrom pg_catalog.pg_sequences s\n  LEFT JOIN pg_catalog.pg_depend d ON d.objid = pg_catalog.to_regclass(format('%I.%I', s.schemaname, s.sequencename)) AND deptype in ('a', 'i') \n  LEFT JOIN pg_catalog.pg_class tab ON d.objid = pg_catalog.to_regclass(format('%I.%I', s.schemaname, s.sequencename)) AND d.refobjid = tab.oid   \n  LEFT JOIN pg_catalog.pg_attribute col ON (d.refobjid, d.refobjsubid) = (col.attrelid, col.attnum)" : "SELECT seq_info.*, \n       null::text as data_type, \n       pg_catalog.obj_description(seq.oid, 'pg_class') as remarks, \n       pg_catalog.quote_ident(tab.relname)||'.'||quote_ident(col.attname) as owned_by, \n       seq.relname as sequence_name, \n       sn.nspname as sequence_schema \nFROM pg_catalog.pg_class seq   \n  JOIN pg_catalog.pg_namespace sn ON sn.oid = seq.relnamespace \n  CROSS JOIN (SELECT min_value, max_value, last_value, increment_by, cache_value, is_cycled FROM %sequence_name%) seq_info \n  LEFT JOIN pg_catalog.pg_depend d ON d.objid = seq.oid AND deptype = 'a' \n  LEFT JOIN pg_catalog.pg_class tab ON d.objid = seq.oid AND d.refobjid = tab.oid   \n  LEFT JOIN pg_catalog.pg_attribute col ON (d.refobjid, d.refobjsubid) = (col.attrelid, col.attnum) \nWHERE seq.relkind = 'S'";
        String string6 = "select min_value, max_value, last_value, increment_by, cache_value, is_cycled, data_type, remarks, owned_by \nfrom ( \n" + string5.replace(NAME_PLACEHOLDER, string4) + "\n) t \nwhere sequence_name = ? ";
        if (string2 != null) {
            string6 = string6 + "\n  and sequence_schema = ? ";
        }
        try {
            LogMgr.logMetadataSql(new CallerInfo(){}, "sequence details", string6, string3, string2);
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string6);
            preparedStatement.setString(1, string3);
            if (string2 != null) {
                preparedStatement.setString(2, string2);
            }
            resultSet = preparedStatement.executeQuery();
            dataStore = new DataStore(resultSet, true);
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            DataStore dataStore2;
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "sequence details", string6, string3, string2);
                dataStore2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return dataStore2;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (dataStore.getRowCount() > 1) {
            int n;
            int n2 = dataStore.getColumnIndex("owned_by");
            String string7 = "";
            for (n = 0; n < dataStore.getRowCount(); ++n) {
                String string8 = dataStore.getValueAsString(n, n2);
                if (!StringUtil.isNonEmpty(string8)) continue;
                if (string7.length() > 0) {
                    string7 = string7 + ", ";
                }
                string7 = string7 + string8;
            }
            for (n = dataStore.getRowCount() - 1; n > 0; --n) {
                dataStore.deleteRow(n);
            }
            dataStore.setValue(0, n2, (Object)string7);
        }
        dataStore.resetStatus();
        return dataStore;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }

    @Override
    public boolean supportsDependentSQL() {
        return true;
    }
}

