/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import workbench.db.DefaultTriggerReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresProcedureReader;
import workbench.db.postgres.PostgresUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresTriggerReader
extends DefaultTriggerReader {
    private boolean is93 = false;

    public PostgresTriggerReader(WbConnection wbConnection) {
        super(wbConnection);
        this.is93 = JdbcUtils.hasMinimumServerVersion(wbConnection, "9.3");
    }

    @Override
    public DataStore getTriggers(String string, String string2) throws SQLException {
        DataStore dataStore = super.getTriggers(string, string2);
        if (this.is93) {
            this.retrieveEventTriggers(dataStore, null);
        }
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveEventTriggers(DataStore dataStore, String string) {
        Object object;
        String string2 = "select evtname as trigger, \n       evtevent as event, \n       pg_catalog.obj_description(oid, 'pg_event_trigger') as remarks \nFROM pg_catalog.pg_event_trigger";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        if (string != null) {
            string2 = string2 + " \nWHERE evtname ";
            string2 = string.contains("%") ? string2 + " LIKE '" + SqlUtil.escapeQuotes(string) + "'" : string2 + " = '" + SqlUtil.escapeQuotes(string) + "'";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "event triggers", string2, new Object[0]);
        int n = 0;
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ++n;
                object = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                int n2 = dataStore.addRow();
                dataStore.setValue(n2, 0, object);
                dataStore.setValue(n2, 1, (Object)"EVENT");
                dataStore.setValue(n2, 2, (Object)string3);
                dataStore.setValue(n2, 4, (Object)string4);
                TriggerDefinition triggerDefinition = new TriggerDefinition(null, null, (String)object);
                triggerDefinition.setComment(string4);
                triggerDefinition.setTriggerType("EVENT TRIGGER");
                dataStore.getRow(n2).setUserObject(triggerDefinition);
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "event triggers", string2, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (n > 0) {
            object = new SortDefinition();
            ((SortDefinition)object).addSortColumn(0, true);
            dataStore.sort((SortDefinition)object);
        }
        dataStore.resetStatus();
        return n;
    }

    @Override
    public String getTriggerSource(String string, String string2, String string3, TableIdentifier tableIdentifier, String string4, boolean bl) throws SQLException {
        if (tableIdentifier == null && this.is93) {
            return this.getEventTriggerSource(string3);
        }
        return super.getTriggerSource(string, string2, string3, tableIdentifier, string4, bl);
    }

    public String getEventTriggerSource(String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(100);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "event trigger source", "select pr.proname, \n       trg.evtevent, \n        trg.evttags, \n        pg_catalog.pg_get_functiondef(pr.oid) as func_source \nFROM pg_catalog.pg_event_trigger trg \n JOIN pg_catalog.pg_proc pr on pr.oid = trg.evtfoid \n join pg_catalog.pg_namespace nsp on nsp.oid = pr.pronamespace \nwhere trg.evtname = ?", string);
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String[] stringArray = null;
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement("select pr.proname, \n       trg.evtevent, \n        trg.evttags, \n        pg_catalog.pg_get_functiondef(pr.oid) as func_source \nFROM pg_catalog.pg_event_trigger trg \n JOIN pg_catalog.pg_proc pr on pr.oid = trg.evtfoid \n join pg_catalog.pg_namespace nsp on nsp.oid = pr.pronamespace \nwhere trg.evtname = ?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString("evtevent");
                stringArray = JdbcUtils.getArray(resultSet, "evttags", String[].class);
                string4 = resultSet.getString("func_source");
                string2 = resultSet.getString("proname");
            }
            stringBuilder.append("DROP EVENT TRIGGER IF EXISTS ");
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(string2));
            stringBuilder.append(" CASCADE;\n\n");
            stringBuilder.append("CREATE EVENT TRIGGER ");
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(string2));
            stringBuilder.append("\n  ON ");
            stringBuilder.append(string3);
            if (stringArray != null) {
                stringBuilder.append("\n  WHEN TAG IN (");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append('\'');
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append('\'');
                }
                stringBuilder.append(')');
            }
            stringBuilder.append("\n  EXECUTE PROCEDURE ");
            stringBuilder.append(string2);
            stringBuilder.append("();\n\nCOMMIT;\n");
            stringBuilder.append("\n---[ ");
            stringBuilder.append(string2);
            stringBuilder.append(" ]---\n");
            stringBuilder.append(string4);
            stringBuilder.append('\n');
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "event trigger source", "select pr.proname, \n       trg.evtevent, \n        trg.evttags, \n        pg_catalog.pg_get_functiondef(pr.oid) as func_source \nFROM pg_catalog.pg_event_trigger trg \n JOIN pg_catalog.pg_proc pr on pr.oid = trg.evtfoid \n join pg_catalog.pg_namespace nsp on nsp.oid = pr.pronamespace \nwhere trg.evtname = ?", string);
                this.dbConnection.rollback(savepoint);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder.toString();
    }

    @Override
    public CharSequence getDependentSource(String string, String string2, String string3, TableIdentifier tableIdentifier) throws SQLException {
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logMetadataSql(callerInfo, "dependent trigger source", "SELECT trgsch.nspname as function_schema, proc.proname as function_name \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE trg.tgname = ? \n  AND tblsch.nspname = ? ", string3, tableIdentifier.getSchema());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string4 = null;
        String string5 = null;
        StringBuilder stringBuilder = null;
        Savepoint savepoint = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement("SELECT trgsch.nspname as function_schema, proc.proname as function_name \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE trg.tgname = ? \n  AND tblsch.nspname = ? ");
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, tableIdentifier.getSchema());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string5 = resultSet.getString(1);
                string4 = resultSet.getString(2);
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logMetadataError(callerInfo, sQLException, "dependent trigger source", "SELECT trgsch.nspname as function_schema, proc.proname as function_name \nFROM pg_catalog.pg_trigger trg  \n  JOIN pg_catalog.pg_class tbl ON tbl.oid = trg.tgrelid  \n  JOIN pg_catalog.pg_proc proc ON proc.oid = trg.tgfoid \n  JOIN pg_catalog.pg_namespace trgsch ON trgsch.oid = proc.pronamespace \n  JOIN pg_catalog.pg_namespace tblsch ON tblsch.oid = tbl.relnamespace \nWHERE trg.tgname = ? \n  AND tblsch.nspname = ? ", string3, tableIdentifier.getSchema());
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (string4 != null && string5 != null) {
            PostgresProcedureReader postgresProcedureReader = new PostgresProcedureReader(this.dbConnection);
            ProcedureDefinition procedureDefinition = new ProcedureDefinition(null, string5, string4, 1);
            try {
                postgresProcedureReader.readProcedureSource(procedureDefinition);
                CharSequence charSequence = procedureDefinition.getSource();
                if (charSequence != null) {
                    stringBuilder = new StringBuilder(charSequence.length() + 50);
                    stringBuilder.append("\n---[ ");
                    stringBuilder.append(string4);
                    stringBuilder.append(" ]---\n");
                    stringBuilder.append(charSequence);
                    stringBuilder.append('\n');
                }
            }
            catch (NoConfigException noConfigException) {
                // empty catch block
            }
        }
        return stringBuilder;
    }

    @Override
    public boolean supportsTriggersOnViews() {
        if (this.dbConnection == null) {
            return false;
        }
        return JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.1");
    }

    @Override
    protected String getListTriggerSQL(String string, String string2, String string3) {
        if (PostgresUtil.isRedshift(this.dbConnection)) {
            return null;
        }
        String string4 = null;
        string4 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "8.3") ? "\t     case\n        when trg.tgenabled in ('O', 'A') then 'ENABLED'\n\t       else 'DISABLED'\n      end as status" : "\t     case\n        when trg.tgenabled then 'ENABLED'\n\t       else 'DISABLED'\n      end as status";
        String string5 = "select trg.tgname,\n       CASE trg.tgtype::integer & 66 \n         WHEN 2 THEN 'BEFORE'\n         WHEN 64 THEN 'INSTEAD OF'\n         ELSE 'AFTER'\n       end as trigger_type,\n       case trg.tgtype::integer & cast(28 as int2)\n         when 4 then 'INSERT' \n         when 8 then 'DELETE' \n         when 12 then 'INSERT, DELETE' \n         when 16 then 'UPDATE' \n         when 20 then 'INSERT, UPDATE' \n         when 28 then 'INSERT, UPDATE, DELETE' \n         when 24 then 'UPDATE, DELETE' \n       end as trigger_event, \n       ns.nspname||'.'||tbl.relname as trigger_table, \n       obj_description(trg.oid) as remarks, \n" + string4 + ", \n       case trg.tgtype::integer & 1 \n         when 1 then 'ROW'::text \n         else 'STATEMENT'::text \n       end as trigger_level \nFROM pg_catalog.pg_trigger trg \n  JOIN pg_catalog.pg_class tbl on trg.tgrelid = tbl.oid \n  JOIN pg_catalog.pg_namespace ns ON ns.oid = tbl.relnamespace \n";
        string5 = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "9.0") ? string5 + "WHERE NOT trg.tgisinternal \n" : string5 + "WHERE trg.tgname not like 'RI_ConstraintTrigger%' \n  AND trg.tgname not like 'pg_sync_pg%' \n";
        if (StringUtil.isNonBlank(string2) && !"*".equals(string2)) {
            string5 = string5 + "  AND ns.nspname = '" + SqlUtil.escapeQuotes(string2) + "' \n";
        }
        if (StringUtil.isNonBlank(string3)) {
            string5 = string5 + "  AND tbl.relname = '" + SqlUtil.escapeQuotes(string3) + "' \n";
        }
        if (this.dbConnection.getDbSettings().returnAccessibleTablesOnly()) {
            string5 = string5 + "  AND pg_catalog.has_table_privilege(tbl.oid, 'select') \n";
        }
        return string5;
    }
}

