/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class PostgresUtil {
    public static final String APP_NAME_PROPERTY = "ApplicationName";

    public static boolean supportsPartitioning(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        return wbConnection.getMetadata().isPostgres() && JdbcUtils.hasMinimumServerVersion(wbConnection, "10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationName(Connection connection, String string) {
        if (JdbcUtils.hasMinimumServerVersion(connection, "9.0") && Settings.getInstance().getBoolProperty("workbench.db.postgresql.set.appname", true)) {
            Statement statement = null;
            try {
                connection.setAutoCommit(false);
                statement = connection.createStatement();
                statement.execute("SET application_name = '" + string + "'");
                connection.commit();
            }
            catch (Exception exception) {
                try {
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    LogMgr.logWarning(new CallerInfo(){}, "Could not set client info", exception);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(statement);
                    throw throwable;
                }
                JdbcUtils.closeStatement(statement);
            }
            JdbcUtils.closeStatement(statement);
        }
    }

    public static boolean supportsAppInfoProperty(Class clazz) {
        try {
            Driver driver = (Driver)clazz.newInstance();
            int n = driver.getMajorVersion();
            int n2 = driver.getMinorVersion();
            VersionNumber versionNumber = new VersionNumber(n, n2);
            VersionNumber versionNumber2 = new VersionNumber(9, 1);
            return versionNumber.isNewerOrEqual(versionNumber2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSearchPath(WbConnection wbConnection) {
        if (wbConnection == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        Statement statement = null;
        Savepoint savepoint = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "search path", "select unnest(pg_catalog.current_schemas(true))", new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery("select unnest(pg_catalog.current_schemas(true))");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                arrayList.add(string);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "search path", "select unnest(pg_catalog.current_schemas(true))", new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (arrayList.isEmpty()) {
            LogMgr.logWarning(new CallerInfo(){}, "Using public as the default search path");
            arrayList.add(wbConnection.getDisplayUser());
            arrayList.add("public");
        }
        return arrayList;
    }

    public static String switchDatabaseURL(String string, String string2) {
        if (StringUtil.isBlank(string)) {
            return string;
        }
        if (!string.startsWith("jdbc:postgresql:")) {
            throw new IllegalArgumentException("Not a Postgres JDBC URL");
        }
        int n = string.indexOf("//");
        if (n < 0) {
            return string;
        }
        if ((n = string.indexOf(47, n + 2)) < 0) {
            return string;
        }
        String string3 = string.substring(0, n + 1);
        int n2 = string.indexOf(63, n + 1);
        String string4 = string3 + string2;
        if (n2 > 0) {
            string4 = string4 + string.substring(n2);
        }
        return string4;
    }

    public static String getCurrentDatabase(WbConnection wbConnection) {
        try {
            return wbConnection.getSqlConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static List<String> getAccessibleDatabases(WbConnection wbConnection) {
        if (wbConnection == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DataStore dataStore = SqlUtil.getResult(wbConnection, "select datname from pg_catalog.pg_database where pg_catalog.has_database_privilege(datname, 'connect') \n  and datallowconn \norder by datname", true);
        if (dataStore != null) {
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                arrayList.add(dataStore.getValueAsString(i, 0));
            }
        }
        return arrayList;
    }

    public static List<String> getAllDatabases(WbConnection wbConnection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DataStore dataStore = PostgresUtil.listPgDatabases(wbConnection, false);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                arrayList.add(dataStore.getValueAsString(i, 0));
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve databases", sQLException);
        }
        return arrayList;
    }

    public static DataStore listPgDatabases(WbConnection wbConnection, boolean bl) throws SQLException {
        String string = StringUtil.capitalize(wbConnection.getMetadata().getCatalogTerm());
        String string2 = bl ? "       CASE WHEN pg_catalog.has_database_privilege(d.datname, 'CONNECT')\n            THEN pg_catalog.pg_size_pretty(pg_catalog.pg_database_size(d.datname))\n            ELSE 'No Access'\n       END as \"Size\", \n" : "";
        String string3 = "SELECT d.datname as \"" + string + "\",\n       pg_catalog.pg_get_userbyid(d.datdba) as \"Owner\",\n       pg_catalog.pg_encoding_to_char(d.encoding) as \"Encoding\",\n       d.datcollate as \"Collate\",\n       d.datctype as \"Ctype\",\n       pg_catalog.array_to_string(d.datacl, E'\\n') AS \"Access privileges\", \n" + string2 + "       pg_catalog.shobj_description(d.oid, 'pg_database') as \"Description\" \nFROM pg_catalog.pg_database d\nORDER BY 1";
        DataStore dataStore = SqlUtil.getResult(wbConnection, string3, true);
        dataStore.setGeneratingSql(string3);
        dataStore.setResultName(ResourceMgr.getString("TxtDbList"));
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCockroachDB(Connection connection) {
        boolean bl;
        if (connection == null) {
            return false;
        }
        String string = Settings.getInstance().getProperty("workbench.db.cockroachdb.maxpgversion", "10");
        if (JdbcUtils.hasMinimumServerVersion(connection, string)) {
            return false;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            LogMgr.logInfo(new CallerInfo(){}, "Checking if the backend is in fact a CockroachDB");
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select version()");
            String string2 = "";
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            bl = string2.toLowerCase().contains("cockroach");
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logWarning(new CallerInfo(){}, "Could not check real database version", throwable);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return false;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGreenplum(Connection connection) {
        block9: {
            boolean bl;
            ResultSet resultSet;
            Statement statement;
            block8: {
                statement = null;
                resultSet = null;
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                int n = databaseMetaData.getDatabaseMajorVersion();
                if (n <= 8) break block8;
                boolean bl2 = false;
                JdbcUtils.closeAll(resultSet, statement);
                return bl2;
            }
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select version()");
                String string = "";
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                bl = string.toLowerCase().contains("greenplum");
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not check real database version", throwable);
                    break block9;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    JdbcUtils.closeAll(resultSet, statement);
                }
            }
            JdbcUtils.closeAll(resultSet, statement);
            return bl;
        }
        return false;
    }

    public static boolean isRedshift(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        return wbConnection.getUrl().startsWith("jdbc:redshift:");
    }
}

