/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.storage.ColumnData;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;

public class PostgresWriteableCTEGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("ansi");

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateCte(stringBuilder, rowDataContainer, false);
        return stringBuilder.toString();
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.appendValues(stringBuilder, rowData, resultInfo, l);
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.appendUpdate(stringBuilder, rowDataContainer);
        this.appendInsert(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount());
        this.generateCte(stringBuilder, rowDataContainer, true);
        this.appendUpdate(stringBuilder, rowDataContainer);
        this.appendInsert(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    private void generateCte(StringBuilder stringBuilder, RowDataContainer rowDataContainer, boolean bl) {
        int n;
        stringBuilder.append("with merge_data (");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(n));
        }
        stringBuilder.append(") as \n(\n  values\n");
        if (bl) {
            for (n = 0; n < rowDataContainer.getRowCount(); ++n) {
                this.appendValues(stringBuilder, rowDataContainer.getRow(n), resultInfo, n);
            }
        }
    }

    private void appendValues(StringBuilder stringBuilder, RowData rowData, ResultInfo resultInfo, long l) {
        if (l > 0L) {
            stringBuilder.append(",\n");
        }
        stringBuilder.append("    (");
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            ColumnData columnData = new ColumnData(rowData.getValue(i), resultInfo.getColumn(i));
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
        }
        stringBuilder.append(')');
    }

    private void appendUpdate(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        int n;
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        stringBuilder.append("\n),\nupsert as\n(\n");
        stringBuilder.append("  update ");
        stringBuilder.append(tableIdentifier.getTableExpression(rowDataContainer.getOriginalConnection()));
        stringBuilder.append(" m\n");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        int n2 = 0;
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (resultInfo.getColumn(n).isPkColumn()) continue;
            if (n2 == 0) {
                stringBuilder.append("     set ");
            }
            if (n2 > 0) {
                stringBuilder.append(",\n         ");
            }
            stringBuilder.append("m.");
            stringBuilder.append(resultInfo.getColumnName(n));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(n));
            ++n2;
        }
        stringBuilder.append("\n  from merge_data md\n");
        n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (!columnIdentifier.isPkColumn()) continue;
            if (n == 0) {
                stringBuilder.append("  where ");
            }
            if (n > 0) {
                stringBuilder.append("    and ");
            }
            stringBuilder.append("m.");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(i));
            ++n;
        }
        stringBuilder.append("\n  returning m.*");
        stringBuilder.append("\n)");
    }

    private void appendInsert(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        int n;
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        stringBuilder.append("\ninsert into ");
        stringBuilder.append(tableIdentifier.getTableExpression());
        stringBuilder.append(" (");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        StringBuilder stringBuilder2 = new StringBuilder(resultInfo.getColumnCount() * 15);
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(resultInfo.getColumnName(n));
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(")\nselect ");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("\nfrom merge_data\n");
        stringBuilder.append("where not exists (select 1\n");
        stringBuilder.append("                  from upsert up\n");
        n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (!columnIdentifier.isPkColumn()) continue;
            if (n == 0) {
                stringBuilder.append("                  where ");
            }
            if (n > 0) {
                stringBuilder.append("                    and ");
            }
            stringBuilder.append("up.");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(i));
            ++n;
        }
        stringBuilder.append(");\n");
    }
}

