/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.redshift;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbSearchPath;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class RedshiftSearchPathHandler
implements DbSearchPath {
    @Override
    public boolean isRealSearchPath() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSearchPath(WbConnection wbConnection, String string) {
        if (wbConnection == null) {
            return Collections.emptyList();
        }
        if (string != null) {
            return Collections.singletonList(wbConnection.getMetadata().adjustSchemaNameCase(string));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        Statement statement = null;
        Savepoint savepoint = null;
        String string2 = wbConnection.getDbSettings().getProperty("retrieve.search_path", "select current_schemas(true)::text");
        LogMgr.logMetadataSql(new CallerInfo(){}, "search path", string2, new Object[0]);
        try {
            if (wbConnection.getDbSettings().useSavePointForDML()) {
                savepoint = wbConnection.setSavepoint();
            }
            if ((resultSet = (statement = wbConnection.createStatementForQuery()).executeQuery(string2)).next()) {
                String string3 = resultSet.getString(1);
                if (string3.length() > 1) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                arrayList.addAll(StringUtil.stringToList(string3, ",", true, true, false, false));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "search path", string2, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (arrayList.isEmpty()) {
            LogMgr.logWarning(new CallerInfo(){}, "Using public as the default search path");
            arrayList.add("public");
        }
        return arrayList;
    }
}

