/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.util.Iterator;
import java.util.Map;
import workbench.db.DependencyNode;
import workbench.db.report.ReportTable;
import workbench.db.report.TagWriter;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ForeignKeyDefinition {
    public static final String TAG_FOREIGN_KEY = "foreign-key";
    public static final String TAG_CONSTRAINT_NAME = "constraint-name";
    public static final String TAG_SOURCE_COLS = "source-columns";
    public static final String TAG_TARGET_COLS = "referenced-columns";
    public static final String TAG_UPDATE_RULE = "update-rule";
    public static final String TAG_DELETE_RULE = "delete-rule";
    public static final String TAG_DEFER_RULE = "deferrable";
    private DependencyNode fkDefinition;
    private ReportTable foreignTable;
    private TagWriter tagWriter = new TagWriter();
    private boolean compareFKRules;

    public ForeignKeyDefinition(DependencyNode dependencyNode) {
        this.fkDefinition = dependencyNode;
    }

    public void setForeignTable(ReportTable reportTable) {
        this.foreignTable = reportTable;
    }

    public boolean isEnabled() {
        return this.fkDefinition.isEnabled();
    }

    public void setCompareFKRules(boolean bl) {
        this.compareFKRules = bl;
    }

    public int getUpdateRuleValue() {
        return this.fkDefinition.getUpdateActionValue();
    }

    public int getDeleteRuleValue() {
        return this.fkDefinition.getDeleteActionValue();
    }

    public int getDeferrableRuleValue() {
        return this.fkDefinition.getDeferrableValue();
    }

    public String getUpdateRule() {
        return this.fkDefinition.getUpdateAction();
    }

    public String getDeleteRule() {
        return this.fkDefinition.getDeleteAction();
    }

    public String getDeferRule() {
        return this.fkDefinition.getDeferrableType();
    }

    public ReportTable getForeignTable() {
        return this.foreignTable;
    }

    public String getFkName() {
        return this.fkDefinition.getFkName();
    }

    public String toString() {
        return this.getFkName();
    }

    public StringBuilder getXml(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(250);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_FOREIGN_KEY);
        stringBuilder2.append('\n');
        stringBuilder2.append((CharSequence)this.getInnerXml(stringBuilder3));
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_FOREIGN_KEY);
        return stringBuilder2;
    }

    public StringBuilder getInnerXml(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(250);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        if (this.isEnabled()) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_CONSTRAINT_NAME, this.getFkName());
        } else {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_CONSTRAINT_NAME, this.getFkName(), "enabled", Boolean.toString(this.isEnabled()));
        }
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, "references");
        stringBuilder2.append('\n');
        this.foreignTable.appendTableNameXml(stringBuilder2, stringBuilder3);
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, "references");
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_SOURCE_COLS);
        stringBuilder2.append('\n');
        Map<String, String> map = this.fkDefinition.getColumns();
        for (String string : map.keySet()) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, "column", map.get(string));
        }
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_SOURCE_COLS);
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_TARGET_COLS);
        stringBuilder2.append('\n');
        for (String string : map.keySet()) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, "column", string);
        }
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_TARGET_COLS);
        if (StringUtil.isNonBlank(this.fkDefinition.getComment())) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder, "comment", this.fkDefinition.getComment());
        }
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_DELETE_RULE, this.getDeleteRule(), "jdbcValue", NumberStringCache.getNumberString(this.getDeleteRuleValue()));
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_UPDATE_RULE, this.getUpdateRule(), "jdbcValue", NumberStringCache.getNumberString(this.getUpdateRuleValue()));
        this.tagWriter.appendTag(stringBuilder2, stringBuilder, TAG_DEFER_RULE, this.getDeferRule(), "jdbcValue", NumberStringCache.getNumberString(this.getDeferrableRuleValue()));
        return stringBuilder2;
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + (this.getFkName() != null ? this.getFkName().hashCode() : 0);
        n = 53 * n + (this.foreignTable != null ? this.foreignTable.hashCode() : 0);
        if (this.compareFKRules) {
            n = 53 * n + this.getUpdateRuleValue();
            n = 53 * n + this.getDeleteRuleValue();
            n = 53 * n + this.getDeferrableRuleValue();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ForeignKeyDefinition) {
            return this.equals((ForeignKeyDefinition)object);
        }
        return false;
    }

    private boolean compareColumns(ForeignKeyDefinition foreignKeyDefinition) {
        if (foreignKeyDefinition == null) {
            return false;
        }
        Map<String, String> map = this.fkDefinition.getColumns();
        Map<String, String> map2 = foreignKeyDefinition.fkDefinition.getColumns();
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator<String> iterator = map.keySet().iterator();
        Iterator<String> iterator2 = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = iterator.next();
            if (string2.equalsIgnoreCase(string = iterator2.next())) {
                String string3;
                String string4 = map.get(string2);
                if (string4.equalsIgnoreCase(string3 = map2.get(string))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isNameEqual(ForeignKeyDefinition foreignKeyDefinition) {
        try {
            return this.getFkName().equalsIgnoreCase(foreignKeyDefinition.getFkName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDefinitionEqual(ForeignKeyDefinition foreignKeyDefinition) {
        try {
            boolean bl = this.compareColumns(foreignKeyDefinition);
            boolean bl2 = bl = bl && SqlUtil.objectNamesAreEqual(this.foreignTable.getTable().getTableName(), foreignKeyDefinition.foreignTable.getTable().getTableName());
            if (bl && this.compareFKRules) {
                bl = bl && this.getUpdateRuleValue() == foreignKeyDefinition.getUpdateRuleValue() && this.getDeleteRuleValue() == foreignKeyDefinition.getDeleteRuleValue() && this.getDeferrableRuleValue() == foreignKeyDefinition.getDeferrableRuleValue();
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(ForeignKeyDefinition foreignKeyDefinition) {
        try {
            return this.isDefinitionEqual(foreignKeyDefinition) && this.isNameEqual(foreignKeyDefinition);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

