/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.TriggerDefinition;
import workbench.db.report.TagWriter;
import workbench.util.StringUtil;

public class ReportTrigger {
    public final String TAG_TRIGGER_DEF = "trigger-def";
    public final String TAG_TRIGGER_NAME = "trigger-name";
    public final String TAG_TRIGGER_EVENT = "trigger-event";
    public final String TAG_TRIGGER_TYPE = "trigger-type";
    public final String TAG_TRIGGER_SOURCE = "trigger-source";
    private TriggerDefinition trigger;
    private TagWriter tagWriter = new TagWriter();
    private StringBuilder indent = new StringBuilder("  ");
    private StringBuilder indent2 = new StringBuilder("    ");
    private final Pattern PG_SOURCE = Pattern.compile("^---< Source for \\w+ >---$", 10);

    public ReportTrigger(TriggerDefinition triggerDefinition) {
        this.trigger = triggerDefinition;
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public TriggerDefinition getTrigger() {
        return this.trigger;
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder == null ? new StringBuilder(0) : stringBuilder;
        this.indent2 = new StringBuilder(this.indent);
        this.indent2.append("  ");
    }

    public CharSequence getSource() {
        CharSequence charSequence = this.trigger.getSource();
        if (StringUtil.isEmptyString(charSequence)) {
            return charSequence;
        }
        Matcher matcher = this.PG_SOURCE.matcher(charSequence);
        if (matcher.find()) {
            return charSequence.subSequence(0, matcher.start()).toString().trim();
        }
        return charSequence;
    }

    public StringBuilder getXml() {
        StringBuilder stringBuilder = new StringBuilder(500);
        this.tagWriter.appendOpenTag(stringBuilder, this.indent, "trigger-def");
        stringBuilder.append('\n');
        this.tagWriter.appendTag(stringBuilder, this.indent2, "trigger-name", this.trigger.getObjectName());
        this.tagWriter.appendTag(stringBuilder, this.indent2, "trigger-type", this.trigger.getTriggerType());
        this.tagWriter.appendTag(stringBuilder, this.indent2, "trigger-event", this.trigger.getTriggerEvent());
        this.tagWriter.appendTag(stringBuilder, this.indent2, "trigger-source", this.getSource(), true);
        this.tagWriter.appendCloseTag(stringBuilder, this.indent, "trigger-def");
        return stringBuilder;
    }
}

