/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.IndexDefinition;
import workbench.db.NoConfigException;
import workbench.db.TableCommentReader;
import workbench.db.TableDefinition;
import workbench.db.TableGrant;
import workbench.db.TableIdentifier;
import workbench.db.ViewGrantReader;
import workbench.db.WbConnection;
import workbench.db.report.IndexReporter;
import workbench.db.report.ReportColumn;
import workbench.db.report.ReportTableGrants;
import workbench.db.report.TagWriter;

public class ReportView {
    public static final String TAG_VIEW_DEF = "view-def";
    public static final String TAG_VIEW_NAME = "view-name";
    public static final String TAG_VIEW_CATALOG = "view-catalog";
    public static final String TAG_VIEW_SCHEMA = "view-schema";
    public static final String TAG_VIEW_COMMENT = "view-comment";
    public static final String TAG_VIEW_SOURCE = "view-source";
    public static final String TAG_VIEW_TYPE = "view-type";
    private TableIdentifier view;
    private ReportColumn[] columns;
    private String viewComment;
    private TagWriter tagWriter = new TagWriter();
    private IndexReporter index;
    private boolean includeGrants;
    private ReportTableGrants grants;
    private String schemaNameToUse = null;
    private boolean schemaAsCatalog;
    private CharSequence viewSource;

    public ReportView(TableIdentifier tableIdentifier, WbConnection wbConnection, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        Object object;
        Object object2;
        this.view = tableIdentifier;
        this.includeGrants = bl2;
        if (tableIdentifier.getSchema() == null) {
            tableIdentifier.setSchema(wbConnection.getMetadata().getCurrentSchema());
        }
        List<ColumnIdentifier> list = wbConnection.getMetadata().getTableColumns(tableIdentifier);
        Collections.sort(list);
        if (this.view.commentIsDefined()) {
            this.viewComment = this.view.getComment();
        } else {
            object2 = new TableCommentReader();
            this.viewComment = ((TableCommentReader)object2).getTableComment(wbConnection, this.view);
        }
        object2 = this.view.getSchema();
        if ((object2 == null || ((String)object2).length() == 0) && (object2 = wbConnection.getMetadata().getSchemaToUse()) != null) {
            this.view.setSchema((String)object2);
        }
        try {
            object = wbConnection.getMetadata().getViewReader();
            this.viewSource = bl3 ? object.getFullViewSource(new TableDefinition(tableIdentifier, list)) : object.getViewSource(tableIdentifier);
        }
        catch (NoConfigException noConfigException) {
            this.viewSource = "";
        }
        if (this.includeGrants && (object = ViewGrantReader.createViewGrantReader(wbConnection)) != null) {
            Collection<TableGrant> collection = ((ViewGrantReader)object).getViewGrants(wbConnection, tableIdentifier);
            this.grants = new ReportTableGrants(collection);
        }
        this.setColumns(list);
        if (bl) {
            this.index = new IndexReporter(tableIdentifier, wbConnection, false);
        }
        this.schemaAsCatalog = !wbConnection.getDbSettings().supportsSchemas();
    }

    public ReportTableGrants getGrants() {
        return this.grants;
    }

    public Collection<IndexDefinition> getIndexList() {
        if (this.index == null) {
            return null;
        }
        return this.index.getIndexList();
    }

    public void setColumns(List<ColumnIdentifier> list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        this.columns = new ReportColumn[n];
        int n2 = 0;
        for (ColumnIdentifier columnIdentifier : list) {
            this.columns[n2] = new ReportColumn(columnIdentifier);
            this.columns[n2].setIsRealColumn(false);
            ++n2;
        }
    }

    public void setSchemaNameToUse(String string) {
        this.schemaNameToUse = string;
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public StringBuilder getXml() {
        return this.getXml(new StringBuilder("  "));
    }

    public TableIdentifier getView() {
        return this.view;
    }

    public String getViewComment() {
        return this.viewComment;
    }

    public CharSequence getViewSource() {
        return this.viewSource;
    }

    public void appendTableNameXml(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (this.schemaNameToUse != null) {
            if (this.schemaAsCatalog) {
                this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_VIEW_CATALOG, this.schemaNameToUse);
            } else {
                this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_VIEW_SCHEMA, this.schemaNameToUse);
            }
        } else {
            this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_VIEW_CATALOG, this.view.getCatalog());
            this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_VIEW_SCHEMA, this.view.getSchema());
        }
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_VIEW_NAME, this.view.getTableName());
    }

    public StringBuilder getXml(StringBuilder stringBuilder) {
        return this.getXml(stringBuilder, true);
    }

    public StringBuilder getXml(StringBuilder stringBuilder, boolean bl) {
        StringBuilder stringBuilder2 = new StringBuilder(this.viewSource.length() + 200);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_VIEW_DEF, "name", this.view.getTableName());
        stringBuilder2.append('\n');
        this.appendTableNameXml(stringBuilder2, stringBuilder3);
        this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_VIEW_COMMENT, this.viewComment, true);
        if (!this.view.getType().equals("VIEW")) {
            this.tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_VIEW_TYPE, this.view.getType());
        }
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            this.columns[i].appendXml(stringBuilder2, stringBuilder3);
        }
        if (this.grants != null) {
            this.grants.appendXml(stringBuilder2, stringBuilder3);
        }
        ReportView.writeSourceTag(this.tagWriter, stringBuilder2, stringBuilder3, this.viewSource);
        if (bl && this.index != null) {
            this.index.appendXml(stringBuilder2, stringBuilder3, null);
        }
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_VIEW_DEF);
        return stringBuilder2;
    }

    public static void writeSourceTag(TagWriter tagWriter, StringBuilder stringBuilder, StringBuilder stringBuilder2, CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_VIEW_SOURCE);
        stringBuilder.append("<![CDATA[");
        stringBuilder.append(charSequence);
        stringBuilder.append("]]>");
        tagWriter.appendCloseTag(stringBuilder, null, TAG_VIEW_SOURCE);
    }
}

